/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement.core;

import com.fr.base.FRContext;
import com.fr.base.core.list.IntList;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.report.cellElement.core.Group;
import com.fr.report.cellElement.core.RecordGrouper;
import com.fr.report.script.Calculator;
import java.util.Iterator;
import java.util.logging.Level;

public class MonoGrouper
extends RecordGrouper {
    public Group[] group(TableData tableData, int n, int[] nArray, Calculator calculator) {
        if (n == -1) {
            return super.group(tableData, n, nArray, calculator);
        }
        if (nArray == null) {
            try {
                nArray = IntList.range(tableData.getRowCount());
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
        }
        Group[] groupArray = new Group[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            try {
                groupArray[i] = new Group(tableData.getValueAt(n2, n), new int[]{n2});
                continue;
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
        }
        return groupArray;
    }

    public Iterator groupIterator(TableData tableData, int n, int[] nArray, Calculator calculator) {
        return new MonoIterator(tableData, n, nArray, calculator);
    }

    private static class MonoIterator
    implements Iterator {
        private TableData data;
        private int columnIndex;
        private int[] rows;
        private Calculator calculator;
        private int nextArrayIndex = -1;
        private int nextTableDataIndex = -1;
        private Group nextGroup;

        MonoIterator(TableData tableData, int n, int[] nArray, Calculator calculator) {
            this.data = tableData;
            this.columnIndex = n;
            this.rows = nArray;
            this.calculator = calculator;
            this.findNext();
        }

        private void findNext() {
            if (this.rows == null) {
                ++this.nextTableDataIndex;
            } else {
                ++this.nextArrayIndex;
                this.nextTableDataIndex = this.nextArrayIndex >= this.rows.length ? -1 : this.rows[this.nextArrayIndex];
            }
            try {
                this.nextGroup = this.nextTableDataIndex < 0 || !this.data.hasRow(this.nextTableDataIndex) ? null : (this.columnIndex == -1 ? new Group(new Integer(this.nextTableDataIndex + 1), new int[]{this.nextTableDataIndex}) : new Group(this.data.getValueAt(this.nextTableDataIndex, this.columnIndex), new int[]{this.nextTableDataIndex}));
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                this.nextGroup = null;
            }
        }

        public boolean hasNext() {
            return this.nextGroup != null;
        }

        public Object next() {
            Group group = this.nextGroup;
            this.findNext();
            return group;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

