/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement.core;

import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.RWorkBook;
import com.fr.report.Report;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.painter.AbstractPainter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public class ResultSubReport
extends AbstractPainter {
    public static final String XML_TAG = "ResultSubReport";
    private ResultWorkBook packee;

    public ResultSubReport() {
        this(new RWorkBook());
    }

    public ResultSubReport(ResultWorkBook resultWorkBook) {
        this.packee = resultWorkBook;
    }

    public ResultWorkBook getPackee() {
        return this.packee;
    }

    public void setPackee(ResultWorkBook resultWorkBook) {
        this.packee = resultWorkBook;
    }

    public void paint(Graphics graphics, int n, int n2, Style style) {
        Rectangle rectangle;
        CellElement cellElement;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Report report = null;
        if (this.packee.getReportCount() > 0) {
            report = this.packee.getReport(0);
        }
        if (report == null) {
            return;
        }
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(report);
        DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(report);
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
        ArrayList<Rectangle> arrayList2 = new ArrayList<Rectangle>();
        Iterator iterator = report.cellIterator();
        while (iterator.hasNext()) {
            cellElement = (CellElement)iterator.next();
            Rectangle rectangle2 = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            rectangle = new Rectangle(dynamicValueList.getRangeValue(0, rectangle2.x), dynamicValueList2.getRangeValue(0, rectangle2.y), dynamicValueList.getRangeValue(rectangle2.x, rectangle2.x + rectangle2.width), dynamicValueList2.getRangeValue(rectangle2.y, rectangle2.y + rectangle2.height));
            arrayList.add(cellElement);
            arrayList2.add(rectangle);
            graphics2D.translate(rectangle.x, rectangle.y);
            PaintUtils.paintBackground(graphics2D, cellElement.getStyle(), rectangle.width, rectangle.height);
            PaintUtils.paintContent(graphics2D, cellElement.getValue(), cellElement.getStyle(), rectangle.width, rectangle.height);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            cellElement = (CellElement)arrayList.get(i);
            rectangle = (Rectangle)arrayList2.get(i);
            graphics2D.translate(rectangle.x, rectangle.y);
            PaintUtils.paintBorder(graphics2D, cellElement.getStyle(), rectangle.width, rectangle.height);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        if (xMLableReader.isChildNode() && (string2 = xMLableReader.getTagName()).equals("packee") && (string = xMLableReader.getAttr("class")) != null) {
            try {
                ResultWorkBook resultWorkBook = null;
                Object obj = Class.forName(string).newInstance();
                if (obj instanceof ResultWorkBook) {
                    resultWorkBook = (ResultWorkBook)obj;
                    this.setPackee(resultWorkBook);
                    xMLableReader.readXMLObject(resultWorkBook);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, "Failed to read resultSubReport");
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("packee").attr("class", this.packee.getClass().getName());
        this.packee.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ResultSubReport resultSubReport = (ResultSubReport)super.clone();
        resultSubReport.setPackee((ResultWorkBook)this.packee.clone());
        return resultSubReport;
    }
}

