/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement.core;

import com.fr.base.FRContext;
import com.fr.base.core.list.IntList;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.util.function.DataFunction;
import com.fr.report.cellElement.core.Group;
import com.fr.report.cellElement.core.RecordGrouper;
import com.fr.report.script.Calculator;
import java.util.logging.Level;

public class SummaryGrouper
extends RecordGrouper {
    private DataFunction function;

    public DataFunction getFunction() {
        return this.function;
    }

    public void setFunction(DataFunction dataFunction) {
        this.function = dataFunction;
    }

    public Group[] group(TableData tableData, int n, int[] nArray, Calculator calculator) {
        Object object;
        if (this.function == null) {
            object = new Integer(0);
        } else {
            this.function.reset();
            if (nArray == null) {
                try {
                    nArray = IntList.range(tableData.getRowCount());
                }
                catch (TableDataException tableDataException) {
                    FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                }
            }
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    if (n == -1) {
                        this.function.addData(new Integer(nArray[i] + 1));
                        continue;
                    }
                    this.function.addData(tableData.getValueAt(nArray[i], n));
                    continue;
                }
                catch (TableDataException tableDataException) {
                    FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                }
            }
            object = this.function.getResult();
        }
        return new Group[]{new Group(object, nArray)};
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "FN".equals(xMLableReader.getTagName())) {
            this.setFunction(DataXMLUtils.readXMLDataFunction(xMLableReader.getElementValue()));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.function != null) {
            xMLPrintWriter.startTAG("FN").textNode(this.function.getClass().getName()).end();
        }
    }
}

