/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import java.io.Serializable;

public class DynamicCellViewList
implements Cloneable,
Serializable {
    private int[] intArray;
    private int defaultValue = 1;

    public DynamicCellViewList(int n) {
        this(n, 10);
    }

    public DynamicCellViewList(int n, int[] nArray) {
        this.defaultValue = n;
        this.intArray = nArray;
    }

    public DynamicCellViewList(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        this.defaultValue = n;
        this.intArray = this.createIntArray(n2);
    }

    public void trimToSize() {
        int n;
        for (n = this.intArray.length - 1; n >= 0 && this.intArray[n] == this.defaultValue; --n) {
        }
        if (n < this.intArray.length - 1) {
            int[] nArray = this.intArray;
            this.intArray = this.createIntArray(n + 1);
            System.arraycopy(nArray, 0, this.intArray, 0, this.intArray.length);
        }
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int n) {
        this.defaultValue = n;
    }

    public int getLastIndex() {
        this.trimToSize();
        return this.intArray.length - 1;
    }

    public int get(int n) {
        if (n < 0 || n > this.intArray.length - 1) {
            return this.defaultValue;
        }
        return this.intArray[n];
    }

    public void set(int n, int n2) {
        if (n < 0) {
            return;
        }
        this.checkIntArrayBounds(n);
        this.intArray[n] = n2;
    }

    public void insert(int n) {
        this.insert(n, 1);
    }

    public void insert(int n, int n2) {
        if (n < 0 || n2 <= 0) {
            return;
        }
        this.checkIntArrayBounds(n);
        int[] nArray = this.intArray;
        this.intArray = new int[nArray.length + n2];
        for (int i = n; i < n + n2; ++i) {
            this.intArray[i] = this.defaultValue;
        }
        System.arraycopy(nArray, 0, this.intArray, 0, n);
        System.arraycopy(nArray, n, this.intArray, n + n2, nArray.length - n);
    }

    public void remove(int n) {
        if (n < 0 || n > this.intArray.length - 1) {
            return;
        }
        int[] nArray = this.intArray;
        this.intArray = new int[this.intArray.length - 1];
        System.arraycopy(nArray, 0, this.intArray, 0, n);
        System.arraycopy(nArray, n + 1, this.intArray, n, nArray.length - (n + 1));
    }

    public void removeRange(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.intArray.length || n2 >= this.intArray.length || n >= n2) {
            return;
        }
        int[] nArray = this.intArray;
        this.intArray = new int[nArray.length - (n2 - n + 1)];
        System.arraycopy(nArray, 0, this.intArray, 0, n);
        System.arraycopy(nArray, n2 + 1, this.intArray, n, nArray.length - (n2 + 1));
    }

    public void reset() {
        for (int i = 0; i < this.intArray.length; ++i) {
            this.intArray[i] = this.defaultValue;
        }
    }

    public double getRangeValueFromZero(int n) {
        return this.getRangeValue(0, n);
    }

    public double getRangeValue(int n, int n2) {
        double d = 0.0;
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        for (int i = n3; i < n4; ++i) {
            d += (double)this.get(i);
        }
        return n <= n2 ? d : -d;
    }

    public int getValueIndex(double d) {
        return this.getValueIndex(d, 0);
    }

    public int getValueIndex(double d, int n) {
        double d2 = 0.0;
        int n2 = n;
        while (!((d2 += (double)this.get(n2)) > d)) {
            ++n2;
        }
        return n2;
    }

    private void checkIntArrayBounds(int n) {
        while (n >= this.intArray.length) {
            this.doubleIntArray();
        }
    }

    private int[] createIntArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.defaultValue;
        }
        return nArray;
    }

    private void doubleIntArray() {
        int[] nArray = this.intArray;
        this.intArray = new int[Math.max(10, nArray.length * 2)];
        System.arraycopy(nArray, 0, this.intArray, 0, nArray.length);
        for (int i = nArray.length; i < this.intArray.length; ++i) {
            this.intArray[i] = this.defaultValue;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        this.trimToSize();
        DynamicCellViewList dynamicCellViewList = (DynamicCellViewList)super.clone();
        int[] nArray = new int[this.intArray.length];
        System.arraycopy(this.intArray, 0, nArray, 0, nArray.length);
        dynamicCellViewList.intArray = nArray;
        return dynamicCellViewList;
    }
}

