/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import java.io.Serializable;
import java.util.Arrays;

public class DynamicValueList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[] elementInts;
    private int size;
    private int defaultValue = 1;

    public DynamicValueList(int n) {
        this(n, 10);
    }

    public DynamicValueList(int n, int n2) {
        this.elementInts = new int[n2];
        Arrays.fill(this.elementInts, n);
        this.size = this.elementInts.length;
        this.defaultValue = n;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int n) {
        this.defaultValue = n;
    }

    public int size() {
        return this.size;
    }

    public int get(int n) {
        if (n < 0 || n >= this.size) {
            return this.defaultValue;
        }
        return this.elementInts[n];
    }

    public void set(int n, int n2) {
        if (n < 0) {
            return;
        }
        if (n >= this.size) {
            if (n2 == this.defaultValue) {
                return;
            }
            this.ensureCapacity(n + 1);
        }
        this.elementInts[n] = n2;
        if (n >= this.size) {
            this.size = n + 1;
        }
    }

    public void insert(int n) {
        this.insert(n, 1);
    }

    public void insert(int n, int n2) {
        if (n < 0 || n2 <= 0 || n >= this.size) {
            return;
        }
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.elementInts, n, this.elementInts, n + n2, this.size - n);
        Arrays.fill(this.elementInts, n, n + n2, this.defaultValue);
        this.size += n2;
    }

    public int remove(int n) {
        if (n < 0 || n >= this.size) {
            return this.defaultValue;
        }
        int n2 = this.elementInts[n];
        int n3 = this.size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementInts, n + 1, this.elementInts, n, n3);
        }
        this.elementInts[--this.size] = this.defaultValue;
        return n2;
    }

    public void reset() {
        Arrays.fill(this.elementInts, this.defaultValue);
        this.size = 0;
    }

    public int getRangeValueFromZero(int n) {
        return this.getRangeValue(0, n);
    }

    public int getRangeValue(int n, int n2) {
        int n3 = 0;
        int n4 = Math.min(n, n2);
        int n5 = Math.max(n, n2);
        int n6 = Math.min(n5, this.elementInts.length);
        for (int i = n4 = Math.max(0, n4); i < n6; ++i) {
            n3 += this.elementInts[i];
        }
        if (n5 > this.elementInts.length) {
            n3 += (n5 - Math.max(this.elementInts.length, n4)) * this.defaultValue;
        }
        return n <= n2 ? n3 : -n3;
    }

    public int getValueIndex(int n) {
        return this.getValueIndex(n, 0);
    }

    public int getValueIndex(int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        while ((n3 += this.get(n4)) <= n) {
            ++n4;
        }
        return n4;
    }

    private void ensureCapacity(int n) {
        int n2 = this.elementInts.length;
        if (n > n2) {
            int[] nArray = this.elementInts;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementInts = new int[n3];
            System.arraycopy(nArray, 0, this.elementInts, 0, nArray.length);
            Arrays.fill(this.elementInts, nArray.length, this.elementInts.length, this.defaultValue);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DynamicValueList dynamicValueList = (DynamicValueList)super.clone();
        dynamicValueList.elementInts = (int[])this.elementInts.clone();
        return dynamicValueList;
    }
}

