/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.FT;
import com.fr.base.core.list.IntList;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.Margin;
import com.fr.report.PageInfo;
import com.fr.report.PaperSetting;
import com.fr.report.PaperSize;
import com.fr.report.ReportPage;
import com.fr.report.ReportPageAttr;
import com.fr.report.ReportSettings;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.core.DeathCycleException;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaginateReport;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class PaginateReportPageGenerator {
    private PaginateReport showReport;
    private ReportSettings reportSettings;
    private DynamicValueList columnWidthList;
    private DynamicValueList rowHeightList;
    private List pageColumnIndexList = new ArrayList();
    private List pageRowIndexList = new ArrayList();
    private int pageCount = 0;
    private List reportPageList = new ArrayList();
    private PaperSetting setting;

    public PaginateReportPageGenerator(PaginateReport paginateReport, PaperSetting paperSetting) {
        this.showReport = paginateReport;
        this.reportSettings = ReportUtils.getReportSettings(this.showReport);
        this.columnWidthList = ReportHelper.getColumnWidthList(paginateReport);
        this.rowHeightList = ReportHelper.getRowHeightList(paginateReport);
        this.setting = paperSetting;
        this.dealWithPageInfor();
        this.generatePages();
    }

    public ReportPage[] getReportPages() {
        return this.reportPageList.toArray(new ReportPage[this.reportPageList.size()]);
    }

    private void dealWithPageInfor() {
        Cloneable cloneable;
        Cloneable cloneable2;
        int n;
        int n2;
        if (this.setting == null) {
            n2 = Integer.MAX_VALUE;
            n = Integer.MAX_VALUE;
        } else {
            PaperSize paperSize = this.setting.getPaperSize();
            Margin margin = this.setting.getMargin();
            double d = paperSize.getWidth();
            double d2 = paperSize.getHeight();
            if (this.setting.getOrientation() == 1) {
                d = paperSize.getHeight();
                d2 = paperSize.getWidth();
            }
            n2 = (int)((d - margin.getLeft() - margin.getRight()) * 96.0);
            n = (int)((d2 - margin.getTop() - margin.getBottom() - this.reportSettings.getHeaderHeight() - this.reportSettings.getFooterHeight()) * 96.0);
        }
        if (n2 <= 0 || n <= 0) {
            throw new RuntimeException("paperPaintWidth/paperPaintHeight is less than 0");
        }
        int n3 = 0;
        int n4 = 0;
        Iterator iterator = this.showReport.floatIterator();
        while (iterator.hasNext()) {
            cloneable2 = (FloatElement)iterator.next();
            Point[] pointArray = ReportHelper.calculateLastColumnAndRowOfFloatElement(this.showReport, (FloatElement)cloneable2);
            n3 = Math.max(n3, pointArray[0].x + 1);
            n4 = Math.max(n4, pointArray[0].y + 1);
        }
        n3 = Math.max(n3, this.showReport.getColumnCount());
        n4 = Math.max(n4, this.showReport.getRowCount());
        cloneable2 = new IntList();
        IntList intList = new IntList();
        Iterator iterator2 = this.showReport.cellIterator();
        while (iterator2.hasNext()) {
            int n5;
            CellElement cellElement = (CellElement)iterator2.next();
            cloneable = cellElement.getCellPageAttr();
            if (cloneable == null) continue;
            if (((CellPageAttr)cloneable).isPageAfterColumn() && (n5 = cellElement.getColumn() + cellElement.getColumnSpan()) > 0) {
                ((IntList)cloneable2).add(n5);
            }
            if (((CellPageAttr)cloneable).isPageBeforeColumn() && (n5 = cellElement.getColumn()) > 0) {
                ((IntList)cloneable2).add(n5);
            }
            if (((CellPageAttr)cloneable).isPageAfterRow() && (n5 = cellElement.getRow() + cellElement.getRowSpan()) > 0) {
                intList.add(n5);
            }
            if (!((CellPageAttr)cloneable).isPageBeforeRow() || (n5 = cellElement.getRow()) <= 0) continue;
            intList.add(n5);
        }
        cloneable = this.showReport.getReportPageAttr();
        if (cloneable == null || ((ReportPageAttr)cloneable).isUnUsed()) {
            int n6;
            this.pageColumnIndexList.add(new IdxHeaderFooter(0));
            int n7 = 0;
            int n8 = 0;
            for (n6 = 0; n6 < n3; ++n6) {
                n8 = this.columnWidthList.get(n6);
                if ((n7 += n8) <= n2 && !((IntList)cloneable2).contain(n6)) continue;
                if (((IdxHeaderFooter)this.pageColumnIndexList.get(this.pageColumnIndexList.size() - 1)).getIndex() == n6) {
                    throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with columnIndex: " + n6);
                }
                this.pageColumnIndexList.add(new IdxHeaderFooter(n6));
                n7 = n8;
            }
            this.pageColumnIndexList.add(new IdxHeaderFooter(n3));
            this.pageRowIndexList.add(new IdxHeaderFooter(0));
            n7 = 0;
            n8 = 0;
            for (n6 = 0; n6 < n4; ++n6) {
                n8 = this.rowHeightList.get(n6);
                if ((n7 += n8) <= n && !intList.contain(n6)) continue;
                if (((IdxHeaderFooter)this.pageRowIndexList.get(this.pageRowIndexList.size() - 1)).getIndex() == n6) {
                    throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with rowIndex: " + n6);
                }
                this.pageRowIndexList.add(new IdxHeaderFooter(n6));
                n7 = n8;
            }
            this.pageRowIndexList.add(new IdxHeaderFooter(n4));
        } else {
            int n9;
            int n10;
            int n11;
            int[] nArray = this.showReport.get_col_oi_int_list();
            IntList intList2 = new IntList();
            IntList intList3 = new IntList();
            int n12 = 0;
            IntList intList4 = null;
            block4: for (n11 = ((ReportPageAttr)cloneable).getRepeatFooterColumnFrom(); n11 <= ((ReportPageAttr)cloneable).getRepeatFooterColumnTo(); ++n11) {
                for (int i = 0; i < n3; ++i) {
                    if (nArray[i] != n11) continue;
                    n12 += this.columnWidthList.get(i);
                    if (intList4 == null) {
                        intList4 = new IntList();
                    }
                    intList4.add(i);
                    intList3.add(n11);
                    continue block4;
                }
            }
            this.pageColumnIndexList.add(new IdxHeaderFooter(0, null, intList4));
            if (n12 > n2) {
                throw new RuntimeException("repeated column width is larger than paper width.");
            }
            for (n11 = 0; n11 < n3; ++n11) {
                int n13;
                if (intList3.contain(nArray[n11]) && !((IntList)cloneable2).contain(n11)) {
                    IntList intList5 = ((IdxHeaderFooter)this.pageColumnIndexList.get(this.pageColumnIndexList.size() - 1)).getFooterRepeatList();
                    if (intList5 == null || (n13 = intList5.indexOf(n11)) == -1) continue;
                    intList5.remove(n13);
                    continue;
                }
                if ((n12 += this.columnWidthList.get(n11)) <= n2 && !((IntList)cloneable2).contain(n11)) continue;
                if (((IdxHeaderFooter)this.pageColumnIndexList.get(this.pageColumnIndexList.size() - 1)).getIndex() == n11) {
                    throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with columnIndex: " + n11);
                }
                int n14 = 1;
                for (n13 = n11; n13 < n3; ++n13) {
                    if (intList3.contain(nArray[n13])) continue;
                    n14 = 0;
                    break;
                }
                if (n14 != 0 && this.pageColumnIndexList.size() > 0) {
                    while (n11 < n3) {
                        int n15;
                        IntList intList6 = ((IdxHeaderFooter)this.pageColumnIndexList.get(this.pageColumnIndexList.size() - 1)).getFooterRepeatList();
                        if (intList6 != null && (n15 = intList6.indexOf(n11)) != -1) {
                            intList6.remove(n15);
                        }
                        ++n11;
                    }
                    break;
                }
                intList2.clear();
                intList3.clear();
                n12 = 0;
                n14 = n11;
                IntList intList7 = null;
                IntList intList8 = null;
                while (n11 < n3 && ((ReportPageAttr)cloneable).getRepeatHeaderColumnFrom() <= nArray[n11] && nArray[n11] <= ((ReportPageAttr)cloneable).getRepeatHeaderColumnTo()) {
                    n12 += this.columnWidthList.get(n11);
                    intList2.add(nArray[n11]);
                    ++n11;
                }
                if (n11 >= n3) {
                    if (n12 > n2) {
                        throw new RuntimeException("repeated column width is larger than paper width.");
                    }
                    this.pageColumnIndexList.add(new IdxHeaderFooter(n14, intList7, intList8));
                    break;
                }
                block10: for (n10 = ((ReportPageAttr)cloneable).getRepeatHeaderColumnFrom(); n10 <= ((ReportPageAttr)cloneable).getRepeatHeaderColumnTo(); ++n10) {
                    for (n9 = n14 - 1; n9 >= 0; --n9) {
                        if (nArray[n9] != n10) continue;
                        if (intList2.contain(n10)) continue block10;
                        n12 += this.columnWidthList.get(n9);
                        if (intList7 == null) {
                            intList7 = new IntList();
                        }
                        intList7.add(n9);
                        continue block10;
                    }
                }
                block12: for (n10 = ((ReportPageAttr)cloneable).getRepeatFooterColumnFrom(); n10 <= ((ReportPageAttr)cloneable).getRepeatFooterColumnTo(); ++n10) {
                    for (n9 = n11 + 1; n9 < n3; ++n9) {
                        if (nArray[n9] != n10) continue;
                        n12 += this.columnWidthList.get(n9);
                        if (intList8 == null) {
                            intList8 = new IntList();
                        }
                        intList8.add(n9);
                        intList3.add(n10);
                        continue block12;
                    }
                }
                this.pageColumnIndexList.add(new IdxHeaderFooter(n14, intList7, intList8));
                if ((n12 += this.columnWidthList.get(n11)) <= n2) continue;
                throw new RuntimeException("repeated column width is larger than paper width.");
            }
            this.pageColumnIndexList.add(new IdxHeaderFooter(n3));
            nArray = this.showReport.get_row_oi_int_list();
            intList2 = new IntList();
            intList3 = new IntList();
            n12 = 0;
            intList4 = null;
            block14: for (n11 = ((ReportPageAttr)cloneable).getRepeatFooterRowFrom(); n11 <= ((ReportPageAttr)cloneable).getRepeatFooterRowTo(); ++n11) {
                for (int i = 0; i < n4; ++i) {
                    if (nArray[i] != n11) continue;
                    n12 += this.rowHeightList.get(i);
                    if (intList4 == null) {
                        intList4 = new IntList();
                    }
                    intList4.add(i);
                    intList3.add(n11);
                    continue block14;
                }
            }
            this.pageRowIndexList.add(new IdxHeaderFooter(0, null, intList4));
            if (n12 > n) {
                throw new RuntimeException("repeated row height is larger than paper height.");
            }
            for (n11 = 0; n11 < n4; ++n11) {
                if (intList3.contain(nArray[n11]) && !intList.contain(n11)) {
                    int n16;
                    IntList intList9 = ((IdxHeaderFooter)this.pageRowIndexList.get(this.pageRowIndexList.size() - 1)).getFooterRepeatList();
                    if (intList9 == null || (n16 = intList9.indexOf(n11)) == -1) continue;
                    intList9.remove(n16);
                    continue;
                }
                if ((n12 += this.rowHeightList.get(n11)) <= n && !intList.contain(n11)) continue;
                if (((IdxHeaderFooter)this.pageRowIndexList.get(this.pageRowIndexList.size() - 1)).getIndex() == n11) {
                    throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with rowIndex: " + n11);
                }
                int n17 = 1;
                for (int i = n11; i < n4; ++i) {
                    if (intList3.contain(nArray[i])) continue;
                    n17 = 0;
                    break;
                }
                if (n17 != 0 && this.pageRowIndexList.size() > 0) {
                    while (n11 < n4) {
                        int n18;
                        IntList intList10 = ((IdxHeaderFooter)this.pageRowIndexList.get(this.pageRowIndexList.size() - 1)).getFooterRepeatList();
                        if (intList10 != null && (n18 = intList10.indexOf(n11)) != -1) {
                            intList10.remove(n18);
                        }
                        ++n11;
                    }
                    break;
                }
                intList2.clear();
                intList3.clear();
                n12 = 0;
                n17 = n11;
                IntList intList11 = null;
                IntList intList12 = null;
                while (n11 < n4 && ((ReportPageAttr)cloneable).getRepeatHeaderRowFrom() <= nArray[n11] && nArray[n11] <= ((ReportPageAttr)cloneable).getRepeatHeaderRowTo()) {
                    n12 += this.rowHeightList.get(n11);
                    intList2.add(nArray[n11]);
                    ++n11;
                }
                if (n11 >= n4) {
                    if (n12 > n) {
                        throw new RuntimeException("repeated row height is larger than paper height.");
                    }
                    this.pageRowIndexList.add(new IdxHeaderFooter(n17, intList11, intList12));
                    break;
                }
                block20: for (n10 = ((ReportPageAttr)cloneable).getRepeatHeaderRowFrom(); n10 <= ((ReportPageAttr)cloneable).getRepeatHeaderRowTo(); ++n10) {
                    for (n9 = n17 - 1; n9 >= 0; --n9) {
                        if (nArray[n9] != n10) continue;
                        if (intList2.contain(n10)) continue block20;
                        n12 += this.rowHeightList.get(n9);
                        if (intList11 == null) {
                            intList11 = new IntList();
                        }
                        intList11.add(n9);
                        continue block20;
                    }
                }
                block22: for (n10 = ((ReportPageAttr)cloneable).getRepeatFooterRowFrom(); n10 <= ((ReportPageAttr)cloneable).getRepeatFooterRowTo(); ++n10) {
                    for (n9 = n11 + 1; n9 < n4; ++n9) {
                        if (nArray[n9] != n10) continue;
                        n12 += this.rowHeightList.get(n9);
                        if (intList12 == null) {
                            intList12 = new IntList();
                        }
                        intList12.add(n9);
                        intList3.add(n10);
                        continue block22;
                    }
                }
                this.pageRowIndexList.add(new IdxHeaderFooter(n17, intList11, intList12));
                if ((n12 += this.rowHeightList.get(n11)) <= n) continue;
                throw new RuntimeException("repeated row height is larger than paper height.");
            }
            this.pageRowIndexList.add(new IdxHeaderFooter(n4));
        }
        this.pageCount = (this.pageColumnIndexList.size() - 1) * (this.pageRowIndexList.size() - 1);
    }

    private void generatePages() {
        int n = 0;
        switch (this.reportSettings.getPageOrder()) {
            case 0: {
                int n2 = this.pageColumnIndexList.size();
                for (int i = 1; i < n2; ++i) {
                    int n3;
                    int n4;
                    int n5;
                    IntList intList;
                    int n6 = ((IdxHeaderFooter)this.pageColumnIndexList.get(i - 1)).getIndex();
                    int n7 = ((IdxHeaderFooter)this.pageColumnIndexList.get(i)).getIndex();
                    ArrayList<FT> arrayList = new ArrayList<FT>();
                    if (((IdxHeaderFooter)this.pageColumnIndexList.get(i - 1)).getHeadRepeatList() != null) {
                        intList = ((IdxHeaderFooter)this.pageColumnIndexList.get(i - 1)).getHeadRepeatList();
                        n5 = 0;
                        n4 = -1;
                        for (n3 = 0; n3 < intList.size(); ++n3) {
                            if (n3 == 0) {
                                n4 = intList.get(n3);
                                ++n5;
                                continue;
                            }
                            if (intList.get(n3) == n4 + n5) {
                                ++n5;
                                continue;
                            }
                            arrayList.add(new FT(n4, n4 + n5));
                            n4 = intList.get(n3);
                            n5 = 1;
                        }
                        if (n4 != -1 && n5 > 0) {
                            arrayList.add(new FT(n4, n4 + n5));
                        }
                    }
                    if (n7 > n6) {
                        arrayList.add(new FT(n6, n7));
                    }
                    if (((IdxHeaderFooter)this.pageColumnIndexList.get(i - 1)).getFooterRepeatList() != null) {
                        intList = ((IdxHeaderFooter)this.pageColumnIndexList.get(i - 1)).getFooterRepeatList();
                        n5 = 0;
                        n4 = -1;
                        for (n3 = 0; n3 < intList.size(); ++n3) {
                            if (n3 == 0) {
                                n4 = intList.get(n3);
                                ++n5;
                                continue;
                            }
                            if (intList.get(n3) == n4 + n5) {
                                ++n5;
                                continue;
                            }
                            arrayList.add(new FT(n4, n4 + n5));
                            n4 = intList.get(n3);
                            n5 = 1;
                        }
                        if (n4 != -1 && n5 > 0) {
                            arrayList.add(new FT(n4, n4 + n5));
                        }
                    }
                    n5 = this.pageRowIndexList.size();
                    for (int j = 1; j < n5; ++j) {
                        int n8;
                        int n9;
                        int n10;
                        IntList intList2;
                        n4 = ((IdxHeaderFooter)this.pageRowIndexList.get(j - 1)).getIndex();
                        n3 = ((IdxHeaderFooter)this.pageRowIndexList.get(j)).getIndex();
                        ArrayList<FT> arrayList2 = new ArrayList<FT>();
                        if (((IdxHeaderFooter)this.pageRowIndexList.get(j - 1)).getHeadRepeatList() != null) {
                            intList2 = ((IdxHeaderFooter)this.pageRowIndexList.get(j - 1)).getHeadRepeatList();
                            n10 = 0;
                            n9 = -1;
                            for (n8 = 0; n8 < intList2.size(); ++n8) {
                                if (n8 == 0) {
                                    n9 = intList2.get(n8);
                                    ++n10;
                                    continue;
                                }
                                if (intList2.get(n8) == n9 + n10) {
                                    ++n10;
                                    continue;
                                }
                                arrayList2.add(new FT(n9, n9 + n10));
                                n9 = intList2.get(n8);
                                n10 = 1;
                            }
                            if (n9 != -1 && n10 > 0) {
                                arrayList2.add(new FT(n9, n9 + n10));
                            }
                        }
                        if (n3 > n4) {
                            arrayList2.add(new FT(n4, n3));
                        }
                        if (((IdxHeaderFooter)this.pageRowIndexList.get(j - 1)).getFooterRepeatList() != null) {
                            intList2 = ((IdxHeaderFooter)this.pageRowIndexList.get(j - 1)).getFooterRepeatList();
                            n10 = 0;
                            n9 = -1;
                            for (n8 = 0; n8 < intList2.size(); ++n8) {
                                if (n8 == 0) {
                                    n9 = intList2.get(n8);
                                    ++n10;
                                    continue;
                                }
                                if (intList2.get(n8) == n9 + n10) {
                                    ++n10;
                                    continue;
                                }
                                arrayList2.add(new FT(n9, n9 + n10));
                                n9 = intList2.get(n8);
                                n10 = 1;
                            }
                            if (n9 != -1 && n10 > 0) {
                                arrayList2.add(new FT(n9, n9 + n10));
                            }
                        }
                        this.dealWithReportPage(arrayList2, arrayList, n, i, j);
                        ++n;
                    }
                }
                break;
            }
            default: {
                int n11 = this.pageRowIndexList.size();
                for (int i = 1; i < n11; ++i) {
                    int n12;
                    int n13;
                    int n14;
                    int n15 = ((IdxHeaderFooter)this.pageRowIndexList.get(i - 1)).getIndex();
                    int n16 = ((IdxHeaderFooter)this.pageRowIndexList.get(i)).getIndex();
                    ArrayList<FT> arrayList = new ArrayList<FT>();
                    if (((IdxHeaderFooter)this.pageRowIndexList.get(i - 1)).getHeadRepeatList() != null) {
                        IntList intList = ((IdxHeaderFooter)this.pageRowIndexList.get(i - 1)).getHeadRepeatList();
                        n14 = 0;
                        n13 = -1;
                        for (n12 = 0; n12 < intList.size(); ++n12) {
                            if (n12 == 0) {
                                n13 = intList.get(n12);
                                ++n14;
                                continue;
                            }
                            if (intList.get(n12) == n13 + n14) {
                                ++n14;
                                continue;
                            }
                            arrayList.add(new FT(n13, n13 + n14));
                            n13 = intList.get(n12);
                            n14 = 1;
                        }
                        if (n13 != -1 && n14 > 0) {
                            arrayList.add(new FT(n13, n13 + n14));
                        }
                    }
                    if (n16 > n15) {
                        arrayList.add(new FT(n15, n16));
                    }
                    if (((IdxHeaderFooter)this.pageRowIndexList.get(i - 1)).getFooterRepeatList() != null) {
                        IntList intList = ((IdxHeaderFooter)this.pageRowIndexList.get(i - 1)).getFooterRepeatList();
                        n14 = 0;
                        n13 = -1;
                        for (n12 = 0; n12 < intList.size(); ++n12) {
                            if (n12 == 0) {
                                n13 = intList.get(n12);
                                ++n14;
                                continue;
                            }
                            if (intList.get(n12) == n13 + n14) {
                                ++n14;
                                continue;
                            }
                            arrayList.add(new FT(n13, n13 + n14));
                            n13 = intList.get(n12);
                            n14 = 1;
                        }
                        if (n13 != -1 && n14 > 0) {
                            arrayList.add(new FT(n13, n13 + n14));
                        }
                    }
                    n14 = this.pageColumnIndexList.size();
                    for (int j = 1; j < n14; ++j) {
                        int n17;
                        int n18;
                        int n19;
                        IntList intList;
                        n13 = ((IdxHeaderFooter)this.pageColumnIndexList.get(j - 1)).getIndex();
                        n12 = ((IdxHeaderFooter)this.pageColumnIndexList.get(j)).getIndex();
                        ArrayList<FT> arrayList3 = new ArrayList<FT>();
                        if (((IdxHeaderFooter)this.pageColumnIndexList.get(j - 1)).getHeadRepeatList() != null) {
                            intList = ((IdxHeaderFooter)this.pageColumnIndexList.get(j - 1)).getHeadRepeatList();
                            n19 = 0;
                            n18 = -1;
                            for (n17 = 0; n17 < intList.size(); ++n17) {
                                if (n17 == 0) {
                                    n18 = intList.get(n17);
                                    ++n19;
                                    continue;
                                }
                                if (intList.get(n17) == n18 + n19) {
                                    ++n19;
                                    continue;
                                }
                                arrayList3.add(new FT(n18, n18 + n19));
                                n18 = intList.get(n17);
                                n19 = 1;
                            }
                            if (n18 != -1 && n19 > 0) {
                                arrayList3.add(new FT(n18, n18 + n19));
                            }
                        }
                        if (n12 > n13) {
                            arrayList3.add(new FT(n13, n12));
                        }
                        if (((IdxHeaderFooter)this.pageColumnIndexList.get(j - 1)).getFooterRepeatList() != null) {
                            intList = ((IdxHeaderFooter)this.pageColumnIndexList.get(j - 1)).getFooterRepeatList();
                            n19 = 0;
                            n18 = -1;
                            for (n17 = 0; n17 < intList.size(); ++n17) {
                                if (n17 == 0) {
                                    n18 = intList.get(n17);
                                    ++n19;
                                    continue;
                                }
                                if (intList.get(n17) == n18 + n19) {
                                    ++n19;
                                    continue;
                                }
                                arrayList3.add(new FT(n18, n18 + n19));
                                n18 = intList.get(n17);
                                n19 = 1;
                            }
                            if (n18 != -1 && n19 > 0) {
                                arrayList3.add(new FT(n18, n18 + n19));
                            }
                        }
                        this.dealWithReportPage(arrayList, arrayList3, n, j, i);
                        ++n;
                    }
                }
            }
        }
        FRContext.getLogger().log(Level.INFO, Inter.getLocText("INFO-Page_is_Generated"));
    }

    private void dealWithReportPage(List list, List list2, int n, int n2, int n3) {
        ReportPage reportPage = new ReportPage(this.showReport, new PageInfo(), this.setting, list.toArray(new FT[list.size()]), list2.toArray(new FT[list2.size()]), n2, n3);
        int n4 = this.showReport.getReportSettings().getFirstPageNumber();
        int n5 = n + n4;
        int n6 = this.pageCount;
        reportPage.setCurrentPageNumber(n5);
        reportPage.getPageInfo().setTotalPages(n6);
        this.reportPageList.add(reportPage);
    }

    private static class IdxHeaderFooter {
        private int idx;
        private IntList headerRepeatList;
        private IntList footerRepeatList;

        public IdxHeaderFooter(int n) {
            this(n, null, null);
        }

        public IdxHeaderFooter(int n, IntList intList, IntList intList2) {
            this.idx = n;
            this.headerRepeatList = intList;
            this.footerRepeatList = intList2;
        }

        public int getIndex() {
            return this.idx;
        }

        public IntList getHeadRepeatList() {
            return this.headerRepeatList;
        }

        public IntList getFooterRepeatList() {
            return this.footerRepeatList;
        }
    }
}

