/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.Painter;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.BaseCoreConstants;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.GraphHelper;
import com.fr.data.condition.ListCondition;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.cellElement.BarcodeAttr;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.cellElement.core.ResultSubReport;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.barcode.BarCodeUtils;
import com.fr.report.core.barcode.BarcodeException;
import com.fr.report.core.barcode.BarcodeImpl;
import com.fr.report.web.ui.Widget;
import com.fr.util.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.sql.Clob;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;

public class PaintUtils {
    public static final int Cell_Mark_Size = 6;
    public static final Color Cell_HightLight_Mark_Color = Color.RED;
    public static final Color Cell_Present_Mark_Color = Color.CYAN;
    public static final Color Cell_Pagination_Mark_Color = Color.GREEN;
    public static final Color Cell_Write_Mark_Color = Color.BLUE;
    public static final Color Cell_ConditionFilter_Mark_Color = Color.ORANGE;
    public static final Color Cell_Direction_Mark_Color = Color.gray;
    private static Hashtable fontAttributeMapCache = new Hashtable();
    private static Rectangle2D tempRectangle2D = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);

    private PaintUtils() {
    }

    public static void paintGridCellContent(Graphics2D graphics2D, CellElement cellElement, int n, int n2) {
        Object object;
        Object object2;
        int n3 = 6;
        int n4 = 0;
        if (cellElement.getHighlightGroup() != null && cellElement.getHighlightGroup().size() > 0) {
            object2 = graphics2D.getPaint();
            graphics2D.setPaint(Cell_HightLight_Mark_Color);
            object = new GeneralPath(0, 3);
            ((Path2D.Float)object).moveTo(0.0f, 0.0f);
            ((Path2D.Float)object).lineTo(0.0f, n3);
            ((Path2D.Float)object).lineTo(n3, 0.0f);
            GraphHelper.fill(graphics2D, (Shape)object);
            graphics2D.setPaint((Paint)object2);
            ++n4;
        }
        if (cellElement.getPresent() != null) {
            object2 = graphics2D.getPaint();
            graphics2D.setPaint(Cell_Present_Mark_Color);
            object = new GeneralPath(0, 3);
            ((Path2D.Float)object).moveTo(0 + n4 * n3, 0.0f);
            ((Path2D.Float)object).lineTo(0 + n4 * n3, 6.0f);
            ((Path2D.Float)object).lineTo(n3 + n4 * n3, 0.0f);
            GraphHelper.fill(graphics2D, (Shape)object);
            graphics2D.setPaint((Paint)object2);
            ++n4;
        }
        if (cellElement.getCellPageAttr() != null && (cellElement.getCellPageAttr().isPageAfterColumn() || cellElement.getCellPageAttr().isPageBeforeColumn() || cellElement.getCellPageAttr().isPageAfterRow() || cellElement.getCellPageAttr().isPageBeforeRow())) {
            object2 = graphics2D.getPaint();
            graphics2D.setPaint(Cell_Pagination_Mark_Color);
            object = new GeneralPath(0, 3);
            ((Path2D.Float)object).moveTo(n, 0.0f);
            ((Path2D.Float)object).lineTo(n, n3);
            ((Path2D.Float)object).lineTo(n - n3, 0.0f);
            GraphHelper.fill(graphics2D, (Shape)object);
            graphics2D.setPaint((Paint)object2);
        }
        if (cellElement.getWidget() != null) {
            object2 = cellElement.getWidget();
            object = ((ImageIcon)ReportUtils.createWidgetIcon((Widget)object2)).getImage();
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.67f));
            graphics2D.drawImage((Image)object, n - 15, n2 - 15, 15, 15, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3));
        }
        if ((object2 = cellElement.getCellExpandAttr()) != null) {
            if (((CellExpandAttr)object2).getDirection() == 0) {
                object = graphics2D.getPaint();
                graphics2D.setPaint(Cell_Direction_Mark_Color);
                GraphHelper.drawLine(graphics2D, 2.0, 0.0, 2.0, 5.0);
                GraphHelper.drawLine(graphics2D, 2.0, 5.0, 0.0, 2.0);
                GraphHelper.drawLine(graphics2D, 2.0, 5.0, 4.0, 2.0);
                graphics2D.setPaint((Paint)object);
            } else if (((CellExpandAttr)object2).getDirection() == 1) {
                object = graphics2D.getPaint();
                graphics2D.setPaint(Cell_Direction_Mark_Color);
                GraphHelper.drawLine(graphics2D, 0.0, 2.0, 5.0, 2.0);
                GraphHelper.drawLine(graphics2D, 5.0, 2.0, 2.0, 0.0);
                GraphHelper.drawLine(graphics2D, 5.0, 2.0, 2.0, 4.0);
                graphics2D.setPaint((Paint)object);
            }
        }
        if ((object = cellElement.getValue()) == null) {
            return;
        }
        if (object instanceof DSColumn && ((DSColumn)object).getCondition() != null && (!(((DSColumn)object).getCondition() instanceof ListCondition) || ((ListCondition)((DSColumn)object).getCondition()).getJoinConditionCount() != 0)) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(Cell_ConditionFilter_Mark_Color);
            GeneralPath generalPath = new GeneralPath(0, 3);
            generalPath.moveTo(0.0f, n2);
            generalPath.lineTo(n3 + 1, n2);
            generalPath.lineTo(0.0f, n2 - 1 - n3);
            GraphHelper.fill(graphics2D, generalPath);
            graphics2D.setPaint(paint);
        }
        if (object instanceof Formula) {
            object = ((Formula)object).getContent();
        }
        if (object instanceof ResultSubReport) {
            object = BaseUtils.readImage("/com/fr/design/images/m_insert/subReport.png");
            GraphHelper.paintImage(graphics2D, n, n2, (Image)object, cellElement.getStyle(), 1, n > 16 ? 16 : n, n2 > 16 ? 16 : n2);
        } else {
            PaintUtils.paintContent(graphics2D, object, cellElement.getStyle(), n, n2);
        }
    }

    public static void paintFloatElement(Graphics2D graphics2D, FloatElement floatElement, int n, int n2) {
        PaintUtils.paintBackground(graphics2D, floatElement.getStyle(), n, n2);
        Object object = floatElement.getValue();
        if (object instanceof Formula) {
            object = ((Formula)object).getContent();
        }
        PaintUtils.paintContent(graphics2D, object, floatElement.getStyle(), n, n2);
        PaintUtils.paintBorder(graphics2D, floatElement.getStyle(), n, n2);
    }

    public static void paintFloatElement(Graphics2D graphics2D, FloatElement floatElement, Rectangle rectangle, Rectangle rectangle2) {
        PaintUtils.paintBackground(graphics2D, floatElement.getStyle(), rectangle, rectangle2);
        PaintUtils.paintContent(graphics2D, floatElement.getValue(), floatElement.getStyle(), rectangle, rectangle2);
        PaintUtils.paintBorder(graphics2D, floatElement.getStyle(), rectangle, rectangle2);
    }

    public static void paintContent(Graphics2D graphics2D, Object object, Style style, int n, int n2) {
        if (object == null || n == 0 || n2 == 0) {
            return;
        }
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        if (object instanceof Painter) {
            ((Painter)object).paint(graphics2D, n, n2, style);
        } else if (object instanceof Image) {
            GraphHelper.paintImage(graphics2D, n, n2, (Image)object, style, style.getImageLayout(), -1, -1);
        } else {
            String string = PaintUtils.valueToText(object, style.getFormat());
            PaintUtils.paintCellStyleString(graphics2D, n, n2, string, style);
        }
    }

    public static void paintContent(Graphics2D graphics2D, Object object, Style style, Rectangle rectangle, Rectangle rectangle2) {
        Shape shape = graphics2D.getClip();
        graphics2D.translate(rectangle.getX(), rectangle.getY());
        graphics2D.clip(rectangle2);
        PaintUtils.paintContent(graphics2D, object, style, rectangle.width, rectangle.height);
        graphics2D.translate(-rectangle.getX(), -rectangle.getY());
        graphics2D.setClip(shape);
    }

    public static void paintHTMLContent(Graphics2D graphics2D, String string, Style style, Rectangle rectangle, Rectangle rectangle2) {
        BufferedImage bufferedImage = PaintUtils.createHTMLContentBufferedImage(string, rectangle);
        PaintUtils.paintContent(graphics2D, (Object)bufferedImage, style, rectangle, rectangle2);
    }

    public static BufferedImage createHTMLContentBufferedImage(String string, Rectangle rectangle) {
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(rectangle.width, rectangle.height, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setSize((int)rectangle.getWidth() - 1, (int)rectangle.getHeight() - 1);
        jEditorPane.setText(string);
        jEditorPane.paint(graphics2D);
        int n = jEditorPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jEditorPane.getComponent(i);
            if (!(component instanceof Container)) continue;
            Container container = (Container)component;
            component.doLayout();
            int n2 = container.getComponentCount();
            if (n2 <= 0) continue;
            Component component2 = container.getComponent(0);
            graphics2D.translate(container.getX(), container.getY());
            component2.paint(graphics2D);
            graphics2D.translate(-container.getX(), -container.getY());
        }
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void paintBackground(Graphics2D graphics2D, Style style, double d, double d2) {
        if (style == null) {
            return;
        }
        Background background = style.getBackground();
        if (background != null) {
            tempRectangle2D.setRect(0.0, 0.0, d, d2);
            background.paint(graphics2D, tempRectangle2D);
        }
    }

    public static void paintBackground(Graphics2D graphics2D, Style style, Rectangle rectangle, Rectangle rectangle2) {
        Background background;
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        if ((background = style.getBackground()) != null) {
            background.paint(graphics2D, new Rectangle(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y, rectangle2.width, rectangle2.height));
        }
    }

    public static void paintBorder(Graphics2D graphics2D, Style style, double d, double d2) {
        int n;
        int n2;
        if (style == null) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        if (style.getBorderLeft() != 0) {
            n2 = GraphHelper.getLineStyleSize(style.getBorderLeft());
            n3 = n2 / 2;
        }
        if (style.getBorderRight() != 0) {
            n2 = GraphHelper.getLineStyleSize(style.getBorderRight());
            n4 = n2 / 2;
        }
        n2 = 0;
        int n5 = 0;
        if (style.getBorderTop() != 0) {
            n = GraphHelper.getLineStyleSize(style.getBorderTop());
            n2 = n / 2;
        }
        if (style.getBorderBottom() != 0) {
            n = GraphHelper.getLineStyleSize(style.getBorderBottom());
            n5 = n / 2;
        }
        if (style.getBorderTop() != 0) {
            graphics2D.setPaint(style.getBorderTopColor());
            GraphHelper.drawLine(graphics2D, 0 - n3, 0.0, d + (double)n4, 0.0, style.getBorderTop());
        }
        if (style.getBorderLeft() != 0) {
            graphics2D.setPaint(style.getBorderLeftColor());
            GraphHelper.drawLine(graphics2D, 0.0, 0 - n2, 0.0, d2 + (double)n5, style.getBorderLeft());
        }
        if (style.getBorderBottom() != 0) {
            graphics2D.setPaint(style.getBorderBottomColor());
            GraphHelper.drawLine(graphics2D, 0 - n3, d2, d + (double)n4, d2, style.getBorderBottom());
        }
        if (style.getBorderRight() != 0) {
            graphics2D.setPaint(style.getBorderRightColor());
            GraphHelper.drawLine(graphics2D, d, 0 - n2, d, d2 + (double)n5, style.getBorderRight());
        }
    }

    public static void paintBorder(Graphics2D graphics2D, Style style, Rectangle rectangle, Rectangle rectangle2) {
        int n;
        int n2;
        graphics2D.translate(rectangle.getX(), rectangle.getY());
        Rectangle rectangle3 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        if (rectangle2 != null) {
            rectangle3 = rectangle3.intersection(rectangle2);
        }
        graphics2D.translate(rectangle3.getX(), rectangle3.getY());
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        int n3 = 0;
        int n4 = 0;
        if (style.getBorderLeft() != 0) {
            n2 = GraphHelper.getLineStyleSize(style.getBorderLeft());
            n3 = n2 / 2;
        }
        if (style.getBorderRight() != 0) {
            n2 = GraphHelper.getLineStyleSize(style.getBorderRight());
            n4 = n2 / 2;
        }
        n2 = 0;
        int n5 = 0;
        if (style.getBorderTop() != 0) {
            n = GraphHelper.getLineStyleSize(style.getBorderTop());
            n2 = n / 2;
        }
        if (style.getBorderBottom() != 0) {
            n = GraphHelper.getLineStyleSize(style.getBorderBottom());
            n5 = n / 2;
        }
        if (style.getBorderTop() != 0) {
            graphics2D.setPaint(style.getBorderTopColor());
            GraphHelper.drawLine(graphics2D, 0 - n3, 0.0, rectangle3.getWidth() + (double)n4, 0.0, style.getBorderTop());
        }
        if (style.getBorderLeft() != 0) {
            graphics2D.setPaint(style.getBorderLeftColor());
            GraphHelper.drawLine(graphics2D, 0.0, 0 - n2, 0.0, rectangle3.getHeight() + (double)n5, style.getBorderLeft());
        }
        if (style.getBorderBottom() != 0) {
            graphics2D.setPaint(style.getBorderBottomColor());
            GraphHelper.drawLine(graphics2D, 0 - n3, rectangle3.getHeight(), rectangle3.getWidth() + (double)n4, rectangle3.getHeight(), style.getBorderBottom());
        }
        if (style.getBorderRight() != 0) {
            graphics2D.setPaint(style.getBorderRightColor());
            GraphHelper.drawLine(graphics2D, rectangle3.getWidth(), 0 - n2, rectangle3.getWidth(), rectangle3.getHeight() + (double)n5, style.getBorderRight());
        }
        graphics2D.translate(-rectangle3.getX(), -rectangle3.getY());
        graphics2D.translate(-rectangle.getX(), -rectangle.getY());
    }

    public static String valueToText(Object object, Format format) {
        Object object2 = object;
        String string = null;
        if (object != null) {
            Cloneable cloneable;
            if (object instanceof Formula) {
                cloneable = (Formula)object;
                if (ReportHelper.isNull(cloneable.getResult())) {
                    return cloneable.getContent();
                }
                object2 = cloneable.getResult();
            } else if (object instanceof Clob) {
                object2 = Utils.clob2String((Clob)object);
            }
            if (format != null) {
                if (format instanceof DateFormat) {
                    cloneable = DateUtils.object2Date(object2, true);
                    string = cloneable != null ? format.format(cloneable) : Utils.objectToString(object2);
                } else if (format instanceof NumberFormat) {
                    if (object2 instanceof Number) {
                        try {
                            string = ((NumberFormat)format).format(object2);
                        }
                        catch (Exception exception) {
                            string = Utils.objectToString(object2);
                        }
                    } else {
                        string = Utils.objectToString(object2);
                        try {
                            string = ((NumberFormat)format).format(Double.parseDouble(string));
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    try {
                        string = format.format(object2);
                    }
                    catch (Exception exception) {
                        string = Utils.objectToString(object2);
                    }
                }
            } else {
                string = Utils.objectToString(object2);
            }
        } else {
            string = "";
        }
        return string;
    }

    public static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static int getLineTextCount(String string, Style style, double d) {
        if (style.getRotation() != 0) {
            return 1;
        }
        int n = 0;
        FRFont fRFont = style.getFRFont();
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(fRFont);
        char[] cArray = string.toCharArray();
        if (style.getTextStyle() != 0) {
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\\') {
                    if (i + 1 < cArray.length && cArray[i + 1] == 'n') {
                        ++i;
                        ++n;
                        if (!bl) continue;
                        bl = false;
                        continue;
                    }
                    if (bl) continue;
                    bl = true;
                    continue;
                }
                if (cArray[i] == '\n') {
                    ++n;
                    if (!bl) continue;
                    bl = false;
                    continue;
                }
                if (bl) continue;
                bl = true;
            }
            if (bl) {
                ++n;
            }
            return n;
        }
        double d2 = d - (double)style.getPaddingLeft() - (double)style.getPaddingRight();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (i != 0 && PaintUtils.isLetter(cArray[i]) && PaintUtils.isLetter(cArray[i - 1])) {
                if ((double)(n3 + fontMetrics.charWidth(cArray[i])) > d2) {
                    if (n2 > 0) {
                        ++n;
                        if (bl) {
                            bl = false;
                        }
                        n2 = 0;
                    }
                    ++n;
                    n3 = 0;
                }
                n3 += fontMetrics.charWidth(cArray[i]);
                continue;
            }
            if (cArray[i] == '\n') {
                if ((double)(n2 + n3) > d2 && bl) {
                    ++n;
                    ++n;
                } else {
                    ++n;
                }
                if (bl) {
                    bl = false;
                }
                n2 = 0;
                n3 = 0;
                continue;
            }
            if (cArray[i] == '\\' && i + 1 < cArray.length && cArray[i + 1] == 'n') {
                ++i;
                n = (double)(n2 + n3) > d2 && bl ? (n += 2) : ++n;
                if (bl) {
                    bl = false;
                }
                n2 = 0;
                n3 = 0;
                continue;
            }
            if (cArray[i] == '\\' && i + 1 < cArray.length && cArray[i + 1] == '\\') {
                ++i;
            }
            if ((double)(n2 + n3) > d2 && bl) {
                ++n;
                n2 = 0;
            }
            if (!bl) {
                bl = true;
            }
            n2 += n3;
            n3 = 0;
            n3 = fontMetrics.charWidth(cArray[i]);
        }
        n = (double)(n2 + n3) > d2 && bl ? (n += 2) : ++n;
        return n;
    }

    public static List getLineTextList(String string, Style style, double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() <= 0) {
            return arrayList;
        }
        Style style2 = style = style == null ? Style.DEFAULT_STYLE : style;
        if (style.getRotation() != 0) {
            arrayList.add(string);
            return arrayList;
        }
        FRFont fRFont = style.getFRFont();
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(fRFont);
        if (style.getTextStyle() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\\') {
                    if (i + 1 < string.length() && string.charAt(i + 1) == 'n') {
                        ++i;
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                if (c == '\n') {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.length() > 0) {
                arrayList.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            return arrayList;
        }
        double d2 = d - (double)style.getPaddingLeft() - (double)style.getPaddingRight();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (i != 0 && PaintUtils.isLetter(string.charAt(i)) && PaintUtils.isLetter(string.charAt(i - 1))) {
                if ((double)(n2 + fontMetrics.charWidth(string.charAt(i))) > d2) {
                    if (n > 0) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        n = 0;
                    }
                    arrayList.add(stringBuffer2.toString());
                    stringBuffer2.delete(0, stringBuffer2.length());
                    n2 = 0;
                }
                stringBuffer2.append(string.charAt(i));
                n2 += fontMetrics.charWidth(string.charAt(i));
                continue;
            }
            if (string.charAt(i) == '\n') {
                if ((double)(n + n2) > d2 && stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                    arrayList.add(stringBuffer2.toString());
                } else {
                    stringBuffer.append(stringBuffer2);
                    arrayList.add(stringBuffer.toString());
                }
                stringBuffer.delete(0, stringBuffer.length());
                n = 0;
                stringBuffer2.delete(0, stringBuffer2.length());
                n2 = 0;
                continue;
            }
            if (string.charAt(i) == '\\' && i + 1 < string.length() && string.charAt(i + 1) == 'n') {
                ++i;
                if ((double)(n + n2) > d2 && stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                    arrayList.add(stringBuffer2.toString());
                } else {
                    stringBuffer.append(stringBuffer2);
                    arrayList.add(stringBuffer.toString());
                }
                stringBuffer.delete(0, stringBuffer.length());
                n = 0;
                stringBuffer2.delete(0, stringBuffer2.length());
                n2 = 0;
                continue;
            }
            if (string.charAt(i) == '\\' && i + 1 < string.length() && string.charAt(i + 1) == '\\') {
                ++i;
            }
            if ((double)(n + n2) > d2 && stringBuffer.length() > 0) {
                arrayList.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                n = 0;
            }
            stringBuffer.append(stringBuffer2);
            n += n2;
            stringBuffer2.delete(0, stringBuffer2.length());
            n2 = 0;
            stringBuffer2.append(string.charAt(i));
            n2 = fontMetrics.charWidth(string.charAt(i));
        }
        if ((double)(n + n2) > d2 && stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
            arrayList.add(stringBuffer2.toString());
        } else {
            stringBuffer.append(stringBuffer2);
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public static List getLineTextList_Vertical(String string, Style style, double d) {
        int n;
        int n2;
        if (style.getVerticalText() != 1) {
            return PaintUtils.getLineTextList(string, style, d);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() <= 0) {
            return arrayList;
        }
        if (style == null) {
            style = Style.DEFAULT_STYLE;
            return PaintUtils.getLineTextList(string, style, d);
        }
        if (style.getRotation() != 0) {
            arrayList.add(string);
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n3 = 0;
        FRFont fRFont = style.getFRFont();
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(fRFont);
        int n4 = fontMetrics.getHeight();
        int n5 = style.getTextStyle();
        if (n5 == 0) {
            double d2 = d;
            n2 = 1;
            int n6 = 0;
            int n7 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                if (n == 32 && n2 == 0) continue;
                if (n == 10) {
                    arrayList2.add(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                    n7 = 0;
                    n6 = 0;
                    continue;
                }
                if (n != 32) {
                    n2 = 0;
                }
                if (n == 92) {
                    if (i + 1 < string.length() && string.charAt(i + 1) == 'n') {
                        ++i;
                        arrayList2.add(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        n7 = 0;
                        n3 = Math.max(n3, ++n6);
                        n6 = 0;
                        continue;
                    }
                    stringBuffer.append((char)n);
                    n7 += n4;
                    n3 = Math.max(n3, ++n6);
                } else {
                    stringBuffer.append((char)n);
                    n7 += n4;
                    n3 = Math.max(n3, ++n6);
                }
                if (!((double)n7 > d2)) continue;
                arrayList2.add(stringBuffer.substring(0, stringBuffer.length() - 1));
                stringBuffer.delete(0, stringBuffer.length() - 1);
                n7 = n4;
                n3 = Math.max(n3, n6 - 1);
                n6 = 1;
            }
            arrayList2.add(stringBuffer.toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < string.length(); ++n2) {
                char c;
                if (n2 >= string.length() || (c = string.charAt(n2)) == '\n') continue;
                if (c == '\\') {
                    if (n2 + 1 < string.length() && string.charAt(n2 + 1) == 'n') {
                        ++n2;
                        continue;
                    }
                    stringBuffer.append(c);
                    ++n3;
                    continue;
                }
                stringBuffer.append(c);
                ++n3;
            }
            arrayList2.add(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
        }
        for (int i = 0; i < n3; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            if (style.getTextDirection() == 1) {
                for (n = 0; n < arrayList2.size(); ++n) {
                    if (((String)arrayList2.get(n)).length() > i) {
                        char c = ((String)arrayList2.get(n)).charAt(i);
                        stringBuffer.append(c);
                        if (fontMetrics.charWidth(c) != 6) continue;
                        stringBuffer.append(' ');
                        continue;
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(' ');
                }
            } else {
                for (n = arrayList2.size() - 1; n >= 0; --n) {
                    if (((String)arrayList2.get(n)).length() > i) {
                        char c = ((String)arrayList2.get(n)).charAt(i);
                        stringBuffer.append(c);
                        if (fontMetrics.charWidth(c) != 6) continue;
                        stringBuffer.append(' ');
                        continue;
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(' ');
                }
            }
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public static double getPreferredWidth(CellElement cellElement, int n) {
        Style style;
        if (cellElement == null) {
            return 0.0;
        }
        Object object = cellElement.getValue();
        if (object instanceof Formula) {
            object = ((Formula)object).getResult() != null ? ((Formula)object).getResult() : "";
        }
        if ((style = cellElement.getStyle()) == null) {
            style = Style.DEFAULT_STYLE;
        }
        String string = PaintUtils.valueToText(object, style.getFormat());
        FRFont fRFont = style.getFRFont();
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(fRFont);
        return fontMetrics.stringWidth(string) + 4;
    }

    public static int analyzeCellElementPreferredHeight(CellElement cellElement, int n) {
        Object object = cellElement.getValue();
        Style style = cellElement.getStyle();
        if (object instanceof Formula) {
            object = ((Formula)object).getResult() != null ? ((Formula)object).getResult() : "";
        }
        String string = PaintUtils.valueToText(object, style.getFormat());
        return PaintUtils.analyzeCellElementPreferredHeight(string, style, n);
    }

    public static int analyzeCellElementPreferredHeight(String string, Style style, int n) {
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        if (string == null || string.length() <= 0) {
            return 0;
        }
        if (style.getRotation() != 0) {
            return (int)GraphHelper.stringDimension(string, style.getFRFont(), -style.getRotation(), BaseCoreConstants.DEFAULT_FRC).getHeight();
        }
        int n2 = PaintUtils.getLineTextCount(string, style, n);
        FRFont fRFont = style.getFRFont();
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(fRFont);
        int n3 = fontMetrics.getHeight();
        return style.getSpacingAfter() + style.getSpacingBefore() + (n3 + style.getLineSpacing()) * n2;
    }

    public static Style modCellStyleString(int n, int n2, String string, Style style) {
        block15: {
            int n3;
            List list;
            int n4;
            List list2;
            block16: {
                int n5;
                int n6;
                block17: {
                    list2 = style.getVerticalText() == 1 ? PaintUtils.getLineTextList_Vertical(string, style, n2) : PaintUtils.getLineTextList(string, style, n);
                    if (style.getTextStyle() != 2) break block16;
                    FRFont fRFont = style.getFRFont();
                    n6 = 0;
                    n5 = GraphHelper.getFontMetrics(fRFont).getHeight() * list2.size();
                    String string2 = "";
                    for (int i = 0; i < list2.size(); ++i) {
                        if (GraphHelper.getFontMetrics(fRFont).stringWidth((String)list2.get(i)) <= n6) continue;
                        string2 = (String)list2.get(i);
                        n6 = GraphHelper.getFontMetrics(fRFont).stringWidth((String)list2.get(i));
                    }
                    if (n6 <= 0 && n5 <= 0) break block15;
                    if (n6 <= n - style.getPaddingLeft() - style.getPaddingRight() && n5 <= n2) break block17;
                    while (fRFont.getSize() > 1) {
                        fRFont = fRFont.applySize(fRFont.getSize() - 1);
                        n6 = GraphHelper.getFontMetrics(fRFont).stringWidth(string2);
                        n5 = GraphHelper.getFontMetrics(fRFont).getHeight() * list2.size();
                        if (n6 > n - style.getPaddingLeft() - style.getPaddingRight() || n5 > n2) continue;
                        style = style.deriveFRFont(fRFont);
                        break block15;
                    }
                    break block15;
                }
                if (n6 >= n - style.getPaddingLeft() - style.getPaddingRight() || n5 >= n2) break block15;
                break block15;
            }
            if (style.getTextStyle() != 3) break block15;
            FRFont fRFont = style.getFRFont();
            ArrayList<String> arrayList = new ArrayList<String>();
            Style style2 = Style.DEFAULT_STYLE;
            style2 = style2.deriveTextStyle(0);
            int n7 = GraphHelper.getFontMetrics(fRFont).getHeight();
            for (n4 = 0; n4 < list2.size(); ++n4) {
                style2 = style2.deriveFRFont(fRFont);
                list = PaintUtils.getLineTextList((String)list2.get(n4), style2, n);
                for (n3 = 0; n3 < list.size(); ++n3) {
                    arrayList.add((String)list.get(n3));
                }
            }
            if (arrayList.size() * n7 > n2) {
                while (fRFont.getSize() > 1) {
                    fRFont = fRFont.applySize(fRFont.getSize() - 1);
                    arrayList.clear();
                    for (n4 = 0; n4 < list2.size(); ++n4) {
                        style2 = style2.deriveFRFont(fRFont);
                        list = PaintUtils.getLineTextList((String)list2.get(n4), style2, n);
                        for (n3 = 0; n3 < list.size(); ++n3) {
                            arrayList.add((String)list.get(n3));
                        }
                    }
                    n7 = GraphHelper.getFontMetrics(fRFont).getHeight();
                    if (arrayList.size() * n7 > n2) continue;
                    style = style.deriveFRFont(fRFont);
                    break;
                }
            } else if (arrayList.size() * n7 < n2) {
                while (fRFont.getSize() < 100) {
                    fRFont = fRFont.applySize(fRFont.getSize() + 1);
                    arrayList.clear();
                    for (n4 = 0; n4 < list2.size(); ++n4) {
                        style2 = style2.deriveFRFont(fRFont);
                        list = PaintUtils.getLineTextList((String)list2.get(n4), style2, n);
                        for (n3 = 0; n3 < list.size(); ++n3) {
                            arrayList.add((String)list.get(n3));
                        }
                    }
                    n7 = GraphHelper.getFontMetrics(fRFont).getHeight();
                    if (arrayList.size() * n7 <= n2) continue;
                    fRFont = fRFont.applySize(fRFont.getSize() - 1);
                    style = style.deriveFRFont(fRFont);
                    arrayList.clear();
                    for (n4 = 0; n4 < list2.size(); ++n4) {
                        style2 = style2.deriveFRFont(fRFont);
                        list = PaintUtils.getLineTextList((String)list2.get(n4), style2, n);
                        for (n3 = 0; n3 < list.size(); ++n3) {
                            arrayList.add((String)list.get(n3));
                        }
                    }
                    n7 = GraphHelper.getFontMetrics(fRFont).getHeight();
                    break;
                }
            }
        }
        return style;
    }

    public static Style paintCellStyleString(Graphics2D graphics2D, int n, int n2, String string, Style style) {
        Color color;
        Paint paint = graphics2D.getPaint();
        if (StringUtils.isBlank(string)) {
            return style;
        }
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FRFont fRFont = style.getFRFont();
        Locale locale = FRContext.getLocale();
        if (Locale.ENGLISH.equals(locale)) {
            fRFont = FRFont.getInstance("Dialog", fRFont.getStyle(), fRFont.getSize());
        }
        if (!ComparatorUtils.equals(fRFont, graphics2D.getFont())) {
            graphics2D.setFont(fRFont);
        }
        if (!ComparatorUtils.equals(color = fRFont.getForeground(), graphics2D.getPaint())) {
            graphics2D.setPaint(color);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = style.getHorizontalAlignment();
        if (style.getRotation() != 0 && style.getVerticalText() == 0) {
            Map map = PaintUtils.createFontAttributeMap(fRFont);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(-Math.toRadians(style.getRotation()));
            map.put(TextAttribute.TRANSFORM, new TransformAttribute(affineTransform));
            double d = (double)n / 2.0;
            double d2 = (double)n2 / 2.0;
            Dimension2D dimension2D = GraphHelper.stringDimension(string, style.getFRFont(), -style.getRotation(), fontRenderContext);
            if (dimension2D.getWidth() < (double)n) {
                if (n3 == 2) {
                    d = dimension2D.getWidth() / 2.0;
                } else if (n3 == 4) {
                    d = (double)n - dimension2D.getWidth() / 2.0 - (double)style.getPaddingLeft() * Math.cos(Math.toRadians(style.getRotation()));
                }
            }
            if (dimension2D.getHeight() < (double)n2) {
                if (style.getVerticalAlignment() == 1) {
                    d2 = dimension2D.getHeight() / 2.0;
                } else if (style.getVerticalAlignment() == 3) {
                    d2 = (double)n2 - dimension2D.getHeight() / 2.0 - (double)style.getPaddingLeft() * Math.sin(Math.toRadians(style.getRotation()));
                }
            }
            GraphHelper.drawRotatedString(graphics2D, string, d, d2, -style.getRotation());
        } else {
            List list = style.getVerticalText() == 1 ? PaintUtils.getLineTextList_Vertical(string, style, n2) : PaintUtils.getLineTextList(string, style, n);
            if (n <= 0 || list.size() == 0) {
                return style;
            }
            int n4 = fontMetrics.getAscent();
            int n5 = fontMetrics.getHeight();
            int n6 = 0;
            int n7 = n5 * list.size();
            byte by = style.getSpacingBefore();
            byte by2 = style.getSpacingAfter();
            byte by3 = style.getLineSpacing();
            n7 += by + by2 + by3 * list.size();
            if (style.getVerticalAlignment() != 1) {
                if (style.getVerticalAlignment() == 0) {
                    if (n2 > n7) {
                        n6 = (n2 - n7) / 2;
                    }
                } else if (style.getVerticalAlignment() == 3) {
                    n6 = n2 - n7;
                }
            }
            n6 += n4;
            n6 += by + by3;
            if (style.getTextStyle() == 2) {
                int n8;
                FRFont fRFont2 = fRFont;
                Font font = graphics2D.getFont();
                int n9 = 0;
                int n10 = fontMetrics.getHeight() * list.size();
                String string2 = "";
                for (n8 = 0; n8 < list.size(); ++n8) {
                    if (fontMetrics.stringWidth((String)list.get(n8)) <= n9) continue;
                    string2 = (String)list.get(n8);
                    n9 = fontMetrics.stringWidth((String)list.get(n8));
                }
                if (n9 > 0 || n10 > 0) {
                    if (n9 > n - style.getPaddingLeft() - style.getPaddingRight() || n10 > n2) {
                        while (fRFont2.getSize() > 1) {
                            fRFont2 = fRFont2.applySize(fRFont2.getSize() - 1);
                            n9 = GraphHelper.getFontMetrics(fRFont2).stringWidth(string2);
                            n10 = GraphHelper.getFontMetrics(fRFont2).getHeight() * list.size();
                            if (n9 > n - style.getPaddingLeft() - style.getPaddingRight() || n10 > n2) continue;
                            style = style.deriveFRFont(fRFont2);
                            if (!ComparatorUtils.equals(fRFont2, graphics2D.getFont())) {
                                graphics2D.setFont(fRFont2);
                            }
                            break;
                        }
                    } else if (n9 >= n - style.getPaddingLeft() - style.getPaddingRight() || n10 < n2) {
                        // empty if block
                    }
                }
                n8 = graphics2D.getFontMetrics(fRFont2).getHeight();
                if (style.getVerticalAlignment() == 1) {
                    n6 = 0;
                } else if (style.getVerticalAlignment() == 0) {
                    n6 = n2 > n8 * list.size() ? (n2 - n8 * list.size()) / 2 : 0;
                } else if (style.getVerticalAlignment() == 3) {
                    n6 = n2 - n8 * list.size();
                }
                n6 += graphics2D.getFontMetrics().getAscent();
                for (int i = 0; i < list.size(); ++i) {
                    double d = style.getPaddingLeft();
                    int n11 = graphics2D.getFontMetrics().stringWidth((String)list.get(i));
                    if (n3 != 2) {
                        if (n3 == 0) {
                            d = (double)(n - n11 - style.getPaddingRight()) / 2.0;
                        } else if (n3 == 4) {
                            d = n - style.getPaddingRight() - n11;
                        } else if (n3 == 6) {
                            // empty if block
                        }
                    }
                    if (n3 == 6) {
                        String string3 = (String)list.get(i);
                        double d3 = (n - style.getPaddingLeft() - style.getPaddingRight() - graphics2D.getFontMetrics().charWidth(string3.charAt(string3.length() - 1))) / (string3.length() - 1);
                        for (int j = 0; j < string3.length(); ++j) {
                            char c = string3.charAt(j);
                            String string4 = new String(new StringBuffer().append(c));
                            double d4 = (double)style.getPaddingLeft() + (double)j * d3;
                            GraphHelper.drawString(graphics2D, string4, d4, n6);
                        }
                    } else {
                        GraphHelper.drawString(graphics2D, (String)list.get(i), d, n6);
                    }
                    n6 += n8;
                    n6 += by3;
                }
                graphics2D.setFont(font);
            } else if (style.getTextStyle() == 3) {
                int n12;
                List list2;
                int n13;
                FRFont fRFont3 = fRFont;
                Font font = graphics2D.getFont();
                graphics2D.setFont(fRFont3);
                ArrayList<String> arrayList = new ArrayList<String>();
                Style style2 = Style.DEFAULT_STYLE;
                style2 = style2.deriveTextStyle(0);
                int n14 = n5;
                for (n13 = 0; n13 < list.size(); ++n13) {
                    style2 = style2.deriveFRFont(fRFont3);
                    list2 = PaintUtils.getLineTextList((String)list.get(n13), style2, n);
                    for (n12 = 0; n12 < list2.size(); ++n12) {
                        arrayList.add((String)list2.get(n12));
                    }
                }
                if (arrayList.size() * n14 > n2) {
                    while (fRFont3.getSize() > 1) {
                        fRFont3 = fRFont3.applySize(fRFont3.getSize() - 1);
                        arrayList.clear();
                        for (n13 = 0; n13 < list.size(); ++n13) {
                            style2 = style2.deriveFRFont(fRFont3);
                            list2 = PaintUtils.getLineTextList((String)list.get(n13), style2, n);
                            for (n12 = 0; n12 < list2.size(); ++n12) {
                                arrayList.add((String)list2.get(n12));
                            }
                        }
                        graphics2D.setFont(fRFont3);
                        n14 = graphics2D.getFontMetrics(fRFont3).getHeight();
                        if (arrayList.size() * n14 > n2) continue;
                        style = style.deriveFRFont(fRFont3);
                        break;
                    }
                } else if (arrayList.size() * n14 < n2) {
                    while (fRFont3.getSize() < 100) {
                        fRFont3 = fRFont3.applySize(fRFont3.getSize() + 1);
                        arrayList.clear();
                        for (n13 = 0; n13 < list.size(); ++n13) {
                            style2 = style2.deriveFRFont(fRFont3);
                            list2 = PaintUtils.getLineTextList((String)list.get(n13), style2, n);
                            for (n12 = 0; n12 < list2.size(); ++n12) {
                                arrayList.add((String)list2.get(n12));
                            }
                        }
                        graphics2D.setFont(fRFont3);
                        n14 = graphics2D.getFontMetrics(fRFont3).getHeight();
                        if (arrayList.size() * n14 <= n2) continue;
                        fRFont3 = fRFont3.applySize(fRFont3.getSize() - 1);
                        style = style.deriveFRFont(fRFont3);
                        arrayList.clear();
                        for (n13 = 0; n13 < list.size(); ++n13) {
                            style2 = style2.deriveFRFont(fRFont3);
                            list2 = PaintUtils.getLineTextList((String)list.get(n13), style2, n);
                            for (n12 = 0; n12 < list2.size(); ++n12) {
                                arrayList.add((String)list2.get(n12));
                            }
                        }
                        graphics2D.setFont(fRFont3);
                        n14 = graphics2D.getFontMetrics(fRFont3).getHeight();
                        break;
                    }
                }
                if (style.getVerticalAlignment() == 1) {
                    n6 = 0;
                } else if (style.getVerticalAlignment() == 0) {
                    n6 = n2 > n14 * arrayList.size() ? (n2 - n14 * arrayList.size()) / 2 : 0;
                } else if (style.getVerticalAlignment() == 3) {
                    n6 = n2 - n14 * arrayList.size();
                }
                n6 += graphics2D.getFontMetrics().getAscent();
                for (n13 = 0; n13 < arrayList.size(); ++n13) {
                    double d = style.getPaddingLeft();
                    int n15 = graphics2D.getFontMetrics().stringWidth((String)arrayList.get(n13));
                    if (n3 != 2) {
                        if (n3 == 0) {
                            d = (double)(n - n15 - style.getPaddingRight()) / 2.0;
                        } else if (n3 == 4) {
                            d = n - style.getPaddingRight() - n15;
                        } else if (n3 == 6) {
                            // empty if block
                        }
                    }
                    if (n3 == 6) {
                        String string5 = (String)arrayList.get(n13);
                        double d5 = (n - style.getPaddingLeft() - style.getPaddingRight() - graphics2D.getFontMetrics().charWidth(string5.charAt(string5.length() - 1))) / (string5.length() - 1);
                        for (int i = 0; i < string5.length(); ++i) {
                            char c = string5.charAt(i);
                            String string6 = new String(new StringBuffer().append(c));
                            double d6 = (double)style.getPaddingLeft() + (double)i * d5;
                            GraphHelper.drawString(graphics2D, string6, d6, n6);
                        }
                    } else {
                        GraphHelper.drawString(graphics2D, (String)arrayList.get(n13), d, n6);
                    }
                    n6 += n14;
                    n6 += by3;
                }
                graphics2D.setFont(font);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    int n16;
                    String string7;
                    String string8 = (String)list.get(i);
                    int n17 = fontMetrics.stringWidth(string8);
                    boolean bl = false;
                    if (n17 > n - style.getPaddingLeft() - style.getPaddingRight()) {
                        bl = true;
                    }
                    int n18 = style.getPaddingLeft();
                    if (n3 != 2) {
                        if (n3 == 0) {
                            n18 = (n - n17) / 2;
                        } else if (n3 == 4) {
                            n18 = n - style.getPaddingRight() - n17;
                            if (Boolean.TRUE == FRCoreContext.TMAP.get(Thread.currentThread()) && ComparatorUtils.equals(fRFont.getFontName(), "Tahoma")) {
                                n18 -= string8.length() / 3;
                            }
                        } else if (n3 == 6) {
                            // empty if block
                        }
                    }
                    if (n3 == 6 && style.getTextStyle() == 0 || n3 == 6 && style.getTextStyle() == 1 && !bl) {
                        string7 = string8;
                        double d = (n - style.getPaddingLeft() - style.getPaddingRight() - fontMetrics.charWidth(string7.charAt(string7.length() - 1))) / (string7.length() - 1 == 0 ? 1 : string7.length() - 1);
                        for (n16 = 0; n16 < string7.length(); ++n16) {
                            char c = string7.charAt(n16);
                            String string9 = new String(new StringBuffer().append(c));
                            double d7 = (double)style.getPaddingLeft() + (double)n16 * d;
                            if (style.getTextStyle() == 1 && i != 0) continue;
                            GraphHelper.drawString(graphics2D, string9, d7, n6);
                        }
                    } else if (n3 == 6 && style.getTextStyle() == 1 && bl) {
                        string7 = string8;
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < string7.length(); ++j) {
                            stringBuffer.append(string7.charAt(j));
                            n16 = fontMetrics.stringWidth(new String(stringBuffer));
                            if (n16 <= n) continue;
                            char[] cArray = new char[128];
                            stringBuffer.getChars(0, j - 1, cArray, 0);
                            cArray[j] = '\u0000';
                            GraphHelper.drawString(graphics2D, new String(cArray), n18, n6);
                            break;
                        }
                    } else {
                        GraphHelper.drawString(graphics2D, string8, n18, n6);
                    }
                    n6 += n5;
                    n6 += by3;
                }
            }
        }
        graphics2D.setPaint(paint);
        return style;
    }

    public static void paintBarcode(Graphics2D graphics2D, int n, int n2, String string, Style style, BarcodeAttr barcodeAttr) {
        Background background;
        BarcodeImpl barcodeImpl;
        try {
            barcodeImpl = BarCodeUtils.getBarcodeImpl(barcodeAttr, string);
        }
        catch (BarcodeException barcodeException) {
            try {
                barcodeImpl = BarCodeUtils.getBarcodeImpl(new BarcodeAttr(), null);
            }
            catch (BarcodeException barcodeException2) {
                FRContext.getLogger().log(Level.WARNING, barcodeException2.getMessage(), barcodeException2);
                return;
            }
        }
        if (style.getFRFont() != null) {
            barcodeImpl.setFont(style.getFRFont());
            barcodeImpl.setForeground(style.getFRFont().getForeground());
        }
        if ((background = style.getBackground()) != null && background instanceof ColorBackground) {
            barcodeImpl.setBackground(((ColorBackground)background).getColor());
        }
        int n3 = (n - barcodeImpl.getWidth()) / 2;
        int n4 = (n2 - barcodeImpl.getHeight()) / 2;
        barcodeImpl.draw(graphics2D, n3, n4);
    }

    public static Map createFontAttributeMap(Font font) {
        FRFont fRFont;
        Map<TextAttribute, ?> map = (Map<TextAttribute, ?>)fontAttributeMapCache.get(font);
        if (map == null) {
            map = font.getAttributes();
            fontAttributeMapCache.put(font, map);
        }
        if (font instanceof FRFont && (fRFont = (FRFont)font).isStrikethrough()) {
            map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return map;
    }
}

