/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.antlr.ANTLRException;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.file.ConfigManager;
import com.fr.chart.ChartCollection;
import com.fr.data.Dictionary;
import com.fr.data.TableData;
import com.fr.data.impl.NameTableData;
import com.fr.data.impl.TableDataDictionary;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.ReportParameterAttr;
import com.fr.report.TemplateReport;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.core.SegmentHandler;
import com.fr.report.parameter.CustomParameterProcessor;
import com.fr.report.parameter.Parameter;
import com.fr.report.parameter.ParameterProcessor;
import com.fr.report.script.Calculator;
import com.fr.report.script.DataSetFunctionParameterMapNameSpace;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.script.core.parser.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParameterHelper {
    private static final Pattern deprecatedParaPattern = Pattern.compile("\\[\\?[^\\]\\?]*\\?\\]");

    private ParameterHelper() {
    }

    public static Parameter[] analyze4Parameters(String string) {
        Parameter[] parameterArray = null;
        if (deprecatedParaPattern.matcher(string).find()) {
            SegmentHandler.ParameterCollector parameterCollector = new SegmentHandler.ParameterCollector();
            ParameterHelper.analyzeParametersFromQuery(string, parameterCollector);
            parameterArray = parameterCollector.getParameters();
        } else if (TemplateUtils.ParameterPattern.matcher(string).find()) {
            parameterArray = ParameterHelper.parametersFromQuery(string);
        }
        return parameterArray == null ? new Parameter[]{} : parameterArray;
    }

    public static String analyze4Templatee(String string, Parameter[] parameterArray) {
        if (parameterArray == null || parameterArray.length == 0) {
            return string;
        }
        Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace(ParameterMapNameSpace.create(parameterArray));
        return calculator.renderTpl(string);
    }

    public static String analyzeCurrentContextTableData4Templatee(String string, Parameter[] parameterArray) {
        Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace(DataSetFunctionParameterMapNameSpace.creat(parameterArray));
        return calculator.renderTpl(string);
    }

    public static void analyzeParametersFromQuery(String string, SegmentHandler segmentHandler) {
        String string2;
        Matcher matcher = deprecatedParaPattern.matcher(string);
        int n = 0;
        int n2 = 0;
        while (matcher.find()) {
            n2 = matcher.start();
            string2 = string.substring(n, n2);
            if (StringUtils.isNotEmpty(string2)) {
                segmentHandler.stringSegment(string2);
            }
            n = matcher.end();
            String string3 = matcher.group();
            String string4 = string3.replaceAll("[\\[\\?\\?\\]]", "");
            String[] stringArray = string4.split("\\|");
            String string5 = stringArray[0].replaceAll("[\\r\\n, \\n]*", "");
            segmentHandler.parameterSegment(string5, stringArray.length > 1 ? stringArray[1] : null);
        }
        string2 = string.substring(n);
        if (StringUtils.isNotBlank(string2)) {
            segmentHandler.stringSegment(string2);
        }
    }

    private static Parameter[] parametersFromQuery(String string) {
        Object object;
        Object object2;
        Matcher matcher = Calculator.ParameterPattern.matcher(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        while (matcher.find()) {
            object2 = matcher.group();
            object = ((String)object2).substring(2, ((String)object2).length() - 1);
            if (StringUtils.isBlank((String)object)) continue;
            Expression expression = null;
            Calculator calculator = Calculator.createCalculator();
            try {
                expression = calculator.parse((String)object);
            }
            catch (ANTLRException aNTLRException) {
                aNTLRException.printStackTrace();
            }
            if (expression.parserParameter() == null) continue;
            int n = expression.parserParameter().length;
            for (int i = 0; i < n; ++i) {
                hashSet.add(expression.parserParameter()[i]);
            }
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = new Parameter((String)object2.next());
            arrayList.add(object);
        }
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    public static void addGlobal_ParameterToList(List list) {
        ConfigManager configManager = FRContext.getConfigManager();
        Parameter[] parameterArray = configManager.getGlobal_Parameters();
        if (parameterArray != null) {
            list.addAll(Arrays.asList(parameterArray));
        }
    }

    public static void addReportParameterAttrToList(List list, ReportParameterAttr reportParameterAttr, boolean bl) {
        Parameter[] parameterArray;
        ParameterProcessor parameterProcessor;
        if (reportParameterAttr == null) {
            return;
        }
        if (bl && (parameterProcessor = reportParameterAttr.getParameterProcessor()) instanceof CustomParameterProcessor && (parameterArray = ((CustomParameterProcessor)parameterProcessor).getParameters()) != null && parameterArray.length > 0) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (parameterArray[i] == null) continue;
                list.add(parameterArray[i]);
            }
        }
    }

    public static void addReportTableDataParameterToList(List list, TemplateReport templateReport, boolean bl) throws Exception {
        Object object;
        Object object2;
        Iterator iterator;
        if (templateReport == null) {
            return;
        }
        HashMap<Object, TableData> hashMap = new HashMap<Object, TableData>();
        if (templateReport.getTemplateWorkBook() != null) {
            iterator = templateReport.getTemplateWorkBook().getTableDataNameIterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                hashMap.put(object2, templateReport.getTemplateWorkBook().getTableData((String)object2));
            }
        }
        if (bl) {
            iterator = templateReport.cellIterator();
            while (iterator.hasNext()) {
                object2 = (CellElement)iterator.next();
                object = object2.getValue();
                ParameterHelper.collectValueTableData(object, hashMap);
            }
            object2 = templateReport.floatIterator();
            while (object2.hasNext()) {
                object = (FloatElement)object2.next();
                Object object3 = ((FloatElement)object).getValue();
                ParameterHelper.collectValueTableData(object3, hashMap);
            }
        }
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (TableData)hashMap.get(object2);
            ParameterHelper.addParametersToParameterList(list, object.getParameters());
        }
    }

    public static void refreshParameterProcessor(TemplateReport templateReport) {
        ReportParameterAttr reportParameterAttr;
        if (templateReport == null) {
            return;
        }
        ReportParameterAttr reportParameterAttr2 = reportParameterAttr = templateReport.getTemplateWorkBook() == null ? null : templateReport.getTemplateWorkBook().getReportParameterAttr();
        if (reportParameterAttr == null) {
            return;
        }
        if (reportParameterAttr.getParameterProcessor() instanceof CustomParameterProcessor) {
            ArrayList arrayList = new ArrayList();
            ParameterHelper.addReportParameterAttrToList(arrayList, reportParameterAttr, false);
            try {
                ParameterHelper.addReportTableDataParameterToList(arrayList, templateReport, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ParameterHelper.addGlobal_ParameterToList(arrayList);
            CustomParameterProcessor customParameterProcessor = (CustomParameterProcessor)reportParameterAttr.getParameterProcessor();
            Map map = customParameterProcessor.getUnitProcessorMap();
            Iterator iterator = map.entrySet().iterator();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                boolean bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!((Parameter)arrayList.get(i)).getName().equals(string)) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList2.add(string);
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                map.remove(arrayList2.get(i));
            }
        }
    }

    public static void collectValueTableData(Object object, Map map) {
        if (object instanceof DSColumn) {
            DSColumn dSColumn = (DSColumn)object;
            String string = dSColumn.getDSName();
            TableData tableData = (TableData)map.get(string);
            if (tableData == null) {
                map.put(string, new NameTableData(string));
            }
        } else if (object instanceof ChartCollection) {
            String string;
            ChartCollection chartCollection = (ChartCollection)object;
            Object v = null;
            if (v != null && v instanceof NameTableData && map.get(string = ((NameTableData)v).getName()) == null) {
                map.put(string, v);
            }
        }
    }

    public static void addDictParameterToList(Dictionary dictionary, Map map, List list) throws Exception {
        if (dictionary == null) {
            return;
        }
        if (dictionary instanceof TableDataDictionary) {
            Parameter[] parameterArray;
            TableDataDictionary tableDataDictionary = (TableDataDictionary)dictionary;
            TableData tableData = tableDataDictionary.getTableData();
            if (tableData instanceof NameTableData) {
                String string = ((NameTableData)tableData).getName();
                TableData tableData2 = (TableData)map.get(string);
                if (tableData2 == null) {
                    map.put(string, tableData);
                } else {
                    tableDataDictionary.setTableData(tableData2);
                }
            } else if (tableData != null && (parameterArray = tableData.getParameters()) != null) {
                list.addAll(Arrays.asList(parameterArray));
            }
        }
    }

    public static void addParametersToParameterList(List list, Parameter[] parameterArray) {
        if (parameterArray == null) {
            return;
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            Parameter parameter = parameterArray[i];
            if (parameter == null) continue;
            list.add(parameter);
        }
    }

    public static Parameter[] cloneParameters(Parameter[] parameterArray) throws CloneNotSupportedException {
        if (parameterArray == null) {
            return null;
        }
        Parameter[] parameterArray2 = new Parameter[parameterArray.length];
        for (int i = 0; i < parameterArray.length; ++i) {
            Parameter parameter = parameterArray[i];
            parameterArray2[i] = parameter == null ? new Parameter() : (Parameter)parameter.clone();
        }
        return parameterArray2;
    }
}

