/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.Inter;
import com.fr.base.core.DateUtils;
import com.fr.data.core.Compare;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Primitive;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;

public class ReportCoreConstants {
    public static NumberFormat DOUBLE_FORMAT = new DecimalFormat("0.00");
    public static NumberFormat FLOAT_FORMAT = new DecimalFormat("0.0");
    public static NumberFormat INTEGER_FORMAT = new DecimalFormat("0");
    public static final int DEFAULT_ROW_HEIGHT = 19;
    public static final int DEFAULT_COL_WIDTH = 72;
    public static final int INIT_ROW_NUMBER = 50;
    public static final int INIT_COLUMN_NUMBER = 20;

    private ReportCoreConstants() {
    }

    public static int[] getAllOperators() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    }

    public static String getOperatorString(int n) {
        switch (n) {
            case 0: {
                return Inter.getLocText("ConditionB-equals");
            }
            case 1: {
                return Inter.getLocText("ConditionB-does_not_equal_to");
            }
            case 2: {
                return Inter.getLocText("ConditionB-is_greater_than");
            }
            case 3: {
                return Inter.getLocText("ConditionB-is_greater_than_or_equal_to");
            }
            case 4: {
                return Inter.getLocText("ConditionB-is_less_than");
            }
            case 5: {
                return Inter.getLocText("ConditionB-is_less_than_or_equal_to");
            }
            case 6: {
                return Inter.getLocText("ConditionB-begins_with");
            }
            case 7: {
                return Inter.getLocText("ConditionB-does_not_begin_with");
            }
            case 8: {
                return Inter.getLocText("ConditionB-ends_with");
            }
            case 9: {
                return Inter.getLocText("ConditionB-does_not_end_with");
            }
            case 10: {
                return Inter.getLocText("ConditionB-contains");
            }
            case 11: {
                return Inter.getLocText("ConditionB-does_not_contain");
            }
            case 12: {
                return Inter.getLocText("ConditionB-in");
            }
            case 13: {
                return Inter.getLocText("ConditionB-does_not_in");
            }
        }
        return "";
    }

    public static String conditionToString(Compare compare) {
        StringBuffer stringBuffer = new StringBuffer();
        if (compare == null) {
            return null;
        }
        stringBuffer.append(ReportCoreConstants.getOperatorString(compare.getOp()));
        if (compare.getValue() instanceof Date) {
            stringBuffer.append(" ");
            stringBuffer.append(DateUtils.DATEFORMAT2.format((Date)compare.getValue()));
        } else if (compare.getValue() instanceof Parameter) {
            stringBuffer.append("$").append(((Parameter)compare.getValue()).getName());
        } else if (compare.getValue() == Primitive.NULL) {
            stringBuffer.append(" null");
        } else if (compare.getValue() instanceof Number) {
            stringBuffer.append(" ");
            stringBuffer.append(compare.getValue());
        } else {
            stringBuffer.append(" '");
            stringBuffer.append(compare.getValue());
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }
}

