/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.report.AbstractReport;
import com.fr.report.CellElement;
import com.fr.report.FineBook;
import com.fr.report.FloatElement;
import com.fr.report.Report;
import com.fr.report.ReportGetter;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaginateReport;
import com.fr.report.io.core.ExcelReport;
import com.fr.report.script.Primitive;
import com.fr.util.Utils;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.Iterator;

public class ReportHelper {
    private ReportHelper() {
    }

    public static Point[] calculateLastColumnAndRowOfFloatElement(Report report, FloatElement floatElement) {
        int n = floatElement.getColumn();
        int n2 = floatElement.getRow();
        int n3 = floatElement.getLeftDistance();
        int n4 = floatElement.getTopDistance();
        Dimension dimension = floatElement.getSize();
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(report);
        DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(report);
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        int n8 = 0;
        int n9 = -n3;
        int n10 = n;
        while (true) {
            if ((double)(n9 += dynamicValueList.get(n10)) >= dimension.getWidth()) break;
            ++n10;
        }
        n5 = n10;
        n7 = dimension.width - (n9 - dynamicValueList.get(n10));
        n9 = -n4;
        n10 = n2;
        while (true) {
            if ((double)(n9 += dynamicValueList2.get(n10)) >= dimension.getHeight()) break;
            ++n10;
        }
        n6 = n10;
        n8 = dimension.height - (n9 - dynamicValueList2.get(n10));
        return new Point[]{new Point(n5, n6), new Point(n7, n8)};
    }

    public static String converNewReportletPath(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        if (string.toLowerCase().endsWith(".cpt")) {
            string2 = Utils.replaceAllString(string, "\\\\", "/");
            if (!(string2 = Utils.replaceAllString(string2, "\\", "/")).startsWith("/")) {
                string2 = File.separator + string2;
            }
        } else {
            string2 = File.separator + Utils.replaceAllString(string, ".", "/") + ".class";
        }
        return string2;
    }

    public static DynamicValueList getRowHeightList(Report report) {
        if (report == null) {
            return new DynamicValueList(19);
        }
        if (report instanceof AbstractReport) {
            return ((AbstractReport)report).rowHeightList_DEC;
        }
        if (report instanceof PaginateReport) {
            if (((PaginateReport)report).toRWorkSheet() != null) {
                return ((PaginateReport)report).toRWorkSheet().rowHeightList_DEC;
            }
        } else if (report instanceof ExcelReport) {
            return ((ExcelReport)report).rowHeightList;
        }
        return ReportHelper.createRowHeightList(report);
    }

    public static DynamicValueList createRowHeightList(ReportGetter reportGetter) {
        int n = reportGetter.getRowCount();
        DynamicValueList dynamicValueList = new DynamicValueList(19, n);
        for (int i = 0; i < n; ++i) {
            dynamicValueList.set(i, reportGetter.getRowHeight(i));
        }
        return dynamicValueList;
    }

    public static DynamicValueList getColumnWidthList(Report report) {
        if (report instanceof AbstractReport) {
            return ((AbstractReport)report).columnWidthList_DEC;
        }
        if (report instanceof PaginateReport) {
            if (((PaginateReport)report).toRWorkSheet() != null) {
                return ((PaginateReport)report).toRWorkSheet().columnWidthList_DEC;
            }
        } else if (report instanceof ExcelReport) {
            return ((ExcelReport)report).columnWidthList;
        }
        return ReportHelper.createColumnWidthList(report);
    }

    public static DynamicValueList createColumnWidthList(ReportGetter reportGetter) {
        int n = reportGetter.getColumnCount();
        DynamicValueList dynamicValueList = new DynamicValueList(72, n);
        for (int i = 0; i < n; ++i) {
            dynamicValueList.set(i, reportGetter.getColumnWidth(i));
        }
        return dynamicValueList;
    }

    public static boolean isNull(Object object) {
        return object == null || object == Primitive.NULL || object instanceof Formula && ReportHelper.isNull(((Formula)object).getResult());
    }

    public static void clearFormulaResult(FineBook fineBook) {
        int n = fineBook.getReportCount();
        for (int i = 0; i < n; ++i) {
            ReportHelper.clearFormulaResult(fineBook.getReport(i));
        }
    }

    public static void clearFormulaResult(Report report) {
        Iterator iterator = report.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            if (!(cellElement.getValue() instanceof Formula)) continue;
            ((Formula)cellElement.getValue()).setResult(null);
        }
    }

    public static Object convertGeneralStringAccordingToExcel(Object object) {
        if (object != null && object instanceof String) {
            String string = (String)object;
            if (string.startsWith("=")) {
                return new Formula(string);
            }
            if (string.length() > 0) {
                Number number;
                if (string.matches("\\(\\d+(\\.\\d+)*\\)")) {
                    string = "-" + string.substring(1, string.length() - 1);
                }
                if ((number = Utils.string2Number(string)) != null) {
                    return number;
                }
            }
        }
        return object;
    }
}

