/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.core.antlr.ANTLRException;
import com.fr.data.core.Compare;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.TableDataSource;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.DeathCycleException;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.Primitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;

public class ScriptUtils {
    public static final Object REC_CE_LIST = new Object();

    private ScriptUtils() {
    }

    public static String[] getDependenceByCompare(Compare compare) {
        Object object = compare.getValue();
        if (object instanceof Formula) {
            return ScriptUtils.getDependenceByFormula(((Formula)object).getContent());
        }
        if (object instanceof Parameter) {
            return new String[]{((Parameter)object).getName()};
        }
        return new String[0];
    }

    public static String[] getDependenceByParameter(Parameter[] parameterArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < parameterArray.length; ++i) {
            arrayList.add(parameterArray[i].toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getDependenceByFormula(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ColumnRow[] columnRowArray = Calculator.relatedColumnRowArray(string);
            for (int i = 0; i < columnRowArray.length; ++i) {
                arrayList.add(columnRowArray[i].toString());
            }
            String[] stringArray = Calculator.relatedParameters(string);
            arrayList.addAll(Arrays.asList(stringArray));
        }
        catch (ANTLRException aNTLRException) {
            FRContext.getLogger().log(Level.WARNING, aNTLRException.getMessage(), aNTLRException);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String moveRow(String string, int n, int n2) {
        return ScriptUtils.changePosition(string, n, n2, -1, 0);
    }

    public static String moveColumn(String string, int n, int n2) {
        return ScriptUtils.changePosition(string, -1, 0, n, n2);
    }

    public static String changePosition(String string, int n, int n2, int n3, int n4) {
        if (string.startsWith("=")) {
            string = string.substring(1);
        }
        return Calculator.createCalculator().onAddDeleteColumnOrRow(string, n, n2, n3, n4);
    }

    public static void executeCellElementFormula(Calculator calculator, Formula formula, Report report, TableDataSource tableDataSource, CellElement cellElement) {
        try {
            LinkedList linkedList = (LinkedList)calculator.getAttribute(REC_CE_LIST);
            if (linkedList.contains(cellElement)) {
                throw new DeathCycleException("Death cycle exists when calculate : " + cellElement + "\n" + linkedList);
            }
            linkedList.add(cellElement);
            formula.setResult(ScriptUtils.executeFormula(calculator, formula, report, tableDataSource, ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow())));
            linkedList.removeLast();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error ColumnRow:" + ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()) + "\tcontent:" + formula.getContent() + throwable.getMessage(), throwable);
        }
    }

    public static Object executeFormula(Calculator calculator, Formula formula) {
        return ScriptUtils.executeFormula(calculator, formula, calculator.getCurrentColumnRow());
    }

    public static Object executeFormula(Calculator calculator, Formula formula, ColumnRow columnRow) {
        return ScriptUtils.executeFormula(calculator, formula, calculator.getCurrentReport(), calculator.getCurrentTableDataSource(), columnRow);
    }

    public static Object executeFormula(Calculator calculator, Formula formula, Report report, TableDataSource tableDataSource, ColumnRow columnRow) {
        try {
            double d;
            String string = formula.getContent().substring(1);
            calculator.setCurrentReport(report);
            calculator.setCurrentTableDataSource(tableDataSource);
            calculator.setCurrentColumnRow(columnRow);
            Object object = calculator.eval(string);
            if (object instanceof Number && (object instanceof Double ? Double.isNaN(d = ((Double)object).doubleValue()) || Double.isInfinite(d) : object instanceof Integer && Integer.MAX_VALUE == (Integer)object)) {
                return "\u221e";
            }
            return object;
        }
        catch (Throwable throwable) {
            if (columnRow != null) {
                System.err.println("Error ColumnRow:" + columnRow + "\tcontent:" + formula);
            } else {
                System.err.println("Error content:" + formula);
            }
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            return Primitive.ERROR_NAME;
        }
    }
}

