/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.report.cellElement.Formula;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.UtilEvalError;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public interface SegmentHandler {
    public void stringSegment(String var1);

    public void parameterSegment(String var1, String var2);

    public static class QueryCreator
    implements SegmentHandler {
        private Calculator c;
        private StringBuffer sb = new StringBuffer();

        public QueryCreator(Calculator calculator) {
            if (calculator == null) {
                calculator = Calculator.createCalculator();
            }
            this.c = calculator;
        }

        public String getNewQuery() {
            return this.sb.toString();
        }

        public void parameterSegment(String string, String string2) {
            String string3;
            Object object = this.c.resolveVariable(string);
            if (object == null) {
                object = string2;
            }
            if (object instanceof String && ((String)object).startsWith("=")) {
                object = new Formula((String)object);
            }
            if (object instanceof Formula) {
                try {
                    object = this.c.eval(((Formula)object).getContent());
                }
                catch (UtilEvalError utilEvalError) {
                    FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
                }
            }
            if (object instanceof Date) {
                string3 = null;
                if (StringUtils.isBlank(string3)) {
                    string3 = "yyyy-MM-dd";
                }
                object = new SimpleDateFormat(string3).format((Date)object);
            }
            string3 = null;
            if (object instanceof String) {
                string3 = (String)object;
            } else if (object != null) {
                string3 = object.toString();
            }
            if (StringUtils.isNotEmpty(string3)) {
                this.sb.append(string3);
            }
        }

        public void stringSegment(String string) {
            this.sb.append(string);
        }
    }

    public static final class ParameterCollector
    implements SegmentHandler {
        List parameterList = new ArrayList();

        public Parameter[] getParameters() {
            return this.parameterList.toArray(new Parameter[this.parameterList.size()]);
        }

        public void parameterSegment(String string, String string2) {
            this.parameterList.add(new Parameter(string, string2));
        }

        public void stringSegment(String string) {
        }
    }
}

