/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.FT;
import com.fr.base.core.list.IntList;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.Margin;
import com.fr.report.PageInfo;
import com.fr.report.PaperSetting;
import com.fr.report.PaperSize;
import com.fr.report.Report;
import com.fr.report.ReportPage;
import com.fr.report.ReportPageAttr;
import com.fr.report.ReportSettings;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.core.DeathCycleException;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class SheetPageGenerator {
    private Report report;
    private FT repeatrowheader;
    private FT detailrows;
    private FT repeatrowfooter;
    private FT repeatcolumnheader;
    private FT detailcolumns;
    private FT repeatcolumnfooter;
    private DynamicValueList columnWidthList;
    private DynamicValueList rowHeightList;
    private IntList pageColumnIndexList = new IntList();
    private IntList pageRowIndexList = new IntList();
    private int pageCount = 0;
    private List workSheetPageLists = new ArrayList();
    private ReportSettings reportSettings;
    private PaperSetting setting;

    public SheetPageGenerator(Report report, PaperSetting paperSetting) {
        this.report = report;
        this.reportSettings = ReportUtils.getReportSettings(report);
        this.columnWidthList = ReportHelper.getColumnWidthList(report);
        this.rowHeightList = ReportHelper.getRowHeightList(report);
        this.setting = paperSetting;
        this.dealWithPageInfor();
        this.generatePages();
    }

    public ReportPage[] getReportPages() {
        return this.workSheetPageLists.toArray(new ReportPage[this.workSheetPageLists.size()]);
    }

    private void dealWithPageInfor() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Cloneable cloneable;
        int n6;
        int n7;
        if (this.setting == null) {
            n7 = Integer.MAX_VALUE;
            n6 = Integer.MAX_VALUE;
        } else {
            PaperSize paperSize = this.setting.getPaperSize();
            Margin margin = this.setting.getMargin();
            double d = paperSize.getWidth();
            double d2 = paperSize.getHeight();
            if (this.setting.getOrientation() == 1) {
                d = paperSize.getHeight();
                d2 = paperSize.getWidth();
            }
            n7 = (int)((d - margin.getLeft() - margin.getRight()) * 96.0);
            n6 = (int)((d2 - margin.getTop() - margin.getBottom() - this.reportSettings.getHeaderHeight() - this.reportSettings.getFooterHeight()) * 96.0);
        }
        if (n7 <= 0 || n6 <= 0) {
            throw new RuntimeException("paperPaintWidth/paperPaintHeight is less than 0");
        }
        int n8 = 0;
        int n9 = 0;
        Iterator iterator = this.report.floatIterator();
        while (iterator.hasNext()) {
            cloneable = (FloatElement)iterator.next();
            Point[] pointArray = ReportHelper.calculateLastColumnAndRowOfFloatElement(this.report, (FloatElement)cloneable);
            n8 = Math.max(n8, pointArray[0].x + 1);
            n9 = Math.max(n9, pointArray[0].y + 1);
        }
        n8 = Math.max(n8, this.report.getColumnCount());
        n9 = Math.max(n9, this.report.getRowCount());
        this.repeatrowheader = new FT(0, 0);
        this.detailrows = new FT(0, n9);
        this.repeatrowfooter = new FT(n9, n9);
        this.repeatcolumnheader = new FT(0, 0);
        this.detailcolumns = new FT(0, n8);
        this.repeatcolumnfooter = new FT(n8, n8);
        cloneable = this.report.getReportPageAttr();
        if (cloneable != null) {
            int n10 = ((ReportPageAttr)cloneable).getRepeatHeaderRowFrom();
            int n11 = ((ReportPageAttr)cloneable).getRepeatHeaderRowTo() + 1;
            if (n10 >= 0 && n11 >= 0) {
                this.repeatrowheader.setFrom(Math.min(n10, n11));
                this.repeatrowheader.setTo(Math.max(n10, n11));
            }
            int n12 = ((ReportPageAttr)cloneable).getRepeatFooterRowFrom();
            int n13 = ((ReportPageAttr)cloneable).getRepeatFooterRowTo() + 1;
            if (n12 >= 0 && n13 >= 0) {
                this.repeatrowfooter.setFrom(Math.min(n12, n13));
                this.repeatrowfooter.setTo(Math.max(n12, n13));
            }
            this.detailrows.setFrom(this.repeatrowheader.getTo());
            this.detailrows.setTo(this.repeatrowfooter.getFrom());
            n5 = ((ReportPageAttr)cloneable).getRepeatHeaderColumnFrom();
            n4 = ((ReportPageAttr)cloneable).getRepeatHeaderColumnTo() + 1;
            if (n5 >= 0 && n4 >= 0) {
                this.repeatcolumnheader.setFrom(Math.min(n5, n4));
                this.repeatcolumnheader.setTo(Math.max(n5, n4));
            }
            n3 = ((ReportPageAttr)cloneable).getRepeatFooterColumnFrom();
            n2 = ((ReportPageAttr)cloneable).getRepeatFooterColumnTo() + 1;
            if (n3 >= 0 && n2 >= 0) {
                this.repeatcolumnfooter.setFrom(Math.min(n3, n2));
                this.repeatcolumnfooter.setTo(Math.max(n3, n2));
            }
            this.detailcolumns.setFrom(this.repeatcolumnheader.getTo());
            this.detailcolumns.setTo(this.repeatcolumnfooter.getFrom());
        }
        IntList intList = new IntList();
        IntList intList2 = new IntList();
        Iterator iterator2 = this.report.cellIterator();
        while (iterator2.hasNext()) {
            CellElement cellElement = (CellElement)iterator2.next();
            CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
            if (cellPageAttr == null) continue;
            if (cellPageAttr.isPageAfterColumn() && (n5 = cellElement.getColumn() + cellElement.getColumnSpan()) > 0) {
                intList.add(n5);
            }
            if (cellPageAttr.isPageBeforeColumn() && (n5 = cellElement.getColumn()) > 0) {
                intList.add(n5);
            }
            if (cellPageAttr.isPageAfterRow() && (n5 = cellElement.getRow() + cellElement.getRowSpan()) > 0) {
                intList2.add(n5);
            }
            if (!cellPageAttr.isPageBeforeRow() || (n5 = cellElement.getRow()) <= 0) continue;
            intList2.add(n5);
        }
        n4 = this.columnWidthList.getRangeValue(this.repeatcolumnheader.getFrom(), this.repeatcolumnheader.getTo());
        if (n4 + (n3 = this.columnWidthList.getRangeValue(this.repeatcolumnfooter.getFrom(), this.repeatcolumnfooter.getTo())) >= n7) {
            throw new RuntimeException("repeated column width is larger than paper width.");
        }
        this.pageColumnIndexList.add(0);
        n2 = 0;
        int n14 = 0;
        for (n = 0; n < this.detailcolumns.getFrom(); ++n) {
            n14 = this.columnWidthList.get(n);
            if ((n2 += n14) <= n7 && !intList.contain(n)) continue;
            if (this.pageColumnIndexList.get(this.pageColumnIndexList.size() - 1) == n) {
                throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with columnIndex: " + n);
            }
            this.pageColumnIndexList.add(n);
            n2 = n14;
        }
        for (n = this.detailcolumns.getFrom(); n < this.detailcolumns.getTo(); ++n) {
            n14 = this.columnWidthList.get(n);
            if ((n2 += n14) + n3 <= n7 && !intList.contain(n)) continue;
            if (this.pageColumnIndexList.get(this.pageColumnIndexList.size() - 1) == n) {
                throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with columnIndex: " + n);
            }
            this.pageColumnIndexList.add(n);
            n2 = n4 + n14;
        }
        for (n = this.detailcolumns.getTo(); n < n8; ++n) {
            n14 = this.columnWidthList.get(n);
            if ((n2 += n14) <= n7 && !intList.contain(n)) continue;
            if (this.pageColumnIndexList.get(this.pageColumnIndexList.size() - 1) == n) {
                throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with columnIndex: " + n);
            }
            this.pageColumnIndexList.add(n);
            n2 = n14;
        }
        this.pageColumnIndexList.add(n8);
        n4 = this.rowHeightList.getRangeValue(this.repeatrowheader.getFrom(), this.repeatrowheader.getTo());
        n3 = this.rowHeightList.getRangeValue(this.repeatrowfooter.getFrom(), this.repeatrowfooter.getTo());
        if (n4 + n3 >= n6) {
            throw new RuntimeException("repeated row height is larger than paper height.");
        }
        this.pageRowIndexList.add(0);
        n2 = 0;
        n14 = 0;
        for (n = 0; n < this.detailrows.getFrom(); ++n) {
            n14 = this.rowHeightList.get(n);
            if ((n2 += n14) <= n6 && !intList2.contain(n)) continue;
            if (this.pageRowIndexList.get(this.pageRowIndexList.size() - 1) == n) {
                throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with rowIndex: " + n);
            }
            this.pageRowIndexList.add(n);
            n2 = n14;
        }
        for (n = this.detailrows.getFrom(); n < this.detailrows.getTo(); ++n) {
            n14 = this.rowHeightList.get(n);
            if ((n2 += n14) + n3 <= n6 && !intList2.contain(n)) continue;
            if (this.pageRowIndexList.get(this.pageRowIndexList.size() - 1) == n) {
                throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with rowIndex: " + n);
            }
            this.pageRowIndexList.add(n);
            n2 = n4 + n14;
        }
        for (n = this.detailrows.getTo(); n < n9; ++n) {
            n14 = this.rowHeightList.get(n);
            if ((n2 += n14) <= n6 && !intList2.contain(n)) continue;
            if (this.pageRowIndexList.get(this.pageRowIndexList.size() - 1) == n) {
                throw new DeathCycleException("Death cycle exist in paginating\u3000dealing with rowIndex: " + n);
            }
            this.pageRowIndexList.add(n);
            n2 = n14;
        }
        this.pageRowIndexList.add(n9);
        this.pageCount = (this.pageColumnIndexList.size() - 1) * (this.pageRowIndexList.size() - 1);
    }

    private void generatePages() {
        int n = 0;
        switch (this.reportSettings.getPageOrder()) {
            case 0: {
                int n2 = this.pageColumnIndexList.size();
                for (int i = 1; i < n2; ++i) {
                    int n3 = this.pageColumnIndexList.get(i - 1);
                    int n4 = this.pageColumnIndexList.get(i);
                    ArrayList<FT> arrayList = new ArrayList<FT>();
                    if (n3 >= this.detailcolumns.getFrom() && n3 < this.detailcolumns.getTo() && this.repeatcolumnheader.getTo() > this.repeatcolumnheader.getFrom()) {
                        arrayList.add(new FT(this.repeatcolumnheader.getFrom(), this.repeatcolumnheader.getTo()));
                    }
                    if (n4 > n3) {
                        arrayList.add(new FT(n3, n4));
                    }
                    if (n4 >= this.detailcolumns.getFrom() && n4 <= this.detailcolumns.getTo() && this.repeatcolumnfooter.getTo() > this.repeatcolumnfooter.getFrom()) {
                        arrayList.add(new FT(this.repeatcolumnfooter.getFrom(), this.repeatcolumnfooter.getTo()));
                    }
                    int n5 = this.pageRowIndexList.size();
                    for (int j = 1; j < n5; ++j) {
                        int n6 = this.pageRowIndexList.get(j - 1);
                        int n7 = this.pageRowIndexList.get(j);
                        ArrayList<FT> arrayList2 = new ArrayList<FT>();
                        if (n6 >= this.detailrows.getFrom() && n6 < this.detailrows.getTo() && this.repeatrowheader.getTo() > this.repeatrowheader.getFrom()) {
                            arrayList2.add(this.repeatrowheader);
                        }
                        if (n7 > n6) {
                            arrayList2.add(new FT(n6, n7));
                        }
                        if (n7 >= this.detailrows.getFrom() && n7 <= this.detailrows.getTo() && this.repeatrowfooter.getTo() > this.repeatrowfooter.getFrom()) {
                            arrayList2.add(this.repeatrowfooter);
                        }
                        this.dealWithReportPage(arrayList2, arrayList, n, i, j);
                        ++n;
                    }
                }
                break;
            }
            default: {
                int n8 = this.pageRowIndexList.size();
                for (int i = 1; i < n8; ++i) {
                    int n9 = this.pageRowIndexList.get(i - 1);
                    int n10 = this.pageRowIndexList.get(i);
                    ArrayList<FT> arrayList = new ArrayList<FT>();
                    if (n9 >= this.detailrows.getFrom() && n9 < this.detailrows.getTo() && this.repeatrowheader.getTo() > this.repeatrowheader.getFrom()) {
                        arrayList.add(this.repeatrowheader);
                    }
                    if (n10 > n9) {
                        arrayList.add(new FT(n9, n10));
                    }
                    if (n10 >= this.detailrows.getFrom() && n10 <= this.detailrows.getTo() && this.repeatrowfooter.getTo() > this.repeatrowfooter.getFrom()) {
                        arrayList.add(this.repeatrowfooter);
                    }
                    int n11 = this.pageColumnIndexList.size();
                    for (int j = 1; j < n11; ++j) {
                        int n12 = this.pageColumnIndexList.get(j - 1);
                        int n13 = this.pageColumnIndexList.get(j);
                        ArrayList<FT> arrayList3 = new ArrayList<FT>();
                        if (n12 >= this.detailcolumns.getFrom() && n12 < this.detailcolumns.getTo() && this.repeatcolumnheader.getTo() > this.repeatcolumnheader.getFrom()) {
                            arrayList3.add(this.repeatcolumnheader);
                        }
                        if (n13 > n12) {
                            arrayList3.add(new FT(n12, n13));
                        }
                        if (n13 >= this.detailcolumns.getFrom() && n13 <= this.detailcolumns.getTo() && this.repeatcolumnfooter.getTo() > this.repeatcolumnfooter.getFrom()) {
                            arrayList3.add(this.repeatcolumnfooter);
                        }
                        this.dealWithReportPage(arrayList, arrayList3, n, j, i);
                        ++n;
                    }
                }
            }
        }
        FRContext.getLogger().log(Level.INFO, Inter.getLocText("INFO-Page_is_Generated"));
    }

    private void dealWithReportPage(List list, List list2, int n, int n2, int n3) {
        ReportPage reportPage = new ReportPage(this.report, new PageInfo(), this.setting, list.toArray(new FT[list.size()]), list2.toArray(new FT[list2.size()]), n2, n3);
        int n4 = ReportUtils.getReportSettings(this.report).getFirstPageNumber();
        int n5 = n + n4;
        int n6 = this.pageCount;
        reportPage.setCurrentPageNumber(n5);
        reportPage.getPageInfo().setTotalPages(n6);
        this.workSheetPageLists.add(reportPage);
    }
}

