/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.ColumnRow;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.core.DSColumn;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SheetUtils {
    private SheetUtils() {
    }

    private static CellElement getUpParent(Report report, CellElement cellElement) {
        if (cellElement.getCellExpandAttr().getUpParentColumnRow() != null) {
            return report.getCellElement(cellElement.getCellExpandAttr().getUpParentColumnRow().column, cellElement.getCellExpandAttr().getUpParentColumnRow().row);
        }
        return null;
    }

    private static boolean isUpCycle(Report report, CellElement cellElement) {
        boolean bl = false;
        HashSet<CellElement> hashSet = new HashSet<CellElement>();
        int n = 1;
        hashSet.add(cellElement);
        CellElement cellElement2 = SheetUtils.getUpParent(report, cellElement);
        while (cellElement2 != null) {
            hashSet.add(cellElement2);
            if (hashSet.size() != ++n) {
                bl = true;
                break;
            }
            cellElement2 = SheetUtils.getUpParent(report, cellElement2);
        }
        return bl;
    }

    private static CellElement getLeftParent(Report report, CellElement cellElement) {
        if (cellElement.getCellExpandAttr().getLeftParentColumnRow() != null) {
            return report.getCellElement(cellElement.getCellExpandAttr().getLeftParentColumnRow().column, cellElement.getCellExpandAttr().getLeftParentColumnRow().row);
        }
        return null;
    }

    private static boolean isLeftCycle(Report report, CellElement cellElement) {
        boolean bl = false;
        HashSet<CellElement> hashSet = new HashSet<CellElement>();
        int n = 1;
        hashSet.add(cellElement);
        CellElement cellElement2 = SheetUtils.getLeftParent(report, cellElement);
        while (cellElement2 != null) {
            hashSet.add(cellElement2);
            if (hashSet.size() != ++n) {
                bl = true;
                break;
            }
            cellElement2 = SheetUtils.getLeftParent(report, cellElement2);
        }
        return bl;
    }

    public static void calculateDefaultParent(Report report) {
        int n;
        int n2;
        int n3;
        Cloneable cloneable;
        Cloneable cloneable2;
        Object object;
        int n4;
        if (report == null) {
            return;
        }
        CellElement[] cellElementArray = new CellElement[report.getColumnCount()];
        CellElement[] cellElementArray2 = new CellElement[report.getColumnCount()];
        int n5 = report.getRowCount();
        for (n4 = 0; n4 < n5; ++n4) {
            object = report.getRow(n4);
            while (object.hasNext()) {
                int n6;
                cloneable2 = (CellElement)object.next();
                if (cloneable2 == null) continue;
                cloneable = cloneable2.getCellExpandAttr();
                if (cloneable == null) {
                    cloneable = new CellExpandAttr();
                    ((CellExpandAttr)cloneable).setDirection((byte)2);
                    cloneable2.setCellExpandAttr((CellExpandAttr)cloneable);
                }
                if (((CellExpandAttr)cloneable).isUpParentDefault()) {
                    CellElement cellElement = null;
                    n3 = cloneable2.getColumn();
                    n2 = cloneable2.getColumnSpan();
                    for (n6 = 0; n6 < n2 && ((cellElement = cellElementArray[n6 + n3]) == null || cellElement == cloneable2); ++n6) {
                    }
                    ((CellExpandAttr)cloneable).setUpParentColumnRow(cellElement == null || cellElement == cloneable2 ? null : ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
                    if (SheetUtils.isUpCycle(report, (CellElement)cloneable2)) {
                        ((CellExpandAttr)cloneable).setUpParentColumnRow(null);
                        cellElementArray = cellElementArray2;
                        CellElement cellElement2 = null;
                        n = cloneable2.getColumnSpan();
                        for (n2 = 0; n2 < n && ((cellElement2 = cellElementArray2[n2 + n3]) == null || cellElement2 == cloneable2); ++n2) {
                        }
                        ((CellExpandAttr)cloneable).setUpParentColumnRow(cellElement2 == null || cellElement2 == cloneable2 ? null : ColumnRow.valueOf(cellElement2.getColumn(), cellElement2.getRow()));
                    }
                }
                if (!SheetUtils.isUpCycle(report, (CellElement)cloneable2)) {
                    n3 = cloneable2.getColumnSpan();
                    for (int i = 0; i < n3; ++i) {
                        cellElementArray2[i + cloneable2.getColumn()] = cellElementArray[i + cloneable2.getColumn()];
                    }
                }
                if (((CellExpandAttr)cloneable).getDirection() == 1) {
                    int n7 = cloneable2.getColumn();
                    n6 = cloneable2.getColumnSpan();
                    for (n3 = 0; n3 < n6; ++n3) {
                        if (SheetUtils.isUpCycle(report, (CellElement)cloneable2)) continue;
                        cellElementArray[n3 + n7] = cloneable2;
                    }
                    continue;
                }
                if (((CellExpandAttr)cloneable).isUpParentDefault() || ((CellExpandAttr)cloneable).getUpParentColumnRow() != null) continue;
                int n8 = cloneable2.getColumn();
                n6 = cloneable2.getColumnSpan();
                for (n3 = 0; n3 < n6; ++n3) {
                    cellElementArray[n3 + n8] = null;
                }
            }
        }
        cellElementArray = new CellElement[report.getRowCount()];
        cellElementArray2 = new CellElement[report.getRowCount()];
        n5 = report.getColumnCount();
        for (n4 = 0; n4 < n5; ++n4) {
            object = report.getColumn(n4);
            while (object.hasNext()) {
                cloneable2 = (CellElement)object.next();
                if (cloneable2 == null) continue;
                cloneable = cloneable2.getCellExpandAttr();
                if (cloneable == null) {
                    cloneable = new CellExpandAttr();
                    ((CellExpandAttr)cloneable).setDirection((byte)2);
                    cloneable2.setCellExpandAttr((CellExpandAttr)cloneable);
                }
                if (((CellExpandAttr)cloneable).isLeftParentDefault()) {
                    CellElement cellElement = null;
                    n3 = cloneable2.getRow();
                    n2 = cloneable2.getRowSpan();
                    for (int i = 0; i < n2 && ((cellElement = cellElementArray[i + n3]) == null || cellElement == cloneable2); ++i) {
                    }
                    ((CellExpandAttr)cloneable).setLeftParentColumnRow(cellElement == null || cellElement == cloneable2 ? null : ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
                    if (SheetUtils.isLeftCycle(report, (CellElement)cloneable2)) {
                        ((CellExpandAttr)cloneable).setLeftParentColumnRow(null);
                        cellElementArray = cellElementArray2;
                        CellElement cellElement3 = null;
                        n = cloneable2.getRowSpan();
                        for (n2 = 0; n2 < n && ((cellElement3 = cellElementArray2[n2 + n3]) == null || cellElement3 == cloneable2); ++n2) {
                        }
                        ((CellExpandAttr)cloneable).setLeftParentColumnRow(cellElement3 == null || cellElement3 == cloneable2 ? null : ColumnRow.valueOf(cellElement3.getColumn(), cellElement3.getRow()));
                    }
                }
                if (!SheetUtils.isLeftCycle(report, (CellElement)cloneable2)) {
                    n3 = cloneable2.getRowSpan();
                    for (int i = 0; i < n3; ++i) {
                        cellElementArray2[i + cloneable2.getRow()] = cellElementArray[i + cloneable2.getRow()];
                    }
                }
                if (((CellExpandAttr)cloneable).getDirection() == 0) {
                    int n9 = cloneable2.getRow();
                    int n10 = cloneable2.getRowSpan();
                    for (n3 = 0; n3 < n10; ++n3) {
                        if (SheetUtils.isLeftCycle(report, (CellElement)cloneable2)) continue;
                        cellElementArray[n3 + n9] = cloneable2;
                    }
                    continue;
                }
                if (((CellExpandAttr)cloneable).isLeftParentDefault() || ((CellExpandAttr)cloneable).getLeftParentColumnRow() != null) continue;
                int n11 = cloneable2.getRow();
                int n12 = cloneable2.getRowSpan();
                for (n3 = 0; n3 < n12; ++n3) {
                    cellElementArray[n3 + n11] = null;
                }
            }
        }
        Iterator iterator = report.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement;
            CellElement cellElement4 = (CellElement)iterator.next();
            if (cellElement4 == null) continue;
            object = cellElement4.getCellExpandAttr();
            cloneable2 = ((CellExpandAttr)object).getLeftParentColumnRow();
            if (cloneable2 != null && (cloneable = report.getCellElement(((ColumnRow)cloneable2).column, ((ColumnRow)cloneable2).row)) != null) {
                SheetUtils.setAreaDefaultLeftParent(report, (CellElement)cloneable, cellElement4);
            }
            if ((cloneable = ((CellExpandAttr)object).getUpParentColumnRow()) == null || (cellElement = report.getCellElement(((ColumnRow)cloneable).column, ((ColumnRow)cloneable).row)) == null) continue;
            SheetUtils.setAreaDefaultUpParent(report, cellElement, cellElement4);
        }
    }

    private static void setAreaDefaultLeftParent(Report report, CellElement cellElement, CellElement cellElement2) {
        int n = cellElement.getRow();
        int n2 = cellElement.getRow() + cellElement.getRowSpan() - 1;
        int n3 = cellElement.getColumn();
        int n4 = cellElement2.getRow();
        int n5 = cellElement2.getRow() + cellElement2.getRowSpan() - 1;
        if (n2 == n5) {
            if (n <= n4) {
                return;
            }
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf(n3, n), report, n4, n - 1);
        } else if (n2 < n4) {
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf(n3, n), report, n2 + 1, n4);
        } else if (n5 < n) {
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf(n3, n), report, n5, n - 1);
        }
    }

    private static void setAreaDefaultUpParent(Report report, CellElement cellElement, CellElement cellElement2) {
        int n = cellElement.getRow();
        int n2 = cellElement.getColumn();
        int n3 = cellElement.getColumn() + cellElement.getColumnSpan() - 1;
        int n4 = cellElement2.getColumn();
        int n5 = cellElement2.getColumn() + cellElement2.getColumnSpan() - 1;
        if (n3 == n5) {
            if (n2 <= n4) {
                return;
            }
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf(n2, n), report, n4, n2 - 1);
        } else if (n3 < n4) {
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf(n2, n), report, n3 + 1, n4);
        } else if (n5 < n2) {
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf(n2, n), report, n5, n2 - 1);
        }
    }

    private static void setDefaultLeftParent(ColumnRow columnRow, Report report, int n, int n2) {
        Iterator iterator = report.cellIterator();
        while (iterator.hasNext()) {
            CellExpandAttr cellExpandAttr;
            Object object;
            CellElement cellElement = (CellElement)iterator.next();
            int n3 = cellElement.getRow();
            if (n3 < n || n3 > n2 || (object = cellElement.getValue()) instanceof DSColumn || !(cellExpandAttr = cellElement.getCellExpandAttr()).isLeftParentDefault() || cellExpandAttr.getLeftParentColumnRow() != null || SheetUtils.willLeadToDeathCircle(report, columnRow, ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()), new HashSet())) continue;
            cellExpandAttr.setLeftParentColumnRow(columnRow);
        }
    }

    private static void setDefaultUpParent(ColumnRow columnRow, Report report, int n, int n2) {
        Iterator iterator = report.cellIterator();
        while (iterator.hasNext()) {
            CellExpandAttr cellExpandAttr;
            Object object;
            CellElement cellElement = (CellElement)iterator.next();
            int n3 = cellElement.getColumn();
            if (n3 < n || n3 > n2 || (object = cellElement.getValue()) instanceof DSColumn || !(cellExpandAttr = cellElement.getCellExpandAttr()).isUpParentDefault() || cellExpandAttr.getUpParentColumnRow() != null || SheetUtils.willLeadToDeathCircle(report, columnRow, ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()), new HashSet())) continue;
            cellExpandAttr.setUpParentColumnRow(columnRow);
        }
    }

    private static boolean willLeadToDeathCircle(Report report, ColumnRow columnRow, ColumnRow columnRow2, Set set) {
        if (columnRow == null || columnRow2 == null) {
            return false;
        }
        CellElement cellElement = report.getCellElement(columnRow.column, columnRow.row);
        if (cellElement == null) {
            return false;
        }
        if (cellElement.getCellExpandAttr() != null) {
            CellExpandAttr cellExpandAttr = cellElement.getCellExpandAttr();
            ColumnRow columnRow3 = cellExpandAttr.getLeftParentColumnRow();
            ColumnRow columnRow4 = cellExpandAttr.getUpParentColumnRow();
            if (set.contains(columnRow3) || set.contains(columnRow4)) {
                return true;
            }
            if (columnRow2.equals(cellExpandAttr.getLeftParentColumnRow()) || columnRow2.equals(cellExpandAttr.getUpParentColumnRow())) {
                return true;
            }
            if (columnRow3 != null) {
                set.add(columnRow3);
            }
            if (columnRow4 != null) {
                set.add(columnRow4);
            }
            return SheetUtils.willLeadToDeathCircle(report, cellExpandAttr.getLeftParentColumnRow(), columnRow2, set) && SheetUtils.willLeadToDeathCircle(report, cellExpandAttr.getUpParentColumnRow(), columnRow2, set);
        }
        return false;
    }
}

