/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.barcode;

import com.fr.report.cellElement.BarcodeAttr;
import com.fr.report.core.barcode.BarcodeException;
import com.fr.report.core.barcode.BarcodeFactory;
import com.fr.report.core.barcode.BarcodeImpl;
import com.fr.report.core.barcode.line.code128.Code128Barcode;
import com.fr.report.painter.BarcodePainter;
import java.io.Serializable;

public class BarCodeUtils
implements Cloneable,
Serializable {
    private BarCodeUtils() {
    }

    public static BarcodeImpl getBarcodeImpl(BarcodePainter barcodePainter) throws BarcodeException {
        return BarCodeUtils.getBarcodeImpl(barcodePainter.getBarcodeAttr(), barcodePainter.getText());
    }

    public static BarcodeImpl getBarcodeImpl(BarcodeAttr barcodeAttr, String string) throws BarcodeException {
        int n = barcodeAttr.getType();
        if (string == null) {
            string = "123456789";
        }
        BarcodeImpl barcodeImpl = null;
        switch (n) {
            case 0: {
                barcodeImpl = BarcodeFactory.createCode39(string, false);
                break;
            }
            case 1: {
                barcodeImpl = BarcodeFactory.createCode39(string, true);
                break;
            }
            case 2: {
                barcodeImpl = BarcodeFactory.createCodabar(string);
                break;
            }
            case 3: {
                barcodeImpl = new Code128Barcode(string, 3);
                break;
            }
            case 4: {
                barcodeImpl = new Code128Barcode(string, 0);
                break;
            }
            case 5: {
                barcodeImpl = new Code128Barcode(string, 1);
                break;
            }
            case 6: {
                barcodeImpl = new Code128Barcode(string, 2);
                break;
            }
            case 7: {
                barcodeImpl = BarcodeFactory.createEAN128(string);
                break;
            }
            case 8: {
                barcodeImpl = BarcodeFactory.createUSPS(string);
                break;
            }
            case 9: {
                barcodeImpl = BarcodeFactory.createShipmentIdentificationNumber(string);
                break;
            }
            case 10: {
                barcodeImpl = BarcodeFactory.createSSCC18(string);
                break;
            }
            case 11: {
                barcodeImpl = BarcodeFactory.createSCC14ShippingCode(string);
                break;
            }
            case 12: {
                barcodeImpl = BarcodeFactory.createGlobalTradeItemNumber(string);
                break;
            }
            case 13: {
                barcodeImpl = BarcodeFactory.createPDF417(string);
                break;
            }
            case 14: {
                barcodeImpl = BarcodeFactory.createUSD4(string);
                break;
            }
            case 15: {
                barcodeImpl = BarcodeFactory.createNW7(string);
            }
        }
        if (barcodeImpl == null) {
            barcodeImpl = BarcodeFactory.createCode39(string, false);
        }
        barcodeImpl.setBarWidth(barcodeAttr.getBarWidth());
        barcodeImpl.setBarHeight(barcodeAttr.getBarHeight());
        barcodeImpl.setDrawingText(barcodeAttr.isDrawingText());
        return barcodeImpl;
    }

    public static String getBarCodeTypeName(int n) {
        switch (n) {
            case 0: {
                return "CODE39";
            }
            case 1: {
                return "CODE39CHECK";
            }
            case 2: {
                return "CODABAR";
            }
            case 3: {
                return "CODE128";
            }
            case 4: {
                return "CODE128A";
            }
            case 5: {
                return "CODE128B";
            }
            case 6: {
                return "CODE128C";
            }
            case 7: {
                return "EAN128";
            }
            case 8: {
                return "USPS";
            }
            case 9: {
                return "SHIPMENT_ID";
            }
            case 10: {
                return "SSCC-18";
            }
            case 11: {
                return "SCC-14";
            }
            case 12: {
                return "GTIN";
            }
            case 13: {
                return "PDF417";
            }
            case 14: {
                return "USD-4";
            }
            case 15: {
                return "NW-7";
            }
        }
        return "CODE39";
    }

    public static Integer[] getAllSupportedBarCodeTypeArray() {
        int n = 16;
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = new Integer(i);
        }
        return integerArray;
    }
}

