/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.barcode;

import com.fr.base.core.GraphHelper;
import com.fr.report.core.barcode.BarcodeException;
import com.fr.report.core.barcode.Module;
import com.fr.report.core.barcode.env.EnvironmentFactory;
import com.fr.report.core.barcode.output.AbstractOutput;
import com.fr.report.core.barcode.output.GraphicsOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.StringCharacterIterator;

public abstract class BarcodeImpl {
    private static final String[] UNITS = new String[]{"in", "px", "cm", "mm"};
    private static final double DEFAULT_BAR_HEIGHT = 50.0;
    protected String data;
    protected boolean drawingText;
    protected double barWidth = 1.0;
    protected double barHeight;
    private Font font;
    private Color foreground;
    private Color background;
    private Dimension size;
    private int x;
    private int y;
    private int resolution = -1;

    protected BarcodeImpl(String string) throws BarcodeException {
        if (string == null || string.length() == 0) {
            throw new BarcodeException("Data to encode cannot be empty");
        }
        this.data = string;
        double d = this.calculateMinimumBarHeight(this.getResolution());
        this.barHeight = d > 0.0 ? d : 50.0;
        this.font = EnvironmentFactory.getEnvironment().getDefaultFont();
        this.drawingText = true;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setSVGScalar(0.0078125, "in");
        this.invalidateSize();
    }

    public String getData() {
        return this.data;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.invalidateSize();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setDrawingText(boolean bl) {
        this.drawingText = bl;
        this.invalidateSize();
    }

    public boolean isDrawingText() {
        return this.drawingText;
    }

    public void setBarWidth(double d) {
        this.barWidth = d >= 1.0 ? d : 1.0;
        this.invalidateSize();
    }

    public void setBarHeight(double d) {
        if (d > this.calculateMinimumBarHeight(this.getResolution())) {
            this.barHeight = d;
            this.invalidateSize();
        }
    }

    public void setResolution(int n) {
        if (n > 0) {
            this.resolution = n;
            double d = this.calculateMinimumBarHeight(this.getResolution());
            if (d > this.barHeight) {
                this.barHeight = d;
            }
            this.invalidateSize();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return (int)this.getActualSize().getWidth();
    }

    public int getHeight() {
        return (int)this.getActualSize().getHeight();
    }

    public Rectangle getBounds() {
        return this.getBounds(new Rectangle());
    }

    public Rectangle getBounds(Rectangle rectangle) {
        rectangle.setBounds(this.getX(), this.getY(), (int)this.getActualSize().getWidth() + this.getX(), (int)this.getActualSize().getHeight() + this.getY());
        return rectangle;
    }

    public Dimension getPreferredSize() {
        return this.getActualSize();
    }

    public Dimension getMinimumSize() {
        return this.getActualSize();
    }

    public Dimension getMaximumSize() {
        return this.getActualSize();
    }

    public Dimension getSize() {
        return this.getActualSize();
    }

    public void draw(Graphics2D graphics2D, int n, int n2) {
        this.x = n;
        this.y = n2;
        this.size = this.internalDraw(graphics2D, n, n2, true);
    }

    protected abstract double getBarcodeWidth(int var1);

    protected abstract Module[] encodeData();

    protected abstract Module calculateChecksum();

    protected abstract Module getPreAmble();

    protected abstract Module getPostAmble();

    protected String getLabel() {
        return this.data;
    }

    protected double calculateMinimumBarHeight(int n) {
        return 0.0;
    }

    protected int getResolution() {
        if (this.resolution > 0) {
            return this.resolution;
        }
        return EnvironmentFactory.getEnvironment().getResolution();
    }

    private Dimension internalDraw(Graphics2D graphics2D, int n, int n2, boolean bl) {
        Module[] moduleArray;
        Color color = graphics2D.getColor();
        double d = n;
        GraphicsOutput graphicsOutput = new GraphicsOutput(graphics2D, this.font, this.barWidth, this.barHeight, bl, this.getForeground(), this.getBackground());
        if (bl) {
            moduleArray = this.getActualSize();
            ((AbstractOutput)graphicsOutput).beginDraw(moduleArray.width, moduleArray.height);
        }
        d += this.drawModule(this.getPreAmble(), graphicsOutput, d, n2);
        moduleArray = this.encodeData();
        for (int i = 0; i < moduleArray.length; ++i) {
            Module module = moduleArray[i];
            d += this.drawModule(module, graphicsOutput, d, n2);
        }
        d += this.drawModule(this.calculateChecksum(), graphicsOutput, d, n2);
        d += this.drawModule(this.getPostAmble(), graphicsOutput, d, n2);
        double d2 = this.barHeight + (double)n2;
        if (this.drawingText) {
            d2 += this.drawTextLabel(graphicsOutput, n, (int)d2, d);
        }
        if (bl) {
            ((AbstractOutput)graphicsOutput).endDraw();
        }
        graphics2D.setColor(color);
        return new Dimension((int)(d - (double)n), (int)d2 - n2);
    }

    private void invalidateSize() {
        this.size = null;
    }

    private Dimension getActualSize() {
        if (this.size == null) {
            this.size = this.calculateSize();
        }
        return this.size;
    }

    private Dimension calculateSize() {
        return this.internalDraw((Graphics2D)GraphHelper.createBufferedImage(1000, 1000, 10).getGraphics(), 0, 0, false);
    }

    protected double drawModule(Module module, AbstractOutput abstractOutput, double d, double d2) {
        if (module == null) {
            return 0.0;
        }
        return module.draw(abstractOutput, d, d2);
    }

    protected String beautify(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (Character.isDefined(c) && !Character.isISOControl(c)) {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public void setSVGScalar(double d, String string) {
        String string2 = "";
        boolean bl = false;
        for (int i = 0; !bl && i < UNITS.length; ++i) {
            if (string.equals(UNITS[i])) {
                bl = true;
            }
            if (i != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + UNITS[i];
        }
        if (!bl) {
            throw new IllegalArgumentException("SVG Units must be one of " + string2);
        }
    }

    private double drawTextLabel(AbstractOutput abstractOutput, double d, double d2, double d3) {
        String string = this.beautify(this.getLabel());
        return abstractOutput.drawText(string, d, d2, d3);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

