/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.barcode.env;

import com.fr.report.core.barcode.env.DefaultEnvironment;
import com.fr.report.core.barcode.env.Environment;
import com.fr.report.core.barcode.env.HeadlessEnvironment;
import com.fr.report.core.barcode.env.NonAWTEnvironment;

public class EnvironmentFactory {
    private static Environment env;
    private static Environment defaultEnvironment;

    protected EnvironmentFactory() {
    }

    public static Environment getEnvironment() {
        if (env == null) {
            EnvironmentFactory.determineCurrentEnvironment();
        }
        return env;
    }

    public static void setHeadlessMode() {
        env = new HeadlessEnvironment();
    }

    public static void setNonAWTMode() {
        env = new NonAWTEnvironment(72);
    }

    public static void setNonAWTMode(int n) {
        env = new NonAWTEnvironment(n);
    }

    public static void setDefaultMode() {
        EnvironmentFactory.determineCurrentEnvironment();
    }

    public static void setDefaultEnvironment(Environment environment) {
        env = null;
        defaultEnvironment = environment;
    }

    private static void determineCurrentEnvironment() {
        Environment environment = defaultEnvironment != null ? defaultEnvironment : new DefaultEnvironment();
        try {
            environment.getResolution();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            environment = new HeadlessEnvironment();
        }
        catch (InternalError internalError) {
            environment = new HeadlessEnvironment();
        }
        env = environment;
    }
}

