/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.barcode.line.codebar;

import com.fr.report.core.barcode.BarcodeException;
import com.fr.report.core.barcode.BarcodeImpl;
import com.fr.report.core.barcode.BlankModule;
import com.fr.report.core.barcode.Module;
import com.fr.report.core.barcode.SeparatorModule;
import com.fr.report.core.barcode.line.codebar.ModuleFactory;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class CodabarBarcode
extends BarcodeImpl {
    public static final String DEFAULT_START = "A";
    public static final String DEFAULT_STOP = "C";
    private int width = 0;
    private String label;

    public CodabarBarcode(String string) throws BarcodeException {
        super(string);
        this.label = string;
        this.validateData();
    }

    protected String getLabel() {
        return this.label;
    }

    protected double getBarcodeWidth(int n) {
        this.encodeData();
        return this.barWidth * (double)this.width;
    }

    protected Module[] encodeData() {
        this.width = 0;
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int i = 0; i < this.data.length(); ++i) {
            if (i > 0) {
                arrayList.add(new SeparatorModule(1));
                ++this.width;
            }
            char c = this.data.charAt(i);
            Module module = ModuleFactory.getModule(String.valueOf(c));
            arrayList.add(module);
            this.width += module.widthInBars();
        }
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        return null;
    }

    protected Module getPreAmble() {
        return new BlankModule(0);
    }

    protected Module getPostAmble() {
        return new BlankModule(0);
    }

    private void validateData() throws BarcodeException {
        this.replaceTraditionalStartStopWithModern();
        this.addDefaultStartStopIfRequired();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.data);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c)) {
                if (!ModuleFactory.isValid(String.valueOf(c))) {
                    throw new BarcodeException(c + " is not a valid character for Codabar encoding");
                }
                this.checkStartStop(c, n);
                stringBuffer.append(c);
            }
            ++n;
            c = stringCharacterIterator.next();
        }
        this.data = stringBuffer.toString();
    }

    private void addDefaultStartStopIfRequired() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter(this.data.charAt(0))) {
            stringBuffer.append(DEFAULT_START);
        }
        stringBuffer.append(this.data);
        if (!Character.isLetter(this.data.charAt(this.data.length() - 1))) {
            stringBuffer.append(DEFAULT_STOP);
        }
        this.data = stringBuffer.toString();
    }

    private void replaceTraditionalStartStopWithModern() {
        this.data = this.data.replace('a', 'A');
        this.data = this.data.replace('t', 'A');
        this.data = this.data.replace('b', 'B');
        this.data = this.data.replace('n', 'B');
        this.data = this.data.replace('c', 'C');
        this.data = this.data.replace('*', 'C');
        this.data = this.data.replace('d', 'D');
        this.data = this.data.replace('e', 'D');
    }

    private void checkStartStop(char c, int n) throws BarcodeException {
        if (Character.isLetter(c) && n > 0 && n < this.data.length() - 1) {
            throw new BarcodeException(c + " is only allowed as the first and last characters for Codabar barcodes");
        }
    }
}

