/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.cal;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.core.FT;
import com.fr.data.TableData;
import com.fr.report.AbstractReport;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.ReportPageAttr;
import com.fr.report.TemplateReport;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.TableDataColumn;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.cellElement.core.FunctionGrouper;
import com.fr.report.core.DeathCycleException;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.cal.FamilyMember;
import com.fr.report.core.cal.Rect;
import com.fr.report.core.cal.SheetExecuter;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class LayerSheetExecuter
extends SheetExecuter {
    protected TableData data = null;
    protected DSColumn dsColumn = null;
    protected TemplateReport report;
    protected int report_shrink_mode = 3;
    protected LayerFamilyMember[][] genealogy;
    protected FT repeat_page_head_rows = null;
    protected FT repeat_page_foot_rows = null;

    protected LayerSheetExecuter(TemplateReport templateReport, Map map) {
        this.report = templateReport;
        this.parameterMap = map;
        ReportPageAttr reportPageAttr = templateReport.getReportPageAttr();
        if (reportPageAttr != null) {
            int n = reportPageAttr.getRepeatHeaderRowFrom();
            int n2 = reportPageAttr.getRepeatHeaderRowTo();
            if (n2 >= n && n >= 0) {
                this.repeat_page_head_rows = new FT(n, n2 + 1);
            }
            int n3 = reportPageAttr.getRepeatFooterRowFrom();
            int n4 = reportPageAttr.getRepeatFooterRowTo();
            if (n4 >= n4 && n3 >= 0) {
                this.repeat_page_foot_rows = new FT(n3, n4 + 1);
            }
        }
        this.calculator = Calculator.createStaticCalculator();
        this.calculator.setCurrentReport(templateReport);
        this.calculator.setCurrentTableDataSource(templateReport.getTemplateWorkBook());
        this.report_shrink_mode = ReportUtils.getReportSettings(templateReport).getShrinkToFitMode();
        Iterator iterator = this.report.getTemplateWorkBook().getTableDataNameIterator();
        while (iterator.hasNext()) {
            TableData tableData = this.report.getTemplateWorkBook().getTableData((String)iterator.next());
            this.__setParameterValues(tableData.getParameters());
        }
        try {
            this.calculator.set("$$totalPage_number", "$$totalPage_number");
            this.calculator.set("$$page_number", "$$page_number");
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        this.calculator.pushNameSpace(ParameterMapNameSpace.create(map));
    }

    protected void buildGenealogy() {
        this.genealogy = new LayerFamilyMember[this.report.getRowCount()][this.report.getColumnCount()];
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.report.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            this.buildFamilyMember(cellElement, arrayList);
        }
    }

    protected LayerFamilyMember buildFamilyMember(CellElement cellElement, List list) {
        Object object;
        Cloneable cloneable;
        if (cellElement == null || list == null) {
            return null;
        }
        if (this.genealogy[cellElement.getRow()][cellElement.getColumn()] != null) {
            return this.genealogy[cellElement.getRow()][cellElement.getColumn()];
        }
        if (list.contains(cellElement)) {
            list.add(cellElement);
            throw new DeathCycleException("Death cycle exists when calculate parent: " + list);
        }
        list.add(cellElement);
        CellExpandAttr cellExpandAttr = cellElement.getCellExpandAttr();
        LayerFamilyMember layerFamilyMember = null;
        LayerFamilyMember layerFamilyMember2 = null;
        ColumnRow columnRow = cellExpandAttr.getLeftParentColumnRow();
        if (columnRow != null) {
            cloneable = this.report.getCellElement(columnRow.column, columnRow.row);
            layerFamilyMember = this.buildFamilyMember((CellElement)cloneable, list);
        }
        if ((columnRow = cellExpandAttr.getUpParentColumnRow()) != null) {
            cloneable = this.report.getCellElement(columnRow.column, columnRow.row);
            layerFamilyMember2 = this.buildFamilyMember((CellElement)cloneable, list);
        }
        cloneable = null;
        boolean bl = false;
        Object object2 = cellElement.getValue();
        if (object2 instanceof DSColumn) {
            cloneable = ((DSColumn)object2).getColumn();
            object = ((DSColumn)object2).getGrouper();
            if (object instanceof FunctionGrouper) {
                bl = ((FunctionGrouper)object).getDivideMode() != 1;
            }
        }
        this.genealogy[cellElement.getRow()][cellElement.getColumn()] = object = new LayerFamilyMember(cellElement, layerFamilyMember, layerFamilyMember2, (TableDataColumn)cloneable, bl);
        list.remove(cellElement);
        if (layerFamilyMember != null) {
            if (layerFamilyMember.sons == null) {
                layerFamilyMember.sons = new ArrayList();
            }
            layerFamilyMember.sons.add(object);
        }
        if (layerFamilyMember2 != null) {
            if (layerFamilyMember2.sons == null) {
                layerFamilyMember2.sons = new ArrayList();
            }
            layerFamilyMember2.sons.add(object);
        }
        return object;
    }

    protected void dealwith_row_height(CellElement cellElement, Report report) {
        if (cellElement == null || report == null) {
            return;
        }
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
        if (cellGUIAttr == null) {
            cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
        }
        if (this.report_shrink_mode == 1 && cellGUIAttr.getAdjustMode() == 3 || cellGUIAttr.getAdjustMode() == 1) {
            ((AbstractReport)report).shrinkTOFitRowHeightForCellElement(cellElement);
        }
    }

    protected void sort_FamilyMemberArray(LayerFamilyMember[] layerFamilyMemberArray) {
        if (layerFamilyMemberArray == null) {
            return;
        }
        Arrays.sort(layerFamilyMemberArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((LayerFamilyMember)object).rect.top - ((LayerFamilyMember)object2).rect.top;
            }
        });
    }

    protected void dealwith_layer(List list) {
        int n;
        if (list == null) {
            return;
        }
        for (n = 0; n < this.genealogy.length; ++n) {
            int n2;
            LayerFamilyMember[] layerFamilyMemberArray = this.genealogy[n];
            int n3 = n2 = layerFamilyMemberArray == null ? 0 : layerFamilyMemberArray.length;
            for (int i = 0; i < n2; ++i) {
                CellElement cellElement;
                Object object;
                LayerFamilyMember layerFamilyMember = layerFamilyMemberArray[i];
                if (layerFamilyMember == null || layerFamilyMember.leftParent != null || layerFamilyMember.upParent != null) continue;
                list.add(layerFamilyMember);
                if (this.data != null || !((object = (cellElement = layerFamilyMember.current).getValue()) instanceof DSColumn)) continue;
                this.dsColumn = (DSColumn)object;
                this.data = this.__us_name2TableData(this.dsColumn.getDSName());
            }
        }
        int n4 = list.size();
        for (n = 0; n < n4; ++n) {
            ((LayerFamilyMember)list.get(n)).refresh_rect();
        }
    }

    protected static class LayerFamilyMember
    extends FamilyMember {
        protected TableDataColumn column;
        protected int columnIndex = Integer.MIN_VALUE;
        protected Rect rect;
        protected boolean isGroup = false;
        protected ColumnRow current_cr;

        protected LayerFamilyMember(CellElement cellElement, LayerFamilyMember layerFamilyMember, LayerFamilyMember layerFamilyMember2, TableDataColumn tableDataColumn, boolean bl) {
            super(cellElement, layerFamilyMember, layerFamilyMember2);
            this.column = tableDataColumn;
            this.isGroup = bl;
            this.current_cr = ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow());
            this.rect = new Rect(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumn() + cellElement.getColumnSpan() - 1, cellElement.getRow() + cellElement.getRowSpan() - 1);
        }

        public int getColumnIndex(TableData tableData) {
            if (tableData == null || this.column == null) {
                return Integer.MIN_VALUE;
            }
            if (this.columnIndex >= -1) {
                return this.columnIndex;
            }
            this.columnIndex = this.column.getColumnIndex(tableData, null);
            return this.columnIndex;
        }

        public Rect refresh_rect() {
            if (this.sons != null) {
                int n = this.sons.size();
                for (int i = 0; i < n; ++i) {
                    this.rect.union(((LayerFamilyMember)this.sons.get(i)).refresh_rect());
                }
            }
            return this.rect;
        }
    }
}

