/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.cal;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.file.DatasourceManager;
import com.fr.data.TableData;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.TableDataAdapter;
import com.fr.report.TableDataSource;
import com.fr.report.TemplateReport;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public abstract class SheetExecuter {
    protected Calculator calculator;
    protected Map parameterMap;

    protected TableData __us_name2TableData(String string) {
        Object[] objectArray = this.dealwithDsName(string);
        if (objectArray[1] != null) {
            return (TableData)objectArray[1];
        }
        string = (String)objectArray[0];
        return this.__s_name2TableData(string);
    }

    protected TableData __s_name2TableData(String string) {
        TableDataSource tableDataSource = this.calculator.getCurrentTableDataSource();
        TableData tableData = tableDataSource.getTableData(string);
        if (tableData != null) {
            this.__setParameterValues(tableData.getParameters());
        }
        if (tableData == null) {
            DatasourceManager datasourceManager = FRContext.getDatasourceManager();
            tableData = datasourceManager.getTableData(string);
            if (tableData == null) {
                tableData = TableData.EMPTY_TABLEDATA;
                FRContext.getLogger().log(Level.INFO, string + ":" + Inter.getLocText("Utils-Can_not_find_the_corresponding_TableData"));
            }
            tableDataSource.putTableData(string, tableData);
            this.__setParameterValues(tableData.getParameters());
        }
        return tableData;
    }

    protected Object[] dealwithDsName(String string) {
        Object[] objectArray = new Object[2];
        if (string.startsWith("=")) {
            try {
                Object object = this.calculator.eval(string.substring(1));
                if (object == null) {
                    objectArray[1] = TableData.EMPTY_TABLEDATA;
                } else if (object instanceof TableData) {
                    objectArray[1] = object;
                } else {
                    string = object.toString();
                }
            }
            catch (UtilEvalError utilEvalError) {
                String string2 = "error happens at resovle TableData\nformula expression is " + string + "\nerror message is " + utilEvalError.getMessage();
                FRContext.getLogger().log(Level.WARNING, string2, utilEvalError);
            }
        }
        objectArray[0] = string;
        return objectArray;
    }

    protected void __setParameterValues(Parameter[] parameterArray) {
        if (parameterArray == null) {
            return;
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            Parameter parameter = parameterArray[i];
            Object v = this.parameterMap.get(parameter.getName());
            if (v == null) continue;
            parameter.setValue(v);
        }
    }

    protected void releaseTableData(TemplateReport templateReport) {
        Iterator iterator = templateReport.getTemplateWorkBook().getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TableData tableData = templateReport.getTemplateWorkBook().getTableData(string);
            if (string == null) continue;
            try {
                tableData.release();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    public static TableDataAdapter createDefaultDBTableDataAdapter(DBTableData dBTableData, String string) {
        TableDataAdapter tableDataAdapter;
        if (dBTableData == null) {
            return null;
        }
        if (dBTableData.isShareTableData()) {
            tableDataAdapter = FRContext.getCacheManager().get(dBTableData.getDatabase(), string, dBTableData.getMaxMemRowCount());
            tableDataAdapter.register(dBTableData);
        } else {
            tableDataAdapter = DBTableData.createCacheableAdapter(dBTableData.getDatabase(), string, dBTableData.getResultIndexOfOut(), dBTableData.getMaxMemRowCount());
        }
        return tableDataAdapter;
    }

    public TableDataAdapter createDBTableDataAdapter(DBTableData dBTableData, String string) {
        return SheetExecuter.createDefaultDBTableDataAdapter(dBTableData, string);
    }
}

