/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.headerfooter;

import com.fr.base.DefaultValues;
import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.GraphHelper;
import com.fr.report.core.headerfooter.AbstractHFElement;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.geom.Dimension2D;
import java.util.StringTokenizer;

public class TextHFElement
extends AbstractHFElement {
    private String text = null;
    private FRFont frFont = null;

    public TextHFElement() {
        this("", null);
    }

    public TextHFElement(String string, FRFont fRFont) {
        this.setText(string);
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        }
        this.setFRFont(fRFont);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public FRFont getFRFont() {
        return this.frFont;
    }

    public void setFRFont(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public Dimension2D getSize() {
        int n;
        int n2;
        String string = this.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n3 = string.length();
        for (n2 = 0; n2 < n3; ++n2) {
            n = string.charAt(n2);
            if (n == 13) {
                if (n2 < n3 - 1 && string.charAt(n2 + 1) == '\n') {
                    stringTokenizer = new StringTokenizer(string, "\r\n");
                    break;
                }
                stringTokenizer = new StringTokenizer(string, "\r");
                break;
            }
            if (n == 10) break;
        }
        n2 = stringTokenizer.countTokens();
        n = 0;
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(this.getFRFont());
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) {
                string2 = "";
            }
            n = Math.max(fontMetrics.stringWidth(string2), n);
        }
        return new Dimension(n, fontMetrics.getHeight() * n2);
    }

    public boolean equals(Object object) {
        return object instanceof TextHFElement && ComparatorUtils.equals(this.frFont, ((TextHFElement)object).frFont) && ComparatorUtils.equals(this.text, ((TextHFElement)object).text);
    }

    public Object clone() throws CloneNotSupportedException {
        TextHFElement textHFElement = (TextHFElement)super.clone();
        if (this.getFRFont() != null) {
            textHFElement.setFRFont((FRFont)this.getFRFont().clone());
        }
        return textHFElement;
    }
}

