/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.headerfooter;

import com.fr.base.FRFont;
import com.fr.base.core.GraphHelper;
import com.fr.report.core.headerfooter.AbstractHFPaintable;
import com.fr.report.core.headerfooter.HFElement;
import com.fr.report.core.headerfooter.TextHFElement;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.StringTokenizer;

public class TextHFPaintable
extends AbstractHFPaintable {
    private TextHFElement textHFElement;

    public TextHFPaintable(TextHFElement textHFElement) {
        this.textHFElement = textHFElement;
    }

    public TextHFPaintable(Point2D point2D, TextHFElement textHFElement) {
        super(point2D);
        this.textHFElement = textHFElement;
    }

    public HFElement getHFElement() {
        return this.textHFElement;
    }

    public void paint(Graphics2D graphics2D) {
        int n;
        FRFont fRFont = this.textHFElement.getFRFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(fRFont);
        Font font = graphics2D.getFont();
        graphics2D.setPaint(fRFont.getForeground());
        graphics2D.setFont(fRFont);
        String string = this.textHFElement.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c == '\r') {
                if (n < n2 - 1 && string.charAt(n + 1) == '\n') {
                    stringTokenizer = new StringTokenizer(string, "\r\n");
                    break;
                }
                stringTokenizer = new StringTokenizer(string, "\r");
                break;
            }
            if (c == '\n') break;
        }
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) {
                string2 = "";
            }
            GraphHelper.drawString(graphics2D, string2, this.getPaintLocation().getX(), (double)n + this.getPaintLocation().getY() + (double)fontMetrics.getAscent());
            n += fontMetrics.getHeight();
        }
        graphics2D.setFont(font);
    }
}

