/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.ColumnRow;
import com.fr.base.StringUtils;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.condition.Condition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.ObjectCondition;
import com.fr.data.core.Compare;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.CellElement;
import com.fr.report.highlight.Highlight;
import com.fr.report.script.Calculator;

public class AbstractHighlight
implements Highlight {
    private static final long serialVersionUID = -2453532958147936705L;
    private Condition condition;
    private String name;

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean eval(CellElement cellElement, Calculator calculator) {
        if (cellElement == null) {
            return true;
        }
        calculator.setCurrentColumnRow(ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
        return this.condition.eval(cellElement.getValue(), calculator);
    }

    public void action(CellElement cellElement, Calculator calculator) {
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractHighlight abstractHighlight = (AbstractHighlight)super.clone();
        if (this.condition != null) {
            abstractHighlight.setCondition((Condition)this.condition.clone());
        }
        return abstractHighlight;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Name")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.name = string2;
                }
            } else if (string.equals("JoinCondition")) {
                int n = 0;
                String string3 = xMLableReader.getAttr("join");
                if (string3 != null) {
                    n = Integer.parseInt(string3);
                }
                xMLableReader.readXMLObject(new XMLObject(new Integer(n)){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ("Compare".equals(string = xMLableReader.getTagName()) || string.equals("Condition"))) {
                            Compare compare = new Compare(0, "");
                            xMLableReader.readXMLObject(compare);
                            if (AbstractHighlight.this.condition instanceof ListCondition) {
                                AbstractHighlight.this.condition = new ListCondition();
                            }
                            ((ListCondition)AbstractHighlight.this.condition).addJoinCondition((Integer)this.obj, new ObjectCondition(compare));
                        }
                    }
                });
            } else if ("Condition".equals(string)) {
                this.condition = DataXMLUtils.readXMLCondition(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.name)) {
            xMLPrintWriter.startTAG("Name").textNode(this.name).end();
        }
        DataXMLUtils.writeXMLCondition(xMLPrintWriter, this.condition);
    }
}

