/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.Style;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.highlight.AbstractHighlightAction;
import com.fr.report.script.Calculator;
import java.awt.Color;
import java.util.Iterator;

public class BackgroundHighlightAction
extends AbstractHighlightAction {
    private Background background = ColorBackground.getInstance(Color.white);
    private int scope = 0;

    public BackgroundHighlightAction() {
    }

    public BackgroundHighlightAction(Background background, int n) {
        this.background = background;
        this.scope = n;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        if (cellElement == null) {
            return;
        }
        Report report = calculator.getCurrentReport();
        switch (this.getScope()) {
            case 1: {
                if (report == null) {
                    return;
                }
                int n = cellElement.getRow();
                Iterator iterator = report.getRow(n);
                while (iterator.hasNext()) {
                    this.modifyBackground((CellElement)iterator.next(), this.background);
                }
                break;
            }
            case 2: {
                if (report == null) {
                    return;
                }
                int n = cellElement.getColumn();
                Iterator iterator = report.getColumn(n);
                while (iterator.hasNext()) {
                    this.modifyBackground((CellElement)iterator.next(), this.background);
                }
                break;
            }
            default: {
                this.modifyBackground(cellElement, this.background);
            }
        }
    }

    private void modifyBackground(CellElement cellElement, Background background) {
        if (cellElement == null) {
            return;
        }
        Style style = cellElement.getStyle();
        cellElement.setStyle(style.deriveBackground(this.background));
    }

    public Object clone() throws CloneNotSupportedException {
        BackgroundHighlightAction backgroundHighlightAction = (BackgroundHighlightAction)super.clone();
        backgroundHighlightAction.setBackground((Background)this.getBackground().clone());
        return backgroundHighlightAction;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("Background".equals(string2)) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            }
            if ("Scope".equals(string2) && (string = xMLableReader.getAttr("val")) != null) {
                this.setScope(Integer.parseInt(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.background != null) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, this.getBackground());
        }
        if (this.getScope() != 0) {
            xMLPrintWriter.startTAG("Scope").attr("val", this.getScope()).end();
        }
    }
}

