/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.Style;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.dialog.core.CellBorderStyle;
import com.fr.report.CellElement;
import com.fr.report.highlight.AbstractHighlightAction;
import com.fr.report.script.Calculator;
import java.awt.Color;

public class BorderHighlightAction
extends AbstractHighlightAction {
    private int topLine;
    private int bottomLine;
    private int leftLine;
    private int rightLine;
    private Color topColor;
    private Color bottomColor;
    private Color leftColor;
    private Color rightColor;

    public BorderHighlightAction() {
    }

    public BorderHighlightAction(CellBorderStyle cellBorderStyle) {
        if (cellBorderStyle == null) {
            return;
        }
        this.topLine = cellBorderStyle.getTopStyle();
        this.topColor = cellBorderStyle.getTopColor();
        this.bottomLine = cellBorderStyle.getBottomStyle();
        this.bottomColor = cellBorderStyle.getBottomColor();
        this.leftLine = cellBorderStyle.getLeftStyle();
        this.leftColor = cellBorderStyle.getLeftColor();
        this.rightLine = cellBorderStyle.getRightStyle();
        this.rightColor = cellBorderStyle.getRightColor();
    }

    public CellBorderStyle getCellBorder() {
        CellBorderStyle cellBorderStyle = new CellBorderStyle();
        cellBorderStyle.setTopStyle(this.getLine(this.topLine));
        cellBorderStyle.setBottomStyle(this.getLine(this.bottomLine));
        cellBorderStyle.setLeftStyle(this.getLine(this.leftLine));
        cellBorderStyle.setRightStyle(this.getLine(this.rightLine));
        cellBorderStyle.setTopColor(this.getColor(this.topColor));
        cellBorderStyle.setBottomColor(this.getColor(this.bottomColor));
        cellBorderStyle.setLeftColor(this.getColor(this.leftColor));
        cellBorderStyle.setRightColor(this.getColor(this.rightColor));
        return cellBorderStyle;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        if (cellElement == null) {
            return;
        }
        Style style = cellElement.getStyle();
        cellElement.setStyle(style.deriveBorder(this.getLine(this.topLine), this.getColor(this.topColor), this.getLine(this.bottomLine), this.getColor(this.bottomColor), this.getLine(this.leftLine), this.getColor(this.leftColor), this.getLine(this.rightLine), this.getColor(this.rightColor)));
    }

    public int getLine(int n) {
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public Color getColor(Color color) {
        if (color != Color.black) {
            return color;
        }
        return Color.black;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "Border".equals(xMLableReader.getTagName())) {
            this.topLine = Integer.parseInt(xMLableReader.getAttr("topLine"));
            this.topColor = new Color(Integer.parseInt(xMLableReader.getAttr("topColor")), true);
            this.bottomLine = Integer.parseInt(xMLableReader.getAttr("bottomLine"));
            this.bottomColor = new Color(Integer.parseInt(xMLableReader.getAttr("bottomColor")), true);
            this.leftLine = Integer.parseInt(xMLableReader.getAttr("leftLine"));
            this.leftColor = new Color(Integer.parseInt(xMLableReader.getAttr("leftColor")), true);
            this.rightLine = Integer.parseInt(xMLableReader.getAttr("rightLine"));
            this.rightColor = new Color(Integer.parseInt(xMLableReader.getAttr("rightColor")), true);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Border").attr("topLine", this.getLine(this.topLine)).attr("topColor", this.getColor(this.topColor).getRGB()).attr("bottomLine", this.getLine(this.bottomLine)).attr("bottomColor", this.getColor(this.bottomColor).getRGB()).attr("leftLine", this.getLine(this.leftLine)).attr("leftColor", this.getColor(this.leftColor).getRGB()).attr("rightLine", this.getLine(this.rightLine)).attr("rightColor", this.getColor(this.rightColor).getRGB()).end();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Border").append(" topLine=\"").append(this.getLine(this.topLine)).append("\" topColor=\"").append(this.getColor(this.topColor).getRGB()).append("\" bottomLine=\"").append(this.getLine(this.bottomLine)).append("\" bottomColor=\"").append(this.getColor(this.bottomColor).getRGB()).append("\" leftLine=\"").append(this.getLine(this.leftLine)).append("\" leftColor=\"").append(this.getColor(this.leftColor).getRGB()).append("\" rightLine=\"").append(this.getLine(this.rightLine)).append("\" rightColor=\"").append(this.getColor(this.rightColor).getRGB()).append("\">").append("</Border>");
    }
}

