/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.highlight.AbstractHighlightAction;
import com.fr.report.script.Calculator;

public class ColWidthHighlightAction
extends AbstractHighlightAction {
    private int columnWidth;

    public ColWidthHighlightAction() {
    }

    public ColWidthHighlightAction(int n) {
        this.columnWidth = n;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int n) {
        this.columnWidth = n;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        int n;
        if (cellElement == null || calculator == null || calculator.getCurrentReport() == null) {
            return;
        }
        Report report = calculator.getCurrentReport();
        int n2 = n + cellElement.getColumnSpan();
        for (n = cellElement.getColumn(); n < n2; ++n) {
            report.setColumnWidth(n, this.columnWidth);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "ColumnWidth".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttr("i")) != null) {
            this.setColumnWidth(Integer.parseInt(string));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.columnWidth > 0) {
            xMLPrintWriter.startTAG("ColumnWidth").attr("i", this.columnWidth).end();
        }
    }
}

