/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.FRFont;
import com.fr.base.Style;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.highlight.AbstractHighlightAction;
import com.fr.report.script.Calculator;
import java.util.Iterator;

public class FRFontHighlightAction
extends AbstractHighlightAction {
    private FRFont font = FRFont.getInstance();
    private int scope = 0;

    public FRFontHighlightAction() {
    }

    public FRFontHighlightAction(FRFont fRFont, int n) {
        this.font = fRFont;
        this.scope = n;
    }

    public FRFont getFRFont() {
        return this.font;
    }

    public void setFRFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        if (cellElement == null) {
            return;
        }
        Report report = calculator.getCurrentReport();
        switch (this.getScope()) {
            case 1: {
                if (report == null) {
                    return;
                }
                int n = cellElement.getRow();
                Iterator iterator = report.getRow(n);
                while (iterator.hasNext()) {
                    this.modifyFRFont((CellElement)iterator.next(), this.font);
                }
                break;
            }
            case 2: {
                if (report == null) {
                    return;
                }
                int n = cellElement.getColumn();
                Iterator iterator = report.getColumn(n);
                while (iterator.hasNext()) {
                    this.modifyFRFont((CellElement)iterator.next(), this.font);
                }
                break;
            }
            default: {
                this.modifyFRFont(cellElement, this.font);
            }
        }
    }

    private void modifyFRFont(CellElement cellElement, FRFont fRFont) {
        if (cellElement == null) {
            return;
        }
        Style style = cellElement.getStyle();
        cellElement.setStyle(style.deriveFRFont(fRFont));
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (BaseXMLUtils.isFRFontTagName(string2)) {
                this.font = BaseXMLUtils.readFRFont(xMLableReader);
            } else if ("Scope".equals(string2) && (string = xMLableReader.getAttr("val")) != null) {
                this.setScope(Integer.parseInt(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.font != null && this.font != FRFont.getInstance()) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.font);
        }
        if (this.getScope() != 0) {
            xMLPrintWriter.startTAG("Scope").attr("val", this.getScope()).end();
        }
    }
}

