/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.FRFont;
import com.fr.base.Style;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.highlight.AbstractHighlightAction;
import com.fr.report.script.Calculator;
import java.awt.Color;
import java.util.Iterator;

public class ForegroundHighlightAction
extends AbstractHighlightAction {
    private Color foregroundColor = Color.black;
    private int scope = 0;

    public ForegroundHighlightAction() {
    }

    public ForegroundHighlightAction(Color color, int n) {
        this.foregroundColor = color;
        this.scope = n;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        if (cellElement == null) {
            return;
        }
        Report report = calculator.getCurrentReport();
        switch (this.getScope()) {
            case 1: {
                if (report == null) {
                    return;
                }
                int n = cellElement.getRow();
                Iterator iterator = report.getRow(n);
                while (iterator.hasNext()) {
                    this.modifyForeground((CellElement)iterator.next(), this.foregroundColor);
                }
                break;
            }
            case 2: {
                if (report == null) {
                    return;
                }
                int n = cellElement.getColumn();
                Iterator iterator = report.getColumn(n);
                while (iterator.hasNext()) {
                    this.modifyForeground((CellElement)iterator.next(), this.foregroundColor);
                }
                break;
            }
            default: {
                this.modifyForeground(cellElement, this.foregroundColor);
            }
        }
    }

    private void modifyForeground(CellElement cellElement, Color color) {
        if (cellElement == null) {
            return;
        }
        Style style = cellElement.getStyle();
        FRFont fRFont = style.getFRFont();
        fRFont = fRFont.applyForeground(color);
        cellElement.setStyle(style.deriveFRFont(fRFont));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ForegroundHighlightAction)) {
            return false;
        }
        ForegroundHighlightAction foregroundHighlightAction = (ForegroundHighlightAction)object;
        return this.foregroundColor.getRGB() == foregroundHighlightAction.foregroundColor.getRGB() && this.scope == foregroundHighlightAction.scope;
    }

    public Object clone() throws CloneNotSupportedException {
        ForegroundHighlightAction foregroundHighlightAction = (ForegroundHighlightAction)super.clone();
        foregroundHighlightAction.setForegroundColor(new Color(this.getForegroundColor().getRGB(), true));
        return foregroundHighlightAction;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("Foreground".equals(string2) && (string = xMLableReader.getAttr("color")) != null) {
                this.setForegroundColor(new Color(Integer.parseInt(string), true));
            }
            if ("Scope".equals(string2) && (string = xMLableReader.getAttr("val")) != null) {
                this.setScope(Integer.parseInt(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.foregroundColor != null && this.foregroundColor != Color.black) {
            xMLPrintWriter.startTAG("Foreground").attr("color", this.getForegroundColor().getRGB()).end();
        }
        if (this.getScope() != 0) {
            xMLPrintWriter.startTAG("Scope").attr("val", this.getScope()).end();
        }
    }
}

