/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.highlight.AbstractHighlightAction;
import com.fr.report.script.Calculator;
import java.util.Iterator;

public class PaddingHighlightAction
extends AbstractHighlightAction {
    private byte paddingLeft = (byte)2;
    private byte paddingRight = (byte)2;
    private int scope = 0;

    public PaddingHighlightAction() {
    }

    public PaddingHighlightAction(byte by, byte by2, int n) {
        this.paddingLeft = by;
        this.paddingRight = by2;
        this.scope = n;
    }

    public byte getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(byte by) {
        this.paddingLeft = by;
    }

    public byte getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(byte by) {
        this.paddingRight = by;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        if (cellElement == null) {
            return;
        }
        Report report = calculator.getCurrentReport();
        switch (this.getScope()) {
            case 1: {
                if (report == null) {
                    return;
                }
                int n = cellElement.getRow();
                Iterator iterator = report.getRow(n);
                while (iterator.hasNext()) {
                    this.modifyPadding((CellElement)iterator.next(), this.paddingLeft, this.paddingRight);
                }
                break;
            }
            case 2: {
                if (report == null) {
                    return;
                }
                int n = cellElement.getColumn();
                Iterator iterator = report.getColumn(n);
                while (iterator.hasNext()) {
                    this.modifyPadding((CellElement)iterator.next(), this.paddingLeft, this.paddingRight);
                }
                break;
            }
            default: {
                this.modifyPadding(cellElement, this.paddingLeft, this.paddingRight);
            }
        }
    }

    private void modifyPadding(CellElement cellElement, byte by, byte by2) {
        cellElement.setStyle(cellElement.getStyle().derivePadding(by, by2));
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("Padding".equals(string2)) {
                string = xMLableReader.getAttr("left");
                if (string != null) {
                    this.setPaddingLeft((byte)Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("right")) != null) {
                    this.setPaddingRight((byte)Integer.parseInt(string));
                }
            }
            if ("Scope".equals(string2) && (string = xMLableReader.getAttr("val")) != null) {
                this.setScope(Integer.parseInt(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Padding").attr("left", this.paddingLeft).attr("right", this.paddingRight).end();
        if (this.getScope() != 0) {
            xMLPrintWriter.startTAG("Scope").attr("val", this.getScope()).end();
        }
    }
}

