/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.highlight.AbstractHighlightAction;
import com.fr.report.script.Calculator;

public class PageHighlightAction
extends AbstractHighlightAction {
    public static final int NO_PAGE = 0;
    public static final int AFTER_ROW = 1;
    public static final int BEFORE_ROW = 2;
    public static final int AFTER_COL = 3;
    public static final int BEFORE_COL = 4;
    private int page = 0;

    public PageHighlightAction() {
    }

    public PageHighlightAction(int n) {
        this.page = n;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
        if (cellPageAttr == null) {
            cellPageAttr = new CellPageAttr();
            cellElement.setCellPageAttr(cellPageAttr);
        } else {
            try {
                cellPageAttr = (CellPageAttr)cellPageAttr.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            cellElement.setCellPageAttr(cellPageAttr);
        }
        switch (this.page) {
            case 1: {
                cellPageAttr.setPageAfterRow(true);
                break;
            }
            case 2: {
                cellPageAttr.setPageBeforeRow(true);
                break;
            }
            case 3: {
                cellPageAttr.setPageAfterColumn(true);
                break;
            }
            case 4: {
                cellPageAttr.setPageBeforeColumn(true);
                break;
            }
            case 0: {
                cellPageAttr.setPageAfterRow(false);
                cellPageAttr.setPageBeforeRow(false);
                cellPageAttr.setPageAfterColumn(false);
                cellPageAttr.setPageBeforeColumn(false);
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "P".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttr("i")) != null) {
            this.setPage(Integer.parseInt(string));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.page >= 0 && this.page <= 4) {
            xMLPrintWriter.startTAG("P").attr("i", this.page).end();
        }
    }
}

