/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.highlight;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.highlight.AbstractHighlightAction;
import com.fr.report.script.Calculator;

public class RowHeightHighlightAction
extends AbstractHighlightAction {
    private int rowHeight;

    public RowHeightHighlightAction() {
    }

    public RowHeightHighlightAction(int n) {
        this.rowHeight = n;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        int n;
        if (cellElement == null || calculator == null) {
            return;
        }
        Report report = calculator.getCurrentReport();
        if (report == null) {
            return;
        }
        int n2 = n + cellElement.getRowSpan();
        for (n = cellElement.getRow(); n < n2; ++n) {
            report.setRowHeight(n, this.rowHeight);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "RowHeight".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttr("i")) != null) {
            this.setRowHeight(Integer.parseInt(string));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.rowHeight > 0) {
            xMLPrintWriter.startTAG("RowHeight").attr("i", this.rowHeight).end();
        }
    }
}

