/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.report.CellElement;
import com.fr.report.PageSet;
import com.fr.report.PaperSetting;
import com.fr.report.Report;
import com.fr.report.ReportGetter;
import com.fr.report.ReportPage;
import com.fr.report.ResultWorkBook;
import com.fr.report.WorkSheet;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.cal.LayerPageReport;
import com.fr.report.core.cal.LayerReport;
import com.fr.report.io.AbstractAppExporter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.Format;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class CSVExporter
extends AbstractAppExporter {
    private void exportReport(OutputStream outputStream, ReportGetter reportGetter) throws Exception {
        WorkSheet workSheet = new WorkSheet();
        Iterator iterator = reportGetter.cellIterator();
        while (iterator.hasNext()) {
            workSheet.addCellElement((CellElement)iterator.next());
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        String string = null;
        for (int i = 0; i < workSheet.getRowCount(); ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < workSheet.getColumnCount(); ++j) {
                CellElement cellElement = workSheet.getCellElement(j, i);
                if (cellElement == null || cellElement.getColumn() != j || cellElement.getRow() != i) {
                    string = "";
                } else {
                    Object object = cellElement.getValue();
                    if (object == null) {
                        object = "";
                    }
                    Style style = cellElement.getStyle();
                    Format format = style.getFormat();
                    string = PaintUtils.valueToText(object, format);
                }
                if (j != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string);
            }
            if (stringBuffer == null) continue;
            printWriter.println(stringBuffer.toString());
        }
        printWriter.flush();
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        List list = ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook);
        int n = resultWorkBook.getReportCount();
        for (int i = 0; i < n; ++i) {
            this.export(outputStream, resultWorkBook.getReport(i), (PaperSetting)list.get(i));
        }
    }

    private void export(OutputStream outputStream, Report report, PaperSetting paperSetting) throws Exception {
        if (report instanceof LayerReport || report instanceof LayerPageReport) {
            FRContext.getLogger().log(Level.INFO, "LayerReport start export");
            PageSet pageSet = report.generateReportPageSet(paperSetting).getTraversingCase();
            this.export(outputStream, pageSet);
            pageSet.release();
        } else if (report != null) {
            FRContext.getLogger().log(Level.INFO, "UnLayerReport start export");
            this.exportReport(outputStream, report);
        }
    }

    public void export(OutputStream outputStream, PageSet pageSet) throws Exception {
        ReportPage reportPage;
        for (int i = 0; i < pageSet.size() && (reportPage = pageSet.getPage(i)) != null; ++i) {
            this.exportReport(outputStream, reportPage);
        }
    }
}

