/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.StringUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import java.io.Serializable;

public class ExcelExportAttr
implements XMLReadable,
Cloneable,
Serializable {
    private boolean isExportHidedRow = true;
    private boolean isExportHidedColumn = true;
    private String password = null;
    private String protectedWord = null;

    public boolean isExportHidedRow() {
        return this.isExportHidedRow;
    }

    public void setExportHidedRow(boolean bl) {
        this.isExportHidedRow = bl;
    }

    public boolean isExportHidedColumn() {
        return this.isExportHidedColumn;
    }

    public void setExportHidedColumn(boolean bl) {
        this.isExportHidedColumn = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ExcelExportAttr");
        if (!this.isExportHidedColumn()) {
            xMLPrintWriter.attr("hideColumn", this.isExportHidedColumn);
        }
        if (!this.isExportHidedRow()) {
            xMLPrintWriter.attr("hideRow", this.isExportHidedRow);
        }
        if (StringUtils.isNotBlank(this.getPassword())) {
            xMLPrintWriter.attr("pwd", ReportXMLUtils.passwordString(this.password));
        }
        if (StringUtils.isNotBlank(this.getProtectedWord())) {
            xMLPrintWriter.attr("protectedWord", ReportXMLUtils.passwordString(this.getProtectedWord()));
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.isAttr()) {
            string = xMLableReader.getAttr("hideRow");
            if (string != null) {
                this.setExportHidedRow(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("hideColumn")) != null) {
                this.setExportHidedColumn(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("pwd")) != null) {
                this.setPassword(ReportXMLUtils.unPasswordString(string));
            }
            if ((string = xMLableReader.getAttr("protectedWord")) != null) {
                this.setProtectedWord(ReportXMLUtils.unPasswordString(string));
            }
        }
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if ("ExportHidedRow".equals(string2)) {
                string = xMLableReader.getElementValue();
                if (string != null) {
                    this.setExportHidedRow(Boolean.valueOf(string));
                }
            } else if ("ExportHidedColumn".equals(string2) && (string = xMLableReader.getElementValue()) != null) {
                this.setExportHidedColumn(Boolean.valueOf(string));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ExcelExportAttr excelExportAttr = (ExcelExportAttr)super.clone();
        excelExportAttr.setExportHidedColumn(this.isExportHidedColumn());
        excelExportAttr.setExportHidedRow(this.isExportHidedRow());
        return excelExportAttr;
    }

    public String getProtectedWord() {
        return this.protectedWord;
    }

    public void setProtectedWord(String string) {
        this.protectedWord = string;
    }
}

