/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.BaseUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRFont;
import com.fr.base.Painter;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.PatternBackground;
import com.fr.base.core.GraphHelper;
import com.fr.chart.ChartCollection;
import com.fr.chart.ChartLayout;
import com.fr.chart.ChartPainter;
import com.fr.data.core.db.BinaryObject;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.FloatElement;
import com.fr.report.Margin;
import com.fr.report.PaperSetting;
import com.fr.report.PaperSize;
import com.fr.report.RWorkSheet;
import com.fr.report.Report;
import com.fr.report.ReportHF;
import com.fr.report.ReportSettings;
import com.fr.report.ResultReport;
import com.fr.report.ResultWorkBook;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PackedReport;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.headerfooter.HFElement;
import com.fr.report.core.headerfooter.TextHFElement;
import com.fr.report.io.AbstractAppExporter;
import com.fr.report.io.ExcelExportAttr;
import com.fr.report.io.ReportExportAttr;
import com.fr.report.io.core.ExcelExporterReport;
import com.fr.report.painter.shape.LineShapePainter;
import com.fr.report.painter.shape.OvalShapePainter;
import com.fr.report.painter.shape.ShapePainter;
import com.fr.third.org.apache.poi.hssf.usermodel.EscherGraphics;
import com.fr.third.org.apache.poi.hssf.usermodel.EscherGraphics2d;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFooter;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFHeader;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPalette;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.util.Utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Clob;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class ExcelExporter
extends AbstractAppExporter {
    public static final String TYPE_SIMPLE = "simple";
    public static final String TYPE_PAGE = "page";
    public static final String TYPE_PAGETOSHETT = "sheet";
    public static final String TYPE_LARGEDATA_PAGE = "ldpage";
    private HSSFCellStyle defaultHSSFCellStyle = null;
    private Hashtable hssfFontHash = new Hashtable();
    private Hashtable hssfCellStyleHash = new Hashtable();
    private HSSFDataFormat format = null;
    private short colorIndex = (short)8;
    public static int EXCELCOLS = 256;
    public static int EXCELROWS = 65536;
    protected List paperSettingList = null;
    static /* synthetic */ Class class$com$fr$report$core$headerfooter$TextHFElement;
    static /* synthetic */ Class class$com$fr$report$core$headerfooter$DateHFElement;
    static /* synthetic */ Class class$com$fr$report$core$headerfooter$TimeHFElement;
    static /* synthetic */ Class class$com$fr$report$core$headerfooter$PageNumberHFElement;
    static /* synthetic */ Class class$com$fr$report$core$headerfooter$NumberOfPageHFElement;
    static /* synthetic */ Class class$com$fr$report$core$headerfooter$NewLineHFElement;

    public ExcelExporter() {
        this(null);
    }

    public ExcelExporter(List list) {
        this.paperSettingList = list;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        ReportExportAttr reportExportAttr;
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        ArrayList arrayList = new ArrayList();
        this.defaultHSSFCellStyle = null;
        this.hssfFontHash.clear();
        this.hssfCellStyleHash.clear();
        this.format = null;
        this.colorIndex = (short)8;
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        this.exportBook(resultWorkBook, hSSFWorkbook, arrayList2, arrayList3, arrayList, bl);
        if (arrayList2.size() > 0) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                reportExportAttr = (HSSFCell)arrayList2.get(i);
                String string = (String)arrayList3.get(i);
                try {
                    reportExportAttr.setCellType(2);
                    reportExportAttr.setCellFormula(string);
                    if (string.equalsIgnoreCase(reportExportAttr.getCellFormula()) || string.matches(".+![\\w&&[\\D]]+\\d+.*")) continue;
                    reportExportAttr.setCellType(1);
                    reportExportAttr.setCellValue(new HSSFRichTextString("=" + string));
                    continue;
                }
                catch (Exception exception) {
                    reportExportAttr.setCellType(1);
                    reportExportAttr.setCellValue(new HSSFRichTextString("=" + string));
                }
            }
        }
        String string = null;
        reportExportAttr = resultWorkBook.getReportExportAttr();
        if (reportExportAttr != null && reportExportAttr.getExcelExportAttr() != null) {
            string = reportExportAttr.getExcelExportAttr().getPassword();
        }
        if (StringUtils.isNotBlank(string)) {
            hSSFWorkbook.setFilePassword(string);
        }
        hSSFWorkbook.write(outputStream);
        outputStream.flush();
    }

    protected void exportBook(ResultWorkBook resultWorkBook, HSSFWorkbook hSSFWorkbook, List list, List list2, List list3, boolean bl) throws Exception {
        Report report;
        int n;
        for (n = 0; n < resultWorkBook.getReportCount(); ++n) {
            report = resultWorkBook.getReport(n);
            list3.add(report);
            while (report instanceof PackedReport) {
                report = ((PackedReport)report).getPackee();
                list3.set(n, report);
            }
        }
        for (n = 0; n < resultWorkBook.getReportCount(); ++n) {
            Cloneable cloneable;
            report = (ResultReport)list3.get(n);
            if (!report.cellIterator().hasNext()) {
                cloneable = new RWorkSheet();
                Iterator iterator = report.floatIterator();
                while (iterator.hasNext()) {
                    cloneable.addFloatElement((FloatElement)iterator.next());
                }
                report = cloneable;
                report.addCellElement(new DefaultCellElement(0, 0, ""));
            }
            cloneable = new Point(0, 0);
            int n2 = report.getColumnCount();
            int n3 = report.getRowCount();
            int n4 = 1;
            while (((Point)cloneable).x < n2) {
                ((Point)cloneable).y = 0;
                while (((Point)cloneable).y < n3) {
                    this.innerExportReport(new ExcelExporterReport((ResultReport)report, ((Point)cloneable).x, ((Point)cloneable).y, Math.min(n2 - ((Point)cloneable).x, EXCELCOLS), Math.min(n3 - ((Point)cloneable).y, EXCELROWS)), resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(n) + (n4 == 1 ? "" : "_" + n4), hSSFWorkbook, list, list2, n);
                    ((Point)cloneable).y += EXCELROWS;
                    ++n4;
                }
                ((Point)cloneable).x += EXCELCOLS;
            }
        }
    }

    protected void innerExportReport(Report report, ReportExportAttr reportExportAttr, String string, HSSFWorkbook hSSFWorkbook, List list, List list2, int n) throws Exception {
        ExcelExportAttr excelExportAttr = reportExportAttr == null ? null : reportExportAttr.getExcelExportAttr();
        HSSFSheet hSSFSheet = hSSFWorkbook.createSheet();
        if (excelExportAttr != null && StringUtils.isNotEmpty(excelExportAttr.getProtectedWord())) {
            hSSFSheet.protectSheet(excelExportAttr.getProtectedWord());
        }
        this.setSheetName(hSSFWorkbook, string);
        this.iterateReport(report, hSSFSheet, hSSFWorkbook, list, list2, excelExportAttr, n);
    }

    private void setSheetName(HSSFWorkbook hSSFWorkbook, String string) {
        int n = 1;
        while (hSSFWorkbook.getSheet(string) != null) {
            string = string + "_" + n;
            ++n;
        }
        hSSFWorkbook.setSheetName(hSSFWorkbook.getNumberOfSheets() - 1, string);
    }

    private void iterateReport(Report report, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, List list, List list2, ExcelExportAttr excelExportAttr, int n) throws Exception {
        Object object;
        HSSFCell hSSFCell;
        int n2;
        int n3;
        int n4;
        Object object2;
        Serializable serializable;
        ReportSettings reportSettings = ReportUtils.getReportSettings(report);
        hSSFSheet.setDefaultColumnWidth((short)9);
        hSSFSheet.setHorizontallyCenter(reportSettings.isHorizontalCenterOnPage());
        hSSFSheet.setVerticallyCenter(reportSettings.isVerticalCenterOnPage());
        HSSFPrintSetup hSSFPrintSetup = hSSFSheet.getPrintSetup();
        PaperSize paperSize = null;
        Margin margin = null;
        int n5 = -1;
        if (this.paperSettingList != null && this.paperSettingList.size() > n && (serializable = (PaperSetting)this.paperSettingList.get(n)) != null) {
            paperSize = ((PaperSetting)serializable).getPaperSize();
            margin = ((PaperSetting)serializable).getMargin();
            n5 = ((PaperSetting)serializable).getOrientation();
        }
        if (paperSize == null) {
            paperSize = reportSettings.getPaperSize();
        }
        if (margin == null) {
            margin = reportSettings.getMargin();
        }
        if (n5 == -1) {
            n5 = reportSettings.getOrientation();
        }
        if (paperSize.equals(PaperSize.PAPERSIZE_LETTER)) {
            hSSFPrintSetup.setPaperSize((short)5);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_HALFLETTER)) {
            hSSFPrintSetup.setPaperSize((short)2);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_TABLOID)) {
            hSSFPrintSetup.setPaperSize((short)3);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_LEDGER)) {
            hSSFPrintSetup.setPaperSize((short)4);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_LEGAL)) {
            hSSFPrintSetup.setPaperSize((short)5);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_A3)) {
            hSSFPrintSetup.setPaperSize((short)8);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_A4)) {
            hSSFPrintSetup.setPaperSize((short)9);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_A5)) {
            hSSFPrintSetup.setPaperSize((short)11);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_A6)) {
            hSSFPrintSetup.setPaperSize((short)70);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_B4)) {
            hSSFPrintSetup.setPaperSize((short)12);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_B5_JIS)) {
            hSSFPrintSetup.setPaperSize((short)13);
        } else if (paperSize.equals(PaperSize.PAPERSIZE_NOTE)) {
            hSSFPrintSetup.setPaperSize((short)18);
        } else {
            hSSFPrintSetup.setPaperSize((short)9);
        }
        if (n5 == 1) {
            hSSFPrintSetup.setLandscape(true);
        } else {
            hSSFPrintSetup.setLandscape(false);
        }
        if (reportSettings.getPageOrder() == 1) {
            hSSFPrintSetup.setLeftToRight(true);
        } else {
            hSSFPrintSetup.setLeftToRight(false);
        }
        hSSFSheet.setMargin((short)2, margin.getTop());
        hSSFSheet.setMargin((short)0, margin.getLeft());
        hSSFSheet.setMargin((short)3, margin.getBottom());
        hSSFSheet.setMargin((short)1, margin.getRight());
        hSSFPrintSetup.setHeaderMargin(reportSettings.getHeaderHeight());
        hSSFPrintSetup.setFooterMargin(reportSettings.getFooterHeight());
        if (reportSettings.getHeaderHeight() > 0.0) {
            this.applyReportHFHeader(report.getHeader(0), hSSFSheet.getHeader());
        }
        if (reportSettings.getFooterHeight() > 0.0) {
            this.applyReportHFFooter(report.getFooter(0), hSSFSheet.getFooter());
        }
        if (report.getReportPageAttr() != null && report.getReportPageAttr().getFreezeColumnRow() != null) {
            serializable = report.getReportPageAttr().getFreezeColumnRow();
            hSSFSheet.createFreezePane(((ColumnRow)serializable).getColumn(), ((ColumnRow)serializable).getRow());
        }
        serializable = ReportHelper.getRowHeightList(report);
        DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(report);
        int n6 = -1;
        int n7 = -1;
        HSSFRow hSSFRow = null;
        HSSFPatriarch hSSFPatriarch = hSSFSheet.createDrawingPatriarch();
        boolean bl = excelExportAttr == null ? true : excelExportAttr.isExportHidedRow();
        boolean bl2 = excelExportAttr == null ? true : excelExportAttr.isExportHidedColumn();
        Iterator iterator = report.cellIterator();
        while (iterator.hasNext()) {
            int n8;
            CellPageAttr cellPageAttr;
            CellGUIAttr cellGUIAttr;
            int n9;
            object2 = (CellElement)iterator.next();
            int n10 = object2.getColumn();
            int n11 = object2.getRow();
            int n12 = object2.getColumnSpan();
            n4 = object2.getRowSpan();
            n3 = n10 + n12 - 1;
            n2 = n11 + n4 - 1;
            if (n6 < n3) {
                for (n9 = Math.max(0, n6); n9 <= n3; ++n9) {
                    if (dynamicValueList.get(n9) <= 0) {
                        hSSFSheet.setColumnHidden((short)n9, true);
                        continue;
                    }
                    hSSFSheet.setColumnWidth((short)n9, (short)((double)dynamicValueList.get(n9) * 34.742));
                }
                n6 = n3;
            }
            if (n7 < n2) {
                for (n9 = Math.max(0, n7); n9 <= n2; ++n9) {
                    cellGUIAttr = hSSFSheet.createRow(n9);
                    if (((DynamicValueList)serializable).get(n9) <= 0) {
                        cellGUIAttr.setZeroHeight(true);
                        continue;
                    }
                    cellGUIAttr.setHeight((short)((double)((DynamicValueList)serializable).get(n9) * 15.207675329298683));
                }
                n7 = n2;
            }
            if ((cellPageAttr = object2.getCellPageAttr()) != null) {
                if (cellPageAttr.isPageBeforeColumn()) {
                    hSSFSheet.setColumnBreak((short)(n10 - 1));
                }
                if (cellPageAttr.isPageAfterColumn() && n3 < EXCELCOLS - 1) {
                    hSSFSheet.setColumnBreak((short)n3);
                }
                if (cellPageAttr.isPageBeforeRow()) {
                    hSSFSheet.setRowBreak(n11 - 1);
                }
                if (cellPageAttr.isPageAfterRow() && n2 < EXCELROWS - 1) {
                    hSSFSheet.setRowBreak(n2);
                }
            }
            if ((cellGUIAttr = object2.getCellGUIAttr()) == null) {
                cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
            }
            if (!cellGUIAttr.isPrintContent()) continue;
            Style style = object2.getStyle();
            int n13 = n10 + n12;
            for (int i = n8 = n10; i < n13; ++i) {
                int n14;
                int n15 = n11 + n4;
                for (int j = n14 = n11; j < n15; ++j) {
                    String string;
                    Object object3;
                    Object object4;
                    if (hSSFRow == null || hSSFRow.getRowNum() != j) {
                        hSSFRow = hSSFSheet.getRow(j);
                    }
                    hSSFCell = hSSFRow.createCell((short)i);
                    hSSFCell.setEncoding((short)1);
                    if (i != n8 || j != n14) {
                        hSSFCell.setCellStyle(this.createHSSFCellStyle(hSSFWorkbook, style));
                        continue;
                    }
                    if (!bl && report.getRowHeight(j) == 0 || !bl2 && report.getColumnWidth(i) == 0) continue;
                    object = object2.getValue();
                    if (object == null) {
                        object = "";
                    }
                    if (object instanceof Formula) {
                        object4 = (Formula)object;
                        if (((Formula)object4).isReserveInResult() || ((Formula)object4).getResult() == null) {
                            object3 = ((Formula)object).getContent();
                            if (object3 != null) {
                                if (((String)object3).startsWith("=")) {
                                    string = ((String)object3).substring(1);
                                    list.add(hSSFCell);
                                    list2.add(string);
                                } else {
                                    list.add(hSSFCell);
                                    list2.add(object3);
                                }
                            }
                        } else {
                            object = ((Formula)object4).getResult();
                        }
                    } else if (object instanceof byte[]) {
                        object4 = object2.getAttribute(CellElementAttribute.ATT_TYPE);
                        if (object4 != null && "image".equals((String)object4)) {
                            object = ImageIO.read(new ByteArrayInputStream((byte[])object));
                        }
                    } else if (object instanceof Clob) {
                        object = Utils.clob2String((Clob)object);
                    } else if (object instanceof BinaryObject) {
                        object4 = (BinaryObject)object;
                        if (cellGUIAttr.isShowAsImage()) {
                            object = ((BinaryObject)object4).getImage();
                        } else {
                            object3 = null;
                            if (((BinaryObject)object4).getBytes().length < 5000000 || (object3 = ((BinaryObject)object4).getImage()) != null) {
                                object = object3 == null ? ((BinaryObject)object4).getValue() : object3;
                            }
                        }
                    }
                    object4 = object2.getStyle();
                    object3 = ((Style)object4).getFormat();
                    if (!(object instanceof Formula)) {
                        if (object instanceof Number) {
                            hSSFCell.setCellType(0);
                            hSSFCell.setCellValue(((Number)object).doubleValue());
                        } else if (object instanceof Boolean) {
                            hSSFCell.setCellType(4);
                            hSSFCell.setCellValue(((Boolean)object).booleanValue());
                        } else if (object instanceof String || object instanceof Date) {
                            string = PaintUtils.valueToText(object, style.getFormat());
                            if (string.indexOf("$$totalPage_number") > -1 || string.indexOf("$$page_number") > -1) {
                                string = "";
                            }
                            if ((string = this.replaceNewLineChar(string)) != null) {
                                if (string.startsWith("=")) {
                                    String string2 = string.substring(1);
                                    list.add(hSSFCell);
                                    list2.add(string2);
                                } else if (string.length() > 0) {
                                    if (object3 instanceof NumberFormat) {
                                        try {
                                            hSSFCell.setCellValue(Double.parseDouble(string));
                                            hSSFCell.setCellType(0);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            hSSFCell.setCellType(1);
                                            hSSFCell.setCellValue(string);
                                        }
                                    } else {
                                        hSSFCell.setCellType(1);
                                        hSSFCell.setCellValue(string);
                                    }
                                }
                            }
                        } else if (object instanceof Painter || object instanceof Image) {
                            if (object instanceof ChartCollection) {
                                // empty if block
                            }
                            string = new HSSFClientAnchor(0, 0, 0, 0, (short)n10, n11, (short)(n10 + n12), n11 + n4);
                            if (object != null) {
                                string.setAnchorType(2);
                                int n16 = dynamicValueList.getRangeValue(n10, n10 + n12);
                                int n17 = ((DynamicValueList)serializable).getRangeValue(n11, n11 + n4);
                                BufferedImage bufferedImage = GraphHelper.createBufferedImage(n16 + 1, n17 + 1, 2);
                                Graphics2D graphics2D = bufferedImage.createGraphics();
                                PaintUtils.paintContent(graphics2D, object, style, n16, n17);
                                bufferedImage.flush();
                                graphics2D.dispose();
                                hSSFPatriarch.createPicture((HSSFClientAnchor)string, this.loadPicture(bufferedImage, hSSFWorkbook));
                            }
                        } else if (object != null && (string = object.toString()) != null) {
                            if (string.startsWith("=")) {
                                String string3 = string.substring(1);
                                list.add(hSSFCell);
                                list2.add(string3);
                            } else if (string.length() > 0) {
                                string = this.replaceNewLineChar(string);
                                if (object3 instanceof NumberFormat) {
                                    try {
                                        hSSFCell.setCellValue(Double.parseDouble(string));
                                        hSSFCell.setCellType(0);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        hSSFCell.setCellType(1);
                                        hSSFCell.setCellValue(string);
                                    }
                                } else {
                                    hSSFCell.setCellType(1);
                                    hSSFCell.setCellValue(string);
                                }
                            }
                        }
                    }
                    hSSFCell.setCellStyle(this.createHSSFCellStyle(hSSFWorkbook, object2.getStyle()));
                }
            }
            if (n4 <= 1 && n12 <= 1) continue;
            Region region = new Region(n11, (short)n10, n11 + n4 - 1, (short)(n10 + n12 - 1));
            hSSFSheet.addMergedRegion(region);
        }
        object2 = report.floatIterator();
        while (object2.hasNext()) {
            Background background;
            Object object5;
            Cloneable cloneable;
            Object object6;
            int n18;
            FloatElement floatElement = (FloatElement)object2.next();
            Point[] pointArray = ReportHelper.calculateLastColumnAndRowOfFloatElement(report, floatElement);
            Object object7 = floatElement.getValue();
            n4 = 0;
            n3 = 0;
            n4 = floatElement.getLeftDistance();
            n3 = floatElement.getTopDistance();
            n2 = 0;
            int n19 = 0;
            for (n18 = floatElement.getColumn(); n4 < 0 && n18 >= 0; --n18) {
                n4 += dynamicValueList.get(n18);
                --n2;
            }
            for (n18 = floatElement.getColumn(); n4 > dynamicValueList.get(n18) && n18 <= n6; ++n18) {
                n4 -= dynamicValueList.get(n18);
                ++n2;
            }
            for (n18 = floatElement.getRow(); n3 < 0 && n18 >= 0; --n18) {
                n3 += ((DynamicValueList)serializable).get(n18);
                --n19;
            }
            for (n18 = floatElement.getRow(); n3 > ((DynamicValueList)serializable).get(n18) && n18 <= n7; ++n18) {
                n3 -= ((DynamicValueList)serializable).get(n18);
                ++n19;
            }
            n4 = (int)(new Double(n4) / (double)((DynamicValueList)serializable).get(floatElement.getRow() + n19) * 1023.0);
            n3 = (int)(new Double(n3) / (double)dynamicValueList.get(floatElement.getColumn() + n2) * 255.0);
            n18 = (int)(new Double(pointArray[1].x) / (double)((DynamicValueList)serializable).get((short)pointArray[0].x) * 1023.0);
            int n20 = (int)(new Double(pointArray[1].y) / (double)dynamicValueList.get(pointArray[0].y) * 255.0);
            HSSFClientAnchor hSSFClientAnchor = new HSSFClientAnchor(n4 < 1023 ? n4 : 1023, n3 < 255 ? n3 : 255, n18 < 1023 ? n18 : 1023, n20 < 255 ? n20 : 255, (short)(floatElement.getColumn() + n2), floatElement.getRow() + n19, (short)pointArray[0].x, pointArray[0].y);
            if (object7 instanceof ShapePainter) {
                object6 = (ShapePainter)object7;
                cloneable = floatElement.getStyle();
                if (cloneable == null) {
                    cloneable = Style.DEFAULT_STYLE;
                }
                object5 = hSSFPatriarch.createGroup(hSSFClientAnchor);
                float f = hSSFClientAnchor.getAnchorHeightInPoints(hSSFSheet) / (float)Math.abs(object5.getY2() - object5.getY1());
                background = new EscherGraphics(object5, hSSFWorkbook, Color.black, f);
                hSSFCell = new EscherGraphics2d((EscherGraphics)background);
                hSSFCell.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (object6 instanceof LineShapePainter) {
                    object = (LineShapePainter)object6;
                    hSSFCell.setPaint((Paint)((Style)cloneable).getFRFont().getForeground());
                    if (((LineShapePainter)object).isPositiveArrow()) {
                        hSSFCell.drawLine(object5.getX1(), object5.getY2(), object5.getX2(), object5.getY1());
                    } else {
                        hSSFCell.drawLine(object5.getX1(), object5.getY1(), object5.getX2(), object5.getY2());
                    }
                } else if (object6 instanceof OvalShapePainter) {
                    this.applyBackgroundToGraphic2d((EscherGraphics2d)hSSFCell, ((Style)cloneable).getBackground());
                    hSSFCell.fillOval(object5.getX1(), object5.getY1(), object5.getX2() - object5.getX1(), object5.getY2() - object5.getY1());
                    hSSFCell.setPaint((Paint)((Style)cloneable).getFRFont().getForeground());
                    hSSFCell.drawOval(object5.getX1(), object5.getY1(), object5.getX2() - object5.getX1(), object5.getY2() - object5.getY1());
                } else {
                    this.applyBackgroundToGraphic2d((EscherGraphics2d)hSSFCell, ((Style)cloneable).getBackground());
                    hSSFCell.fillRect(object5.getX1(), object5.getY1(), object5.getX2() - object5.getX1(), object5.getY2() - object5.getY1());
                    hSSFCell.setPaint((Paint)((Style)cloneable).getFRFont().getForeground());
                    hSSFCell.drawRect(object5.getX1(), object5.getY1(), object5.getX2() - object5.getX1(), object5.getY2() - object5.getY1());
                }
                hSSFCell.dispose();
                continue;
            }
            if (object7 instanceof String || object7 instanceof Number) {
                object6 = object7.toString();
                cloneable = floatElement.getStyle();
                if (cloneable == null) {
                    cloneable = Style.DEFAULT_STYLE;
                }
                object5 = hSSFPatriarch.createTextbox(hSSFClientAnchor);
                Color color = Color.white;
                background = ((Style)cloneable).getBackground();
                if (background != null && background instanceof ColorBackground) {
                    color = ((ColorBackground)background).getColor();
                }
                object5.setFillColor(color.getRed(), color.getGreen(), color.getBlue());
                hSSFCell = new HSSFRichTextString((String)object6);
                hSSFCell.applyFont(this.createHSFFFont(hSSFWorkbook, ((Style)cloneable).getFRFont()));
                object5.setString((HSSFRichTextString)hSSFCell);
                continue;
            }
            if (object7 instanceof Image) {
                object6 = (Image)object7;
                if (object6 == null) continue;
                hSSFClientAnchor.setAnchorType(2);
                hSSFPatriarch.createPicture(hSSFClientAnchor, this.loadPicture(GraphHelper.createBufferedImageFromImage((Image)object6), hSSFWorkbook));
                continue;
            }
            if (!(object7 instanceof ChartPainter) || (object6 = (ChartPainter)object7) == null) continue;
            hSSFClientAnchor.setAnchorType(2);
            cloneable = floatElement.getSize();
            object5 = (BufferedImage)((ChartPainter)object6).paint4Float(floatElement, ((ChartPainter)object6).getGlyph(((ChartLayout)object6).getSelectedIndex()), (int)((Dimension2D)cloneable).getWidth(), (int)((Dimension2D)cloneable).getHeight());
            hSSFPatriarch.createPicture(hSSFClientAnchor, this.loadPicture((BufferedImage)object5, hSSFWorkbook));
        }
    }

    public short getNearestColor(HSSFWorkbook hSSFWorkbook, Color color) {
        HSSFPalette hSSFPalette;
        HSSFColor hSSFColor;
        if (color == null) {
            color = Color.WHITE;
        }
        if ((hSSFColor = (hSSFPalette = hSSFWorkbook.getCustomPalette()).findColor((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue())) == null || hSSFColor.getIndex() > this.colorIndex) {
            this.colorIndex = (short)(this.colorIndex + 1);
            hSSFPalette.setColorAtIndex(this.colorIndex, (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            hSSFColor = hSSFPalette.findColor((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        return hSSFColor.getIndex();
    }

    private void applyReportHFHeader(ReportHF reportHF, HSSFHeader hSSFHeader) {
        hSSFHeader.setLeft(this.createHFString(reportHF.getLeftList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
        hSSFHeader.setCenter(this.createHFString(reportHF.getCenterList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
        hSSFHeader.setRight(this.createHFString(reportHF.getRightList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
    }

    private void applyReportHFFooter(ReportHF reportHF, HSSFFooter hSSFFooter) {
        hSSFFooter.setLeft(this.createHFString(reportHF.getLeftList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
        hSSFFooter.setCenter(this.createHFString(reportHF.getCenterList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
        hSSFFooter.setRight(this.createHFString(reportHF.getRightList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
    }

    private String createHFString(List list, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HFElement hFElement = (HFElement)list.get(i);
            if (!(hFElement instanceof TextHFElement)) continue;
            FRFont fRFont = ((TextHFElement)hFElement).getFRFont();
            String string5 = "";
            if (fRFont.getStyle() == 0) {
                string5 = "Plain";
            } else if (fRFont.getStyle() == 1) {
                string5 = "Bold";
            } else if (fRFont.getStyle() == 2) {
                string5 = "Italic";
            } else if (fRFont.getStyle() == 3) {
                string5 = "Bold Italic";
            }
            stringBuffer.append(HSSFHeader.font((String)fRFont.getName(), (String)string5));
            stringBuffer.append(HSSFHeader.fontSize((short)((short)fRFont.getSize())));
            stringBuffer.append(" ");
            if (hFElement.getClass().equals(class$com$fr$report$core$headerfooter$TextHFElement == null ? ExcelExporter.class$("com.fr.report.core.headerfooter.TextHFElement") : class$com$fr$report$core$headerfooter$TextHFElement)) {
                stringBuffer.append(((TextHFElement)hFElement).getText());
                continue;
            }
            if (hFElement.getClass().equals(class$com$fr$report$core$headerfooter$DateHFElement == null ? ExcelExporter.class$("com.fr.report.core.headerfooter.DateHFElement") : class$com$fr$report$core$headerfooter$DateHFElement)) {
                stringBuffer.append(string);
                continue;
            }
            if (hFElement.getClass().equals(class$com$fr$report$core$headerfooter$TimeHFElement == null ? ExcelExporter.class$("com.fr.report.core.headerfooter.TimeHFElement") : class$com$fr$report$core$headerfooter$TimeHFElement)) {
                stringBuffer.append(string2);
                continue;
            }
            if (hFElement.getClass().equals(class$com$fr$report$core$headerfooter$PageNumberHFElement == null ? ExcelExporter.class$("com.fr.report.core.headerfooter.PageNumberHFElement") : class$com$fr$report$core$headerfooter$PageNumberHFElement)) {
                stringBuffer.append(string3);
                continue;
            }
            if (hFElement.getClass().equals(class$com$fr$report$core$headerfooter$NumberOfPageHFElement == null ? ExcelExporter.class$("com.fr.report.core.headerfooter.NumberOfPageHFElement") : class$com$fr$report$core$headerfooter$NumberOfPageHFElement)) {
                stringBuffer.append(string4);
                continue;
            }
            if (!hFElement.getClass().equals(class$com$fr$report$core$headerfooter$NewLineHFElement == null ? ExcelExporter.class$("com.fr.report.core.headerfooter.NewLineHFElement") : class$com$fr$report$core$headerfooter$NewLineHFElement)) continue;
        }
        return stringBuffer.toString();
    }

    private HSSFCellStyle createHSSFCellStyle(HSSFWorkbook hSSFWorkbook, Style style) {
        if (style == null) {
            if (this.defaultHSSFCellStyle == null) {
                this.defaultHSSFCellStyle = hSSFWorkbook.createCellStyle();
                this.executeHSSFCellStyle(hSSFWorkbook, this.defaultHSSFCellStyle, Style.DEFAULT_STYLE);
            }
            return this.defaultHSSFCellStyle;
        }
        HSSFCellStyle hSSFCellStyle = null;
        Enumeration enumeration = this.hssfCellStyleHash.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!style.equals(k)) continue;
            hSSFCellStyle = (HSSFCellStyle)this.hssfCellStyleHash.get(k);
            break;
        }
        if (hSSFCellStyle == null) {
            hSSFCellStyle = hSSFWorkbook.createCellStyle();
            this.executeHSSFCellStyle(hSSFWorkbook, hSSFCellStyle, style);
            this.hssfCellStyleHash.put(style, hSSFCellStyle);
        }
        return hSSFCellStyle;
    }

    private void executeHSSFCellStyle(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, Style style) {
        Object object;
        Format format = style.getFormat();
        if (format != null) {
            if (format instanceof DecimalFormat) {
                object = ((DecimalFormat)format).toPattern();
                hSSFCellStyle.setDataFormat(this.getHSSFDataFormat(hSSFWorkbook).getFormat((String)object));
            } else if (format instanceof SimpleDateFormat) {
                hSSFCellStyle.setDataFormat(this.getHSSFDataFormat(hSSFWorkbook).getFormat(((SimpleDateFormat)format).toPattern()));
            }
        }
        if ((object = this.createHSFFFont(hSSFWorkbook, style.getFRFont())) != null) {
            hSSFCellStyle.setFont(object);
        }
        hSSFCellStyle.setBorderTop(this.getMapHSSFBorder(style.getBorderTop()));
        hSSFCellStyle.setTopBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderTopColor()));
        hSSFCellStyle.setBorderLeft(this.getMapHSSFBorder(style.getBorderLeft()));
        hSSFCellStyle.setLeftBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderLeftColor()));
        hSSFCellStyle.setBorderBottom(this.getMapHSSFBorder(style.getBorderBottom()));
        hSSFCellStyle.setBottomBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderBottomColor()));
        hSSFCellStyle.setBorderRight(this.getMapHSSFBorder(style.getBorderRight()));
        hSSFCellStyle.setRightBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderRightColor()));
        hSSFCellStyle.setWrapText(style.getTextStyle() == 0);
        hSSFCellStyle.setRotation((short)style.getRotation());
        if (style.getHorizontalAlignment() == 2) {
            hSSFCellStyle.setAlignment((short)1);
        } else if (style.getHorizontalAlignment() == 0) {
            hSSFCellStyle.setAlignment((short)2);
        } else if (style.getHorizontalAlignment() == 4) {
            hSSFCellStyle.setAlignment((short)3);
        } else if (style.getHorizontalAlignment() == 6) {
            // empty if block
        }
        if (style.getVerticalAlignment() == 1) {
            hSSFCellStyle.setVerticalAlignment((short)0);
        } else if (style.getVerticalAlignment() == 0) {
            hSSFCellStyle.setVerticalAlignment((short)1);
        } else if (style.getVerticalAlignment() == 3) {
            hSSFCellStyle.setVerticalAlignment((short)2);
        } else if (style.getVerticalAlignment() == 6) {
            // empty if block
        }
        Background background = style.getBackground();
        if (background != null) {
            if (background instanceof ColorBackground) {
                ColorBackground colorBackground = (ColorBackground)background;
                hSSFCellStyle.setFillPattern((short)1);
                hSSFCellStyle.setFillForegroundColor(this.getNearestColor(hSSFWorkbook, colorBackground.getColor()));
                hSSFCellStyle.setFillBackgroundColor(this.getNearestColor(hSSFWorkbook, colorBackground.getColor()));
            } else if (background instanceof PatternBackground) {
                PatternBackground patternBackground = (PatternBackground)background;
                hSSFCellStyle.setFillPattern((short)16);
                hSSFCellStyle.setFillBackgroundColor(this.getNearestColor(hSSFWorkbook, patternBackground.getBackground()));
                hSSFCellStyle.setFillForegroundColor(this.getNearestColor(hSSFWorkbook, patternBackground.getForeground()));
            }
        }
    }

    private HSSFFont createHSFFFont(HSSFWorkbook hSSFWorkbook, Font font) {
        Object object;
        if (font == null) {
            return null;
        }
        HSSFFont hSSFFont = null;
        Enumeration enumeration = this.hssfFontHash.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!font.equals(object)) continue;
            hSSFFont = (HSSFFont)this.hssfFontHash.get(object);
            break;
        }
        if (hSSFFont == null) {
            hSSFFont = hSSFWorkbook.createFont();
            this.hssfFontHash.put(font, hSSFFont);
        }
        hSSFFont.setFontHeight((short)(font.getSize() * 20 * 3 / 4));
        hSSFFont.setFontName(font.getName());
        if (font.isBold()) {
            hSSFFont.setBoldweight((short)700);
        } else {
            hSSFFont.setBoldweight((short)400);
        }
        if (font.isItalic()) {
            hSSFFont.setItalic(true);
        } else {
            hSSFFont.setItalic(false);
        }
        if (font instanceof FRFont) {
            int n;
            object = (FRFont)font;
            Color color = ((FRFont)object).getForeground();
            hSSFFont.setColor(this.getNearestColor(hSSFWorkbook, color));
            if (((FRFont)object).isStrikethrough()) {
                hSSFFont.setStrikeout(true);
            }
            if ((n = GraphHelper.getLineStyleSize(((FRFont)object).getUnderline())) == 0) {
                hSSFFont.setUnderline((byte)0);
            } else if (n == 1) {
                hSSFFont.setUnderline((byte)1);
            } else if (n == 2) {
                hSSFFont.setUnderline((byte)2);
            }
        }
        return hSSFFont;
    }

    private HSSFDataFormat getHSSFDataFormat(HSSFWorkbook hSSFWorkbook) {
        if (this.format == null) {
            this.format = hSSFWorkbook.createDataFormat();
        }
        return this.format;
    }

    private short getMapHSSFBorder(int n) {
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 3) {
            return 3;
        }
        if (n == 4) {
            return 4;
        }
        if (n == 5) {
            return 5;
        }
        if (n == 6) {
            return 6;
        }
        if (n == 7) {
            return 7;
        }
        if (n == 8) {
            return 8;
        }
        if (n == 9) {
            return 9;
        }
        if (n == 10) {
            return 10;
        }
        if (n == 11) {
            return 11;
        }
        if (n == 12) {
            return 12;
        }
        if (n == 13) {
            return 13;
        }
        return 0;
    }

    private void applyBackgroundToGraphic2d(EscherGraphics2d escherGraphics2d, Background background) {
        if (background == null) {
            escherGraphics2d.setPaint(null);
        } else if (background instanceof ColorBackground) {
            ColorBackground colorBackground = (ColorBackground)background;
            escherGraphics2d.setPaint((Paint)colorBackground.getColor());
        } else {
            escherGraphics2d.setPaint((Paint)Color.white);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int loadPicture(BufferedImage bufferedImage, HSSFWorkbook hSSFWorkbook) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            BaseUtils.writeImage(bufferedImage, "png", byteArrayOutputStream);
            n = hSSFWorkbook.addPicture(byteArrayOutputStream.toByteArray(), 6);
            Object var6_5 = null;
            if (byteArrayOutputStream == null) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (byteArrayOutputStream == null) throw throwable;
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            throw throwable;
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return n;
    }

    private String replaceNewLineChar(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.replaceAll("\\\\n", "\n");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

