/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.FineBook;
import com.fr.report.Margin;
import com.fr.report.RWorkBook;
import com.fr.report.RWorkSheet;
import com.fr.report.Report;
import com.fr.report.ReportSettings;
import com.fr.report.ResultReport;
import com.fr.report.ResultWorkBook;
import com.fr.report.TableDataSource;
import com.fr.report.TemplateWorkBook;
import com.fr.report.WorkBook;
import com.fr.report.WorkSheet;
import com.fr.report.cellElement.TextFormat;
import com.fr.report.core.FormReport;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.AbstractImporter;
import com.fr.report.io.core.ExcelUtils;
import com.fr.report.web.ui.Widget;
import com.fr.report.write.ValueVerifier;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.web.core.WebUtils;
import java.awt.Color;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ExcelImporter
extends AbstractImporter {
    public RWorkBook generateResult(InputStream inputStream) throws Exception {
        return (RWorkBook)this.generate(inputStream, new ResultBookFactory());
    }

    public WorkBook generateTemplate(InputStream inputStream) throws Exception {
        return (WorkBook)this.generate(inputStream, new TemplateBookFactory());
    }

    private FineBook generate(InputStream inputStream, BookFactory bookFactory) throws Exception {
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(inputStream);
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
        FineBook fineBook = bookFactory.getBookInstance();
        int n = hSSFWorkbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i);
            Report report = bookFactory.getChildReportInstance(hSSFWorkbook.getSheetName(i));
            ReportSettings reportSettings = report.getReportSettings();
            HSSFPrintSetup hSSFPrintSetup = hSSFSheet.getPrintSetup();
            reportSettings.setHeaderHeight(hSSFPrintSetup.getHeaderMargin());
            reportSettings.setFooterHeight(hSSFPrintSetup.getFooterMargin());
            if (hSSFPrintSetup.getLandscape()) {
                reportSettings.setOrientation(1);
            } else {
                reportSettings.setOrientation(0);
            }
            if (hSSFPrintSetup.getLeftToRight()) {
                reportSettings.setPageOrder(1);
            } else {
                reportSettings.setPageOrder(0);
            }
            Margin margin = reportSettings.getMargin();
            margin.setTop(hSSFSheet.getMargin((short)2));
            margin.setLeft(hSSFSheet.getMargin((short)0));
            margin.setBottom(hSSFSheet.getMargin((short)3));
            margin.setRight(hSSFSheet.getMargin((short)1));
            int n2 = hSSFSheet.getLastRowNum();
            for (int j = hSSFSheet.getFirstRowNum(); j <= n2; ++j) {
                HSSFRow hSSFRow = hSSFSheet.getRow(j);
                if (hSSFRow == null) continue;
                report.setRowHeight(j, (int)((double)hSSFRow.getHeight() / 15.207675329298683));
                short s = hSSFRow.getLastCellNum();
                for (int k = Math.max(0, hSSFRow.getFirstCellNum()); k <= s; ++k) {
                    HSSFCell hSSFCell;
                    if (hSSFSheet.getColumnWidth((short)k) != 8) {
                        report.setColumnWidth(k, (int)((double)hSSFSheet.getColumnWidth((short)k) / 34.742));
                    }
                    if ((hSSFCell = hSSFRow.getCell((short)k)) == null || this.isHiddenMergedCell(hSSFSheet, k, j)) continue;
                    int[] nArray = this.getMergetColumnRow(hSSFSheet, k, j);
                    int n3 = 1;
                    int n4 = 1;
                    if (nArray != null) {
                        n3 = nArray[0];
                        n4 = nArray[1];
                    }
                    DefaultCellElement defaultCellElement = new DefaultCellElement(k, j, n3, n4, ExcelUtils.getHSSFCellValue(hSSFCell));
                    report.addCellElement(defaultCellElement, false);
                    defaultCellElement.setStyle(this.createStyle(hSSFWorkbook, hSSFCell));
                }
            }
        }
        inputStream.close();
        return fineBook;
    }

    private boolean isHiddenMergedCell(HSSFSheet hSSFSheet, int n, int n2) {
        for (int i = 0; i < hSSFSheet.getNumMergedRegions(); ++i) {
            Region region = hSSFSheet.getMergedRegionAt(i);
            if (region.getColumnFrom() > n || region.getColumnTo() < n || region.getRowFrom() > n2 || region.getRowTo() < n2) continue;
            return region.getColumnFrom() != n || region.getRowFrom() != n2;
        }
        return false;
    }

    private int[] getMergetColumnRow(HSSFSheet hSSFSheet, int n, int n2) {
        for (int i = 0; i < hSSFSheet.getNumMergedRegions(); ++i) {
            Region region = hSSFSheet.getMergedRegionAt(i);
            if (region.getColumnFrom() > n || region.getColumnTo() < n || region.getRowFrom() > n2 || region.getRowTo() < n2) continue;
            return new int[]{region.getColumnTo() - region.getColumnFrom() + 1, region.getRowTo() - region.getRowFrom() + 1};
        }
        return null;
    }

    private Style createStyle(HSSFWorkbook hSSFWorkbook, HSSFCell hSSFCell) {
        short s;
        Serializable serializable;
        Style style = Style.DEFAULT_STYLE;
        HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
        try {
            short s2 = hSSFCellStyle.getDataFormat();
            String string = hSSFWorkbook.createDataFormat().getFormat(s2);
            if (string != null) {
                Serializable serializable2;
                if (string.equals("@")) {
                    serializable2 = TextFormat.getInstance();
                } else if (string.toUpperCase().equals("GENERAL")) {
                    serializable2 = null;
                } else {
                    int n;
                    if ((string = string.trim()).endsWith("_")) {
                        string = string.substring(0, string.length() - 1);
                    } else {
                        n = string.indexOf("_);");
                        if (n != -1) {
                            string = string.substring(0, n);
                        }
                        if (string.startsWith("_(*")) {
                            string = string.substring(3);
                        }
                    }
                    if (string.indexOf("#,##0_") != -1) {
                        string = "#,##0";
                    }
                    if (string.indexOf("#,##0.00") != -1) {
                        string = "#,##0.00";
                    }
                    n = -1;
                    n = string.indexOf("+");
                    if (n != -1) {
                        string = string.substring(0, n) + string.substring(n + 1);
                    }
                    serializable = new DecimalFormat();
                    ((DecimalFormat)serializable).applyPattern(string);
                    serializable2 = serializable;
                }
                style = style.deriveFormat((Format)serializable2);
            }
        }
        catch (Exception exception) {
            System.err.println("Excel format pattern not supported by java: ");
            exception.printStackTrace();
        }
        HSSFFont hSSFFont = hSSFWorkbook.getFontAt(hSSFCellStyle.getFontIndex());
        int n = 0;
        if (hSSFFont.getBoldweight() == 700) {
            ++n;
        }
        if (hSSFFont.getItalic()) {
            n += 2;
        }
        int n2 = hSSFFont.getFontHeightInPoints() * 4 / 3;
        FRFont fRFont = FRFont.getInstance(hSSFFont.getFontName(), n, n2);
        if (FRContext.getLocale().equals(Locale.CHINA) && !fRFont.canDisplay('\u5b8b')) {
            fRFont = FRFont.getInstance("\u5b8b\u4f53", n, n2);
        }
        if ((serializable = this.createColor(hSSFWorkbook, hSSFFont.getColor())) != null) {
            fRFont = fRFont.applyForeground((Color)serializable);
        }
        if (hSSFFont.getStrikeout()) {
            fRFont = fRFont.applyStrikethrough(true);
        }
        if (hSSFFont.getUnderline() == 0) {
            fRFont = fRFont.applyUnderline(0);
        } else if (hSSFFont.getUnderline() == 1 || hSSFFont.getUnderline() == 33) {
            fRFont = fRFont.applyUnderline(1);
        } else if (hSSFFont.getUnderline() == 2 || hSSFFont.getUnderline() == 34) {
            fRFont = fRFont.applyUnderline(6);
        }
        style = style.deriveFRFont(fRFont);
        Color color = this.createColor(hSSFWorkbook, hSSFCellStyle.getFillForegroundColor());
        if (color != null) {
            style = style.deriveBackground(ColorBackground.getInstance(color));
        }
        style = (s = hSSFCellStyle.getAlignment()) == 2 ? style.deriveHorizontalAlignment(0) : (s == 3 ? style.deriveHorizontalAlignment(4) : style.deriveHorizontalAlignment(2));
        short s3 = hSSFCellStyle.getVerticalAlignment();
        style = s3 == 0 ? style.deriveVerticalAlignment(1) : (s3 == 2 ? style.deriveVerticalAlignment(3) : style.deriveVerticalAlignment(0));
        style = hSSFCellStyle.getWrapText() ? style.deriveTextStyle(0) : style.deriveTextStyle(1);
        style = style.deriveRotation(hSSFCellStyle.getRotation());
        Color color2 = this.createColor(hSSFWorkbook, hSSFCellStyle.getTopBorderColor());
        Color color3 = this.createColor(hSSFWorkbook, hSSFCellStyle.getLeftBorderColor());
        Color color4 = this.createColor(hSSFWorkbook, hSSFCellStyle.getBottomBorderColor());
        Color color5 = this.createColor(hSSFWorkbook, hSSFCellStyle.getRightBorderColor());
        style = style.deriveBorder(this.getBorderStyle(hSSFCellStyle.getBorderTop()), color2 == null ? style.getBorderTopColor() : color2, this.getBorderStyle(hSSFCellStyle.getBorderBottom()), color4 == null ? style.getBorderBottomColor() : color4, this.getBorderStyle(hSSFCellStyle.getBorderLeft()), color3 == null ? style.getBorderLeftColor() : color3, this.getBorderStyle(hSSFCellStyle.getBorderRight()), color5 == null ? style.getBorderRightColor() : color5);
        return style;
    }

    private Color createColor(HSSFWorkbook hSSFWorkbook, short s) {
        HSSFColor hSSFColor = hSSFWorkbook.getCustomPalette().getColor(s);
        if (hSSFColor == null) {
            return null;
        }
        if (hSSFColor instanceof HSSFColor.AUTOMATIC) {
            return null;
        }
        short[] sArray = hSSFColor.getTriplet();
        return new Color(sArray[0], sArray[1], sArray[2]);
    }

    private int getBorderStyle(short s) {
        switch (s) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
        }
        return 0;
    }

    public static boolean importExcel(TemplateWorkBook templateWorkBook, Map map, InputStream inputStream) {
        try {
            int n;
            ResultWorkBook resultWorkBook = templateWorkBook.execute4Write(map);
            for (n = 0; n < templateWorkBook.getReportCount(); ++n) {
                resultWorkBook.setReportName(n, templateWorkBook.getReportName(n));
            }
            ExcelImporter.importExcel2Book(resultWorkBook, templateWorkBook, inputStream, map);
            int n2 = resultWorkBook.getReportCount();
            for (n = 0; n < n2; ++n) {
                Report report = resultWorkBook.getReport(n);
                if (!(report instanceof FormReport)) continue;
                FormReport formReport = (FormReport)((Object)report);
                ValueVerifier[] valueVerifierArray = formReport.checkValueVerifiers();
                for (int i = 0; i < valueVerifierArray.length; ++i) {
                    ValueVerifier valueVerifier = valueVerifierArray[i];
                    int n3 = valueVerifier.getType();
                    if (n3 == 0) continue;
                    return false;
                }
            }
            ReportUtils.submit(resultWorkBook, templateWorkBook, WebUtils.dealWithReportParameters(templateWorkBook, map));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static void importExcel2Book(ResultWorkBook resultWorkBook, TableDataSource tableDataSource, InputStream inputStream, Map map) throws Exception {
        WorkBook workBook = new ExcelImporter().generateTemplate(inputStream);
        if (workBook != null) {
            int n = 0;
            if (workBook != null && resultWorkBook != null) {
                n = Math.min(workBook.getReportCount(), resultWorkBook.getReportCount());
                for (int i = 0; i < n; ++i) {
                    Report report = workBook.getReport(i);
                    ResultReport resultReport = resultWorkBook.getResultReport(i);
                    if (report == null || resultReport == null) continue;
                    Iterator iterator = resultReport.cellIterator();
                    while (iterator.hasNext()) {
                        Object object;
                        CellElement cellElement = (CellElement)iterator.next();
                        Widget widget = cellElement.getWidget();
                        if (widget == null || (object = report.getCellValue(cellElement.getColumn(), cellElement.getRow())) == null) continue;
                        cellElement.setValue(object);
                    }
                    resultReport.recalculate(map);
                }
            }
        }
    }

    private static class ResultBookFactory
    implements BookFactory {
        private ResultWorkBook book = new RWorkBook();

        private ResultBookFactory() {
        }

        public FineBook getBookInstance() {
            return this.book;
        }

        public Report getChildReportInstance(String string) {
            RWorkSheet rWorkSheet = new RWorkSheet();
            this.book.addReport(string, rWorkSheet);
            return rWorkSheet;
        }
    }

    private static class TemplateBookFactory
    implements BookFactory {
        private TemplateWorkBook book = new WorkBook();

        private TemplateBookFactory() {
        }

        public FineBook getBookInstance() {
            return this.book;
        }

        public Report getChildReportInstance(String string) {
            WorkSheet workSheet = new WorkSheet();
            this.book.addReport(string, workSheet);
            return workSheet;
        }
    }

    private static interface BookFactory {
        public FineBook getBookInstance();

        public Report getChildReportInstance(String var1);
    }
}

