/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.core.GraphHelper;
import com.fr.report.PageSet;
import com.fr.report.ReportPage;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.AbstractAppExporter;
import com.fr.report.painter.PagePainter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class ImageExporter
extends AbstractAppExporter {
    private String suffix = "jpg";

    public ImageExporter() {
    }

    public ImageExporter(String string) {
        this();
        this.setSuffix(string);
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSet pageSet = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).getTraversingCase();
        this.export(outputStream, pageSet);
        pageSet.release();
    }

    public void export(OutputStream outputStream, PageSet pageSet) throws Exception {
        Object object;
        int n = 0;
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < pageSet.size() && (object = pageSet.getPage(i)) != null; ++i) {
            n = Math.max(n, ((ReportPage)object).getPageWidth());
            n2 += ((ReportPage)object).getPageHeight();
            arrayList.add(object);
        }
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2);
        object = bufferedImage.createGraphics();
        int n3 = 0;
        int n4 = arrayList.size();
        for (int i = 0; i < n4; ++i) {
            ReportPage reportPage = (ReportPage)arrayList.get(i);
            ((Graphics2D)object).translate(0, n3);
            new PagePainter(reportPage, (Graphics2D)object, false).convert();
            ((Graphics2D)object).translate(0, -n3);
            n3 += reportPage.getPageHeight();
        }
        ImageIO.write((RenderedImage)bufferedImage, this.suffix == null ? "jpg" : this.suffix, outputStream);
    }
}

