/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.FT;
import com.fr.report.PageSet;
import com.fr.report.PaperSetting;
import com.fr.report.RWorkBook;
import com.fr.report.Report;
import com.fr.report.ReportSettings;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.cal.LayerPageReport;
import com.fr.report.io.ExcelExporter;
import com.fr.report.io.core.LargeDataExcelExporterReport;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipOutputStream;

public class LargeDataPageExcelExporter
extends ExcelExporter {
    private boolean isPage = false;

    public LargeDataPageExcelExporter(List list, boolean bl) {
        super(list);
        this.isPage = bl;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        File file = new File(FRContext.getCacheManager().getCacheDirectory(), "excel-temp");
        File file2 = new File(file, "TEMP_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
        int n = 0;
        while (file2.exists()) {
            file2 = new File(file, "TEMP_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n);
            ++n;
        }
        Utils.mkdirs(file2);
        file2.deleteOnExit();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        try {
            for (int i = 0; i < resultWorkBook.getReportCount(); ++i) {
                Report report = resultWorkBook.getReport(i);
                if (report == null) continue;
                if (report.getReportSettings() == null) {
                    report.setReportSettings(new ReportSettings());
                }
                report.getReportSettings().setPageOrder(1);
                this.export2temp(file2, resultWorkBook.getReportName(i), report, this.paperSettingList == null ? null : (PaperSetting)this.paperSettingList.get(i), bl);
            }
            FRContext.getLogger().log(Level.INFO, "start compress files");
            Utils.zip(zipOutputStream, file2, "");
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            FRContext.getLogger().log(Level.INFO, "complete compress files");
        }
        finally {
            Utils.deleteFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export2temp(File file, String string, Report report, PaperSetting paperSetting, boolean bl) throws Exception {
        if (string == null || report == null) {
            return;
        }
        PageSet pageSet = report.generateReportPageSet(paperSetting);
        pageSet = pageSet instanceof LayerPageReport.LayerPageSet ? ((LayerPageReport.LayerPageSet)pageSet).getTraversingCase(this.isPage) : pageSet.getTraversingCase();
        try {
            int n = 1;
            FRContext.getLogger().log(Level.INFO, "\"" + string + "\"" + Inter.getLocText("Prepare_Export"));
            FT fT = new FT(0, 0);
            while (fT.to != -1) {
                fT.from = fT.to;
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath() + File.separator + string + "_" + n + ".xls");
                RWorkBook rWorkBook = new RWorkBook();
                try {
                    rWorkBook.addReport(string, new LargeDataExcelExporterReport(report, pageSet, fT, this.isPage));
                    super.export(fileOutputStream, rWorkBook, false);
                    FRContext.getLogger().log(Level.INFO, "\"" + string + "_" + n + ".xls\"" + Inter.getLocText("Finish_Export"));
                }
                finally {
                    fileOutputStream.close();
                }
                ++n;
            }
            Object var13_12 = null;
            if (!bl || !pageSet.pageCached()) {
                pageSet.release();
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (!bl || !pageSet.pageCached()) {
                pageSet.release();
            }
            throw throwable;
        }
        FRContext.getLogger().log(Level.INFO, "\"" + string + Inter.getLocText("Finish_Export"));
    }

    protected void exportBook(ResultWorkBook resultWorkBook, HSSFWorkbook hSSFWorkbook, List list, List list2, List list3, boolean bl) throws Exception {
        Report report;
        int n;
        for (n = 0; n < resultWorkBook.getReportCount(); ++n) {
            report = resultWorkBook.getReport(n);
            list3.add(report);
        }
        for (n = 0; n < resultWorkBook.getReportCount(); ++n) {
            report = (Report)list3.get(n);
            this.innerExportReport(report, resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(n), hSSFWorkbook, list, list2, n);
        }
    }
}

