/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.report.PageSet;
import com.fr.report.Report;
import com.fr.report.ReportPage;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.AbstractAppExporter;
import com.fr.report.io.pdf.MyFontMapper;
import com.fr.report.painter.PagePainter;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.Rectangle;
import com.fr.third.com.lowagie.text.pdf.BaseFont;
import com.fr.third.com.lowagie.text.pdf.FontMapper;
import com.fr.third.com.lowagie.text.pdf.PdfContentByte;
import com.fr.third.com.lowagie.text.pdf.PdfWriter;
import com.fr.util.OperatingSystem;
import com.fr.util.Utils;
import java.awt.Graphics2D;
import java.io.File;
import java.io.OutputStream;
import java.util.Locale;
import java.util.logging.Level;

public class PDFExporter
extends AbstractAppExporter {
    public static final String TYPE_ORIGINAL = "ori";
    public static final String TYPE_RESOLVESOMETHING = "rs";
    protected boolean isPrint = false;
    protected static MyFontMapper fontMapper = null;

    public PDFExporter() {
        this(false);
    }

    public PDFExporter(boolean bl) {
        this.isPrint = bl;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSet pageSet = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).getTraversingCase();
        this.export(outputStream, pageSet);
        pageSet.release();
    }

    public void export(OutputStream outputStream, PageSet pageSet) throws Exception {
        ReportPage reportPage;
        Document document = null;
        PdfWriter pdfWriter = null;
        boolean bl = true;
        for (int i = 0; i < pageSet.size() && (reportPage = pageSet.getPage(i)) != null; ++i) {
            float f = 0.75f;
            float f2 = (float)reportPage.getPageWidth() * f;
            float f3 = (float)reportPage.getPageHeight() * f;
            if (document == null) {
                document = new Document(new Rectangle(f2, f3));
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
                document.open();
            }
            if (!bl) {
                document.setPageSize(new Rectangle(f2, f3));
                document.newPage();
            }
            bl = false;
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            Graphics2D graphics2D = pdfContentByte.createGraphics(f2, f3, (FontMapper)PDFExporter.prepareFontMapper());
            if (!this.isPrint) {
                graphics2D.scale(f, f);
            }
            if (reportPage.getReportSettings().isLonelyPage()) {
                int n;
                Report report = reportPage.getSourceReport();
                DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(report);
                DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(report);
                int n2 = report.getColumnCount();
                int n3 = report.getRowCount();
                int n4 = 0;
                int n5 = 0;
                for (n = 0; n < n2; ++n) {
                    n4 += dynamicValueList.get(n);
                }
                for (n = 0; n < n3; ++n) {
                    n5 += dynamicValueList2.get(n);
                }
                double d = (double)reportPage.getPageWidth() / ((double)(reportPage.getMarginLeft() + reportPage.getMarginRight()) + (double)n4);
                double d2 = (double)reportPage.getPageHeight() / ((double)n5 + (double)reportPage.getMarginTop() + (double)reportPage.getMarginBottom());
                d = d < 1.0 ? d : 1.0;
                d2 = d2 < 1.0 ? d2 : 1.0;
                graphics2D.scale(d, d2);
            }
            new PagePainter(reportPage, graphics2D, this.isPrint).convert();
            graphics2D.dispose();
        }
        if (document != null) {
            document.close();
        }
    }

    protected static MyFontMapper prepareFontMapper() {
        if (fontMapper != null) {
            return fontMapper;
        }
        fontMapper = new MyFontMapper();
        try {
            if (OperatingSystem.isWindows()) {
                File file;
                String string = System.getProperty("java.library.path");
                String[] stringArray = Utils.splitString(string, ";");
                for (int i = 0; i < stringArray.length; ++i) {
                    file = new File(stringArray[i]);
                    PDFExporter.InsertDirectory(fontMapper, new File(file, "Fonts"));
                }
                PDFExporter.InsertDirectory(fontMapper, new File("C:\\WINNT\\Fonts"));
                PDFExporter.InsertDirectory(fontMapper, new File("C:\\WINDOWS\\Fonts"));
                String string2 = System.getProperty("java.home");
                if (string2 != null && (file = new File(BaseCoreUtils.pathJoin(new String[]{string2, "lib", "fonts"}))).exists() && file.isDirectory()) {
                    PDFExporter.InsertDirectory(fontMapper, file);
                }
            } else {
                PDFExporter.InsertDirectory(fontMapper, new File("/usr/X11R6/lib/X11/fonts"));
                PDFExporter.InsertDirectory(fontMapper, new File("/usr/share/fonts"));
                PDFExporter.InsertDirectory(fontMapper, new File("/usr/X/lib/X11/fonts/TrueType"));
                PDFExporter.InsertDirectory(fontMapper, new File("/usr/openwin/lib/X11/fonts/TrueType"));
            }
            if (FRContext.getLocale() == Locale.CHINA || FRContext.getLocale() == Locale.CHINESE) {
                MyFontMapper.defaultFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            } else if (FRContext.getLocale() == Locale.TAIWAN || FRContext.getLocale() == Locale.TRADITIONAL_CHINESE) {
                MyFontMapper.defaultFont = BaseFont.createFont((String)"MSung-Light", (String)"UniCNS-UCS2-H", (boolean)false);
            } else if (FRContext.getLocale() == Locale.JAPAN || FRContext.getLocale() == Locale.JAPANESE) {
                MyFontMapper.defaultFont = BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-H", (boolean)false);
            } else if (FRContext.getLocale() == Locale.KOREA || FRContext.getLocale() == Locale.KOREAN) {
                MyFontMapper.defaultFont = BaseFont.createFont((String)"HYGoThic-Medium", (String)"UniKS-UCS2-H", (boolean)false);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return fontMapper;
    }

    protected static void InsertDirectory(MyFontMapper myFontMapper, File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        myFontMapper.insertDirectory(file.getAbsolutePath());
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            PDFExporter.InsertDirectory(myFontMapper, fileArray[i]);
        }
    }
}

