/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.FRFont;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.core.GraphHelper;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.PageSet;
import com.fr.report.Report;
import com.fr.report.ReportHF;
import com.fr.report.ReportPage;
import com.fr.report.ReportSettings;
import com.fr.report.ResultWorkBook;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.ResultSubReport;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.PDFExporter;
import com.fr.report.painter.PDF2Painter;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.Rectangle;
import com.fr.third.com.lowagie.text.pdf.FontMapper;
import com.fr.third.com.lowagie.text.pdf.PdfContentByte;
import com.fr.third.com.lowagie.text.pdf.PdfPCell;
import com.fr.third.com.lowagie.text.pdf.PdfPTable;
import com.fr.third.com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.Iterator;

public class PDFExporter2
extends PDFExporter {
    private boolean isPrint = false;
    private float unitScale = 1.0f;

    public PDFExporter2() {
        this(false);
    }

    public PDFExporter2(boolean bl) {
        this.isPrint = bl;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSet pageSet = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).getTraversingCase();
        this.export(outputStream, pageSet);
        pageSet.release();
    }

    public void export(OutputStream outputStream, PageSet pageSet) throws Exception {
        ReportPage reportPage;
        Document document = new Document();
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        PDFExporter2.prepareFontMapper();
        for (int i = 0; i < pageSet.size() && (reportPage = pageSet.getPage(i)) != null; ++i) {
            Cloneable cloneable;
            Object object;
            Object object2;
            this.unitScale = 0.75f;
            float f = (float)reportPage.getPageWidth() * this.unitScale;
            float f2 = (float)reportPage.getPageHeight() * this.unitScale;
            float f3 = (float)reportPage.getMarginLeft() * this.unitScale;
            float f4 = (float)reportPage.getMarginRight() * this.unitScale;
            float f5 = (float)reportPage.getMarginTop() * this.unitScale;
            float f6 = (float)reportPage.getMarginBottom() * this.unitScale;
            ReportSettings reportSettings = reportPage.getReportSettings();
            float f7 = (float)ReportUtils.getHeaderHeight(reportSettings) * this.unitScale;
            float f8 = (float)ReportUtils.getFooterHeight(reportSettings) * this.unitScale;
            document.setPageSize(new Rectangle(f, f2));
            document.setMargins(f3, f4, f5, f6);
            document.newPage();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContentUnder();
            Graphics2D graphics2D = pdfContentByte.createGraphics(f, f2, (FontMapper)PDFExporter2.prepareFontMapper());
            if (!this.isPrint) {
                graphics2D.scale(this.unitScale, this.unitScale);
            }
            if (reportSettings.isLonelyPage()) {
                int n;
                object2 = reportPage.getSourceReport();
                DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList((Report)object2);
                object = ReportHelper.getRowHeightList((Report)object2);
                int n2 = object2.getColumnCount();
                int n3 = object2.getRowCount();
                int n4 = 0;
                int n5 = 0;
                for (n = 0; n < n2; ++n) {
                    n4 += dynamicValueList.get(n);
                }
                for (n = 0; n < n3; ++n) {
                    n5 += ((DynamicValueList)object).get(n);
                }
                double d = (double)reportPage.getPageWidth() / ((double)(reportPage.getMarginLeft() + reportPage.getMarginRight()) + (double)n4);
                double d2 = (double)reportPage.getPageHeight() / ((double)n5 + (double)reportPage.getMarginTop() + (double)reportPage.getMarginBottom());
                d = d < 1.0 ? d : 1.0;
                d2 = d2 < 1.0 ? d2 : 1.0;
                graphics2D.scale(d, d2);
            }
            new PDF2Painter(reportPage, graphics2D, this.isPrint).convert();
            graphics2D.dispose();
            int n = reportPage.getColumnCount();
            int n6 = reportPage.getRowCount();
            DynamicValueList dynamicValueList = ReportHelper.createColumnWidthList(reportPage);
            DynamicValueList dynamicValueList2 = ReportHelper.createRowHeightList(reportPage);
            object2 = this.sumDynamicValueList2Float(n, dynamicValueList);
            Object object3 = object2[((Object)object2).length - 1];
            object = this.sumDynamicValueList2Float(n6, dynamicValueList2);
            Object object4 = object[((Object)object).length - 1];
            ReportHF reportHF = reportPage.getHeader();
            if (f7 > 0.0f && reportHF != null) {
                document.add((Element)this.createImageFromHFElement(reportHF, reportPage, f - f3 - f4, f7, this.isPrint));
            }
            float[] fArray = this.DynamicValueList2FloatArray(n, dynamicValueList);
            PdfPTable pdfPTable = new PdfPTable(fArray);
            pdfPTable.setSpacingBefore(0.0f);
            pdfPTable.setSpacingAfter(f2 - object4 - f7 - f8 - f5 - f6);
            pdfPTable.setTotalWidth((float)object3);
            pdfPTable.setLockedWidth(true);
            pdfPTable.setHorizontalAlignment(0);
            Color color = Color.white;
            pdfPTable.getDefaultCell().setBackgroundColor(color);
            pdfPTable.getDefaultCell().setBorderWidth(0.0f);
            Iterator iterator = reportPage.cellIterator();
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            int n10 = 0;
            byte[][] byArray = new byte[reportPage.getRowCount()][reportPage.getColumnCount()];
            while (iterator.hasNext()) {
                cloneable = (CellElement)iterator.next();
                n9 = cloneable.getRow();
                n10 = cloneable.getColumn();
                if (n9 != 0 || n10 != 0) {
                    this.fillBlankCell(pdfPTable, byArray, n7, n8, n9, n10, dynamicValueList2);
                }
                float f9 = f2 - f5 - f7 - object[cloneable.getRow()];
                float f10 = f3 + object2[cloneable.getColumn()];
                pdfPTable.addCell(this.createCellFromCellElement(pdfWriter, f10, f9, (CellElement)cloneable, dynamicValueList, dynamicValueList2, this.isPrint));
                for (int j = 0; j < cloneable.getRowSpan(); ++j) {
                    for (int k = 0; k < cloneable.getColumnSpan(); ++k) {
                        byArray[n9 + j][n10 + k] = 1;
                    }
                }
                n7 = n9;
                n8 = n10;
            }
            this.fillBlankCell(pdfPTable, byArray, n7, n8, -1, -1, dynamicValueList2);
            document.add((Element)pdfPTable);
            cloneable = reportPage.getFooter();
            if (f8 > 0.0f && cloneable != null) {
                document.add((Element)this.createImageFromHFElement((ReportHF)cloneable, reportPage, f - f3 - f4, f8, this.isPrint));
            }
            Iterator iterator2 = reportPage.floatIterator();
            while (iterator2.hasNext()) {
                FloatElement floatElement = (FloatElement)iterator2.next();
                float f11 = f3 + object2[floatElement.getColumn()] + (float)floatElement.getLeftDistance() * this.unitScale;
                float f12 = f2 - f5 - f7 - object[floatElement.getRow()] - (float)floatElement.getTopDistance() * this.unitScale;
                float f13 = (float)floatElement.getSize().getWidth() * this.unitScale;
                float f14 = (float)floatElement.getSize().getHeight() * this.unitScale;
                f12 -= f14;
                Image image = this.drawFloatImage(floatElement, (int)f13, (int)f14);
                if (image == null) continue;
                PdfContentByte pdfContentByte2 = pdfWriter.getDirectContent();
                com.fr.third.com.lowagie.text.Image image2 = com.fr.third.com.lowagie.text.Image.getInstance((Image)image, null);
                image2.setAbsolutePosition(f11, f12);
                pdfContentByte2.addImage(image2);
            }
        }
        document.close();
    }

    private void fillBlankCell(PdfPTable pdfPTable, byte[][] byArray, int n, int n2, int n3, int n4, DynamicValueList dynamicValueList) {
        int n5;
        int n6 = n5 = n < 0 ? 0 : n;
        block0: while (n5 < byArray.length) {
            int n7;
            int n8 = n7 = n5 == n ? n2 + 1 : 0;
            while (n7 < byArray[0].length) {
                if (n5 == n3 && n7 == n4) break block0;
                if (byArray[n5][n7] == 0) {
                    pdfPTable.getDefaultCell().setFixedHeight((float)dynamicValueList.get(n5) * this.unitScale);
                    pdfPTable.addCell("");
                    byArray[n5][n7] = 1;
                }
                ++n7;
            }
            ++n5;
        }
    }

    private PdfPCell createCellFromCellElement(PdfWriter pdfWriter, float f, float f2, CellElement cellElement, DynamicValueList dynamicValueList, DynamicValueList dynamicValueList2, boolean bl) throws Exception {
        PdfPCell pdfPCell = new PdfPCell();
        Style style = cellElement.getStyle();
        Object object = cellElement.getValue();
        int n = dynamicValueList.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan());
        int n2 = dynamicValueList2.getRangeValue(cellElement.getRow(), cellElement.getRow() + cellElement.getRowSpan());
        float f3 = (float)n * this.unitScale;
        float f4 = (float)n2 * this.unitScale;
        n = (int)f3;
        n2 = (int)f4;
        pdfPCell.setColspan(cellElement.getColumnSpan());
        pdfPCell.setRowspan(cellElement.getRowSpan());
        boolean bl2 = false;
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
        if (cellGUIAttr == null) {
            cellGUIAttr = new CellGUIAttr();
        }
        if (!(object instanceof Image || bl && !cellGUIAttr.isPrintContent())) {
            Graphics2D graphics2D;
            Object object2;
            if (!(object instanceof Painter) && !(object instanceof ResultSubReport) && !(object instanceof Image) && this.checkWriteable(style)) {
                if (object instanceof Formula) {
                    object = ((Formula)object).getResult();
                }
                object2 = PaintUtils.valueToText(object, style.getFormat());
                graphics2D = new Paragraph((String)object2, this.frFont2Font(style.getFRFont()));
                if (style.getRotation() % 90 == 0) {
                    pdfPCell.setRotation(style.getRotation());
                }
                graphics2D.setSpacingAfter((float)style.getSpacingAfter() * this.unitScale);
                graphics2D.setSpacingBefore((float)style.getSpacingBefore() * this.unitScale);
                graphics2D.setLeading((float)style.getLineSpacing() * this.unitScale, 1.0f);
                pdfPCell.addElement((Element)graphics2D);
                bl2 = true;
            }
            if (!bl2) {
                object2 = GraphHelper.createBufferedImage((int)((float)n / this.unitScale), (int)((float)n2 / this.unitScale), 6);
                graphics2D = ((BufferedImage)object2).createGraphics();
                graphics2D.setPaint(Color.WHITE);
                if (object instanceof Painter || object instanceof Image) {
                    PaintUtils.paintContent(graphics2D, object, style, (int)((float)n / this.unitScale), (int)((float)n2 / this.unitScale));
                } else {
                    if (Color.BLACK.equals(style.getFRFont().getForeground())) {
                        style = style.deriveFRFont(style.getFRFont().applyForeground(new Color(1, 0, 0)));
                    } else if (Color.WHITE.equals(style.getFRFont().getForeground())) {
                        style = style.deriveFRFont(style.getFRFont().applyForeground(new Color(255, 255, 254)));
                    }
                    PaintUtils.paintContent(graphics2D, object, style, (int)((float)n / this.unitScale), (int)((float)n2 / this.unitScale));
                }
                ((Image)object2).flush();
                graphics2D.dispose();
                pdfPCell.setImage(com.fr.third.com.lowagie.text.Image.getInstance((Image)object2, null));
            }
        }
        pdfPCell.setFixedHeight(f4);
        this.applyCellStyle(pdfPCell, style, bl2);
        return pdfPCell;
    }

    private boolean checkWriteable(Style style) {
        if (style.getVerticalText() == 1) {
            return false;
        }
        if (style.getFRFont() != null && (style.getFRFont().isShadow() || style.getFRFont().isSubscript() || style.getFRFont().isSuperscript())) {
            return false;
        }
        if (style.getTextStyle() != 0) {
            return false;
        }
        return style.getRotation() % 90 == 0;
    }

    private void applyCellStyle(PdfPCell pdfPCell, Style style, boolean bl) {
        switch (style.getHorizontalAlignment()) {
            case 0: {
                pdfPCell.setHorizontalAlignment(1);
                break;
            }
            case 4: {
                pdfPCell.setHorizontalAlignment(2);
            }
        }
        switch (style.getVerticalAlignment()) {
            case 3: {
                pdfPCell.setVerticalAlignment(6);
                break;
            }
            case 0: {
                pdfPCell.setVerticalAlignment(5);
            }
        }
        pdfPCell.setPaddingLeft((float)(GraphHelper.getLineStyleSize(style.getBorderLeft()) + (bl ? style.getPaddingLeft() : 0)) * this.unitScale);
        pdfPCell.setPaddingRight((float)(GraphHelper.getLineStyleSize(style.getBorderRight()) + (bl ? style.getPaddingRight() : 0)) * this.unitScale);
        pdfPCell.setPaddingTop((float)(GraphHelper.getLineStyleSize(style.getBorderTop()) + (bl ? style.getSpacingBefore() : (byte)0)) * this.unitScale);
        pdfPCell.setPaddingBottom((float)(GraphHelper.getLineStyleSize(style.getBorderBottom()) + (bl ? style.getSpacingAfter() : (byte)0)) * this.unitScale);
        pdfPCell.setBorderWidth(0.0f);
    }

    private com.fr.third.com.lowagie.text.Image createImageFromHFElement(ReportHF reportHF, ReportPage reportPage, float f, float f2, boolean bl) throws Exception {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, f, f2);
        BufferedImage bufferedImage = GraphHelper.createBufferedImage((int)f, (int)f2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        GraphHelper.fill(graphics2D, double_);
        reportHF.paint(graphics2D, double_, (int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight(), reportPage.getCurrentPageNumber(), reportPage.getTotalPages(), bl);
        bufferedImage.flush();
        graphics2D.dispose();
        return com.fr.third.com.lowagie.text.Image.getInstance((Image)bufferedImage, null);
    }

    private Font frFont2Font(FRFont fRFont) {
        int n;
        switch (fRFont.getStyle()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (fRFont.isStrikethrough()) {
            n += 8;
        }
        if (fRFont.getUnderline() != 0) {
            n += 4;
        }
        Font font = new Font(fontMapper.awtToPdf(fRFont), (float)fRFont.getSize() * this.unitScale, n, fRFont.getForeground());
        return font;
    }

    private float[] DynamicValueList2FloatArray(int n, DynamicValueList dynamicValueList) {
        float[] fArray = new float[n];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)dynamicValueList.get(i) * this.unitScale;
        }
        return fArray;
    }

    private float[] sumDynamicValueList2Float(int n, DynamicValueList dynamicValueList) {
        int n2 = 0;
        float[] fArray = new float[n + 1];
        for (int i = 0; i < fArray.length - 1; ++i) {
            fArray[i + 1] = (float)(n2 += dynamicValueList.get(i)) * this.unitScale;
        }
        return fArray;
    }

    private Image drawFloatImage(FloatElement floatElement, int n, int n2) {
        if (floatElement == null || n == 0 || n2 == 0) {
            return null;
        }
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        PaintUtils.paintFloatElement(graphics2D, floatElement, n - 1, n2 - 1);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }
}

