/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.report.PageSet;
import com.fr.report.ReportPage;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.AbstractAppExporter;
import com.fr.report.painter.PagePainter;
import java.awt.Graphics2D;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGExporter
extends AbstractAppExporter {
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSet pageSet = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).getTraversingCase();
        this.export(outputStream, pageSet);
        pageSet.release();
    }

    public void export(OutputStream outputStream, PageSet pageSet) throws Exception {
        ReportPage reportPage;
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        int n = 0;
        for (int i = 0; i < pageSet.size() && (reportPage = pageSet.getPage(i)) != null; ++i) {
            double d = 0.75;
            double d2 = d * (double)reportPage.getPageWidth();
            double d3 = d * (double)reportPage.getPageHeight();
            Graphics2D graphics2D = (Graphics2D)sVGGraphics2D.create(0, n, (int)d2, (int)d3);
            graphics2D.scale(d, d);
            new PagePainter(reportPage, graphics2D, false).convert();
            n += (int)d3;
            graphics2D.dispose();
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        sVGGraphics2D.stream((Writer)outputStreamWriter, true);
        outputStream.flush();
    }
}

