/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.background.ColorBackground;
import com.fr.base.core.FRCoreContext;
import com.fr.report.PageSet;
import com.fr.report.ReportPage;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.AbstractAppExporter;
import com.fr.report.painter.PagePainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.util.ArrayList;
import org.freehep.graphicsio.swf.SWFGraphics2D;

public class SWFExporter
extends AbstractAppExporter {
    private static final Object lock = new Object();

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSet pageSet = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).getTraversingCase();
        this.export(outputStream, pageSet);
        pageSet.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(OutputStream outputStream, PageSet pageSet) throws Exception {
        ReportPage reportPage;
        if (outputStream == null || pageSet == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        ArrayList<ReportPage> arrayList = new ArrayList<ReportPage>();
        FRCoreContext.TMAP.put(Thread.currentThread(), Boolean.TRUE);
        double d = 0.75;
        for (int i = 0; i < pageSet.size() && (reportPage = pageSet.getPage(i)) != null; ++i) {
            n = Math.max(n, (int)((double)reportPage.getPageWidth() * d));
            n2 = (int)((double)n2 + (double)reportPage.getPageHeight() * d);
            arrayList.add(reportPage);
        }
        SWFGraphics2D sWFGraphics2D = new SWFGraphics2D(outputStream, new Dimension(n, n2));
        sWFGraphics2D.startExport();
        ColorBackground.getInstance(Color.white).paint((Graphics)sWFGraphics2D, new Rectangle2D.Double(0.0, 0.0, n, n2));
        int n3 = 0;
        int n4 = arrayList.size();
        for (int i = 0; i < n4; ++i) {
            ReportPage reportPage2 = (ReportPage)arrayList.get(i);
            sWFGraphics2D.translate(0, n3);
            Object object = lock;
            synchronized (object) {
                new PagePainter(reportPage2, (Graphics2D)sWFGraphics2D, true).convert();
            }
            sWFGraphics2D.translate(0, -n3);
            n3 = (int)((double)n3 + (double)reportPage2.getPageHeight() * d);
        }
        sWFGraphics2D.endExport();
        FRCoreContext.TMAP.remove(Thread.currentThread());
    }
}

