/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.Style;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.report.FineBook;
import com.fr.report.Report;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.report.io.AbstractEmbExporter;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedStyleList;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class TemplateExporter
extends AbstractEmbExporter {
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.exportBook(outputStream, new ResultBookRXML(resultWorkBook));
    }

    public void export(OutputStream outputStream, TemplateWorkBook templateWorkBook) throws Exception {
        this.exportBook(outputStream, new TemplateBookRXML(templateWorkBook));
    }

    private void exportBook(OutputStream outputStream, RXML rXML) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.writeTo(outputStream);
        TemplateExporter.export(rXML, outputStream);
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
    }

    private static void export(RXML rXML, OutputStream outputStream) throws Exception {
        rXML.nullPointException();
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(outputStream);
        SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList(Thread.currentThread());
        rXML.openTag(xMLPrintWriter);
        rXML.mainContent(xMLPrintWriter);
        xMLPrintWriter.startTAG("StyleList");
        int n = synchronizedStyleList.getStyleCount();
        for (int i = 0; i < n; ++i) {
            Style style = synchronizedStyleList.getStyle(i);
            if (style == null) continue;
            ReportXMLUtils.writeStyle(xMLPrintWriter, style);
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
        SynchronizedStyleList.removeSynchronizedCellStyleList(Thread.currentThread());
    }

    private static class ResultBookRXML
    extends TemplateBookRXML {
        ResultBookRXML(FineBook fineBook) {
            super(fineBook);
        }

        public void openTag(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("RWorkBook");
        }
    }

    private static class TemplateBookRXML
    implements RXML {
        private FineBook b;

        TemplateBookRXML(FineBook fineBook) {
            this.b = fineBook;
        }

        public void nullPointException() throws NullPointerException {
            if (this.b == null) {
                throw new NullPointerException("WorkBook cannot be null");
            }
        }

        public void openTag(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("WorkBook");
        }

        public void mainContent(XMLPrintWriter xMLPrintWriter) {
            this.b.writeXML(xMLPrintWriter);
        }
    }

    private static class ReportRXML
    implements RXML {
        private Report r;

        ReportRXML(Report report) {
            this.r = report;
        }

        public void nullPointException() throws NullPointerException {
            if (this.r == null) {
                throw new NullPointerException("Report cannot be null");
            }
        }

        public void openTag(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("Report").attr("class", this.r.getClass().getName());
        }

        public void mainContent(XMLPrintWriter xMLPrintWriter) {
            this.r.writeXML(xMLPrintWriter);
        }
    }

    private static interface RXML {
        public void nullPointException();

        public void openTag(XMLPrintWriter var1);

        public void mainContent(XMLPrintWriter var1);
    }
}

