/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.Style;
import com.fr.report.CellElement;
import com.fr.report.PageSet;
import com.fr.report.PaperSetting;
import com.fr.report.Report;
import com.fr.report.ReportPage;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.PackedReport;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.cal.LayerPageReport;
import com.fr.report.core.cal.LayerReport;
import com.fr.report.io.AbstractAppExporter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.Format;
import java.util.Iterator;
import java.util.List;

public class TextExporter
extends AbstractAppExporter {
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        List list = ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook);
        for (int i = 0; i < resultWorkBook.getReportCount(); ++i) {
            Report report = resultWorkBook.getReport(i);
            while (report instanceof PackedReport) {
                report = ((PackedReport)report).getPackee();
            }
            this.export(outputStream, report, (PaperSetting)list.get(i));
        }
    }

    private void export(OutputStream outputStream, Report report, PaperSetting paperSetting) throws Exception {
        if (report == null) {
            throw new Exception("Report can not be null!");
        }
        if (report instanceof LayerReport || report instanceof LayerPageReport) {
            PageSet pageSet = report.generateReportPageSet(paperSetting).getTraversingCase();
            this.export(outputStream, pageSet);
            pageSet.release();
        } else {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
            Iterator iterator = report.cellIterator();
            this.writeCells(printWriter, iterator);
            printWriter.flush();
        }
    }

    private void writeCells(PrintWriter printWriter, Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            Object object = cellElement.getValue();
            if (object == null) {
                object = "";
            }
            Style style = cellElement.getStyle();
            Format format = style.getFormat();
            string = PaintUtils.valueToText(object, format);
            int n3 = cellElement.getColumn();
            int n4 = cellElement.getRow();
            if (n4 > n) {
                if (stringBuffer != null) {
                    printWriter.println(stringBuffer.toString());
                }
                n = n4;
                n2 = 0;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                n2 = n3;
                continue;
            }
            for (int i = n2; i < n3; ++i) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(string);
            n2 = n3;
        }
        if (stringBuffer != null) {
            printWriter.print(stringBuffer.toString());
        }
    }

    public void export(OutputStream outputStream, PageSet pageSet) throws Exception {
        ReportPage reportPage;
        if (pageSet == null) {
            throw new Exception("Error! pages is null");
        }
        for (int i = 0; i < pageSet.size() && (reportPage = pageSet.getPage(i)) != null; ++i) {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
            if (reportPage != null) {
                Iterator iterator = reportPage.cellIterator();
                this.writeCells(printWriter, iterator);
                printWriter.println();
                printWriter.println();
                printWriter.println();
                printWriter.println();
            }
            printWriter.flush();
        }
    }
}

