/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io;

import com.fr.base.BaseUtils;
import com.fr.base.FRFont;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.GraphHelper;
import com.fr.data.core.db.BinaryObject;
import com.fr.report.CellElement;
import com.fr.report.PageSet;
import com.fr.report.ReportPage;
import com.fr.report.ReportSettings;
import com.fr.report.ResultWorkBook;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.AbstractAppExporter;
import com.fr.third.com.lowagie.text.Cell;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.Rectangle;
import com.fr.third.com.lowagie.text.Row;
import com.fr.third.com.lowagie.text.Table;
import com.fr.third.com.lowagie.text.rtf.RtfWriter2;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import com.fr.third.com.lowagie.text.rtf.table.RtfBorderGroup;
import com.fr.third.com.lowagie.text.rtf.table.RtfCell;
import com.fr.util.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.util.Iterator;

public class WordExporter
extends AbstractAppExporter {
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSet pageSet = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).getTraversingCase();
        this.export(outputStream, pageSet);
        pageSet.release();
    }

    public void export(OutputStream outputStream, PageSet pageSet) throws Exception {
        ReportPage reportPage;
        Document document = new Document();
        RtfWriter2.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        float f = 0.75f;
        for (int i = 0; i < pageSet.size() && (reportPage = pageSet.getPage(i)) != null; ++i) {
            int n;
            RtfCell rtfCell;
            int n2;
            int n3;
            if (i != 0) {
                document.newPage();
            }
            float f2 = (float)reportPage.getPageWidth() * f;
            float f3 = (float)reportPage.getPageHeight() * f;
            Rectangle rectangle = new Rectangle(f2, f3);
            document.setPageSize(rectangle);
            document.setMargins((float)reportPage.getMarginLeft() * f, (float)reportPage.getMarginRight() * f, (float)reportPage.getMarginTop() * f, (float)reportPage.getMarginBottom() * f);
            int n4 = reportPage.getColumnCount();
            int n5 = reportPage.getRowCount();
            Table table = new Table(Math.max(1, n4), Math.max(1, n5));
            table.setBorder(0);
            ReportSettings reportSettings = reportPage.getReportSettings();
            Background background = reportSettings.getBackground();
            Color color = Color.white;
            if (background != null && background instanceof ColorBackground) {
                color = ((ColorBackground)background).getColor();
                table.setBackgroundColor(color);
            }
            table.setAlignment(4);
            Style style = Style.DEFAULT_STYLE;
            table.setDefaultCell(this.createDefaultCell(color, style));
            table.setAutoFillEmptyCells(true);
            table.setPadding(0.0f);
            table.setSpacing(0.0f);
            float[] fArray = new float[n4];
            float f4 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                fArray[j] = (float)reportPage.getColumnWidth(j) * f;
                f4 += fArray[j];
            }
            float f5 = document.getPageSize().getWidth() - document.leftMargin() - document.rightMargin();
            table.setWidth(f4 / f5 * 100.0f);
            table.setWidths(fArray);
            Iterator iterator = reportPage.cellIterator();
            DynamicValueList dynamicValueList = ReportHelper.createColumnWidthList(reportPage);
            DynamicValueList dynamicValueList2 = ReportHelper.createRowHeightList(reportPage);
            while (iterator.hasNext()) {
                Style style2;
                Object object;
                Style style3;
                CellElement cellElement = (CellElement)iterator.next();
                n3 = cellElement.getColumn();
                Cell cell = this.createCellFromCellElement(cellElement, dynamicValueList, dynamicValueList2);
                if (cell != null && dynamicValueList.getRangeValue(n3, n3 + cellElement.getColumnSpan()) != 0 && dynamicValueList2.getRangeValue(n2, n2 + cellElement.getRowSpan()) != 0) {
                    int n6 = n2 + cellElement.getRowSpan();
                    for (n2 = cellElement.getRow(); n2 < n6 && dynamicValueList2.get(n2) <= 0; ++n2) {
                    }
                    table.addCell(cell, n2, n3);
                }
                if ((style3 = cellElement.getStyle()) == null) continue;
                if (style3.getBorderBottom() != 0 && n2 + 1 < n5 && (object = table.getElement(n2 + 1, n3)) instanceof RtfCell) {
                    rtfCell = (RtfCell)object;
                    style2 = Style.DEFAULT_STYLE;
                    style2 = style2.deriveBorderTop(style3.getBorderBottom(), style3.getBorderBottomColor());
                    this.applyStyleToRtfCell(rtfCell, style2);
                }
                if (style3.getBorderRight() == 0 || n3 + 1 >= n4 || !((object = table.getElement(n2, n3 + 1)) instanceof RtfCell)) continue;
                rtfCell = (RtfCell)object;
                style2 = Style.DEFAULT_STYLE;
                style2 = style2.deriveBorderLeft(style3.getBorderRight(), style3.getBorderRightColor());
                this.applyStyleToRtfCell(rtfCell, style2);
            }
            for (n = reportPage.getColumnCount() - 1; n >= 0; --n) {
                if (reportPage.getColumnWidth(n) != 0) continue;
                table.deleteColumn(n);
            }
            for (n = table.size() - 1; n >= reportPage.getRowCount(); --n) {
                table.deleteRow(n);
            }
            float f6 = 0.0f;
            n2 = 0;
            n3 = reportPage.getRowCount() - 1;
            for (int j = reportPage.getRowCount() - 1; j >= 0; --j) {
                if (reportPage.getRowHeight(j) == 0) {
                    table.deleteRow(j);
                    --n3;
                    continue;
                }
                Row row = table.getRow(j);
                row.setHeight(reportPage.getRowHeight(j) * -1 * 15);
                f6 += (float)reportPage.getRowHeight(j);
                if (reportPage.getRowHeight(j) <= n2) continue;
                n2 = reportPage.getRowHeight(j);
                n3 = j;
            }
            float f7 = document.getPageSize().getHeight() - document.topMargin() - document.bottomMargin();
            float f8 = (f * f6 - f7 + 2.0f) / f;
            if (f8 > 0.0f) {
                int n7 = (int)f8;
                if (f8 - (float)n7 > 0.0f) {
                    ++n7;
                }
                rtfCell = table.getRow(n3);
                rtfCell.setHeight((n2 - n7) * -1 * 15);
            }
            document.add((Element)table);
        }
        if (document != null) {
            document.close();
        }
    }

    private Cell createDefaultCell(Color color, Style style) throws Exception {
        RtfCell rtfCell = new RtfCell((Element)new Paragraph("", this.frFont2RTFFont(style.getFRFont())));
        rtfCell.setBackgroundColor(color);
        RtfBorderGroup rtfBorderGroup = new RtfBorderGroup();
        rtfBorderGroup.addBorder(1, 1, 1.0f, color);
        rtfBorderGroup.addBorder(8, 1, 1.0f, color);
        rtfBorderGroup.addBorder(2, 1, 1.0f, color);
        rtfBorderGroup.addBorder(4, 1, 1.0f, color);
        rtfCell.setBorders(rtfBorderGroup);
        return rtfCell;
    }

    private Cell createCellFromCellElement(CellElement cellElement, DynamicValueList dynamicValueList, DynamicValueList dynamicValueList2) throws Exception {
        RtfCell rtfCell;
        Image image;
        Object object;
        Object object2;
        Style style = cellElement.getStyle();
        Object object3 = cellElement.getValue();
        if (object3 instanceof Painter) {
            int n = dynamicValueList.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan());
            int n2 = dynamicValueList2.getRangeValue(cellElement.getRow(), cellElement.getRow() + cellElement.getRowSpan());
            n = (int)((double)n * 9.65 / 10.0);
            object2 = GraphHelper.createBufferedImage(n, n2, 2);
            Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
            ((Painter)object3).paint(graphics2D, n, n2, style);
            graphics2D.dispose();
            object3 = object2;
        } else if (object3 instanceof Clob) {
            object3 = Utils.clob2String((Clob)object3);
        } else if (object3 instanceof BinaryObject) {
            BinaryObject binaryObject = (BinaryObject)object3;
            Image image2 = null;
            if (binaryObject.getBytes().length < 5000000 || (image2 = binaryObject.getImage()) != null) {
                Object object4 = object3 = image2 == null ? binaryObject.getValue() : image2;
            }
        }
        if (object3 instanceof Image) {
            object = new ByteArrayOutputStream();
            image = (Image)object3;
            BaseUtils.writeImage(image, "png", (OutputStream)object);
            object2 = com.fr.third.com.lowagie.text.Image.getInstance((byte[])((ByteArrayOutputStream)object).toByteArray());
            float f = image.getWidth(null);
            float f2 = image.getHeight(null);
            object2.scaleAbsolute(f * 72.0f, f2 * 72.0f);
            rtfCell = new RtfCell((Element)object2);
        } else {
            if (object3 instanceof Formula) {
                object3 = ((Formula)object3).getResult();
            }
            object = PaintUtils.valueToText(object3, style.getFormat());
            object = ((String)object).replaceAll("\\r", "");
            image = new Paragraph((String)object, this.frFont2RTFFont(style.getFRFont()));
            image.setSpacingBefore((float)style.getSpacingBefore() * 0.5f);
            image.setSpacingAfter((float)style.getSpacingAfter() * 0.5f);
            image.setLeading((float)style.getLineSpacing() * 2.0f);
            rtfCell = new RtfCell((Element)image);
        }
        if (rtfCell != null) {
            int n = cellElement.getRowSpan();
            for (int i = cellElement.getRow(); i < cellElement.getRow() + cellElement.getRowSpan(); ++i) {
                if (dynamicValueList2.get(i) != 0) continue;
                --n;
            }
            rtfCell.setColspan(cellElement.getColumnSpan());
            rtfCell.setRowspan(n);
            this.applyStyleToRtfCell(rtfCell, style);
        }
        return rtfCell;
    }

    private void applyStyleToRtfCell(RtfCell rtfCell, Style style) {
        Background background = style.getBackground();
        Color color = Color.white;
        if (background instanceof ColorBackground) {
            rtfCell.setBackgroundColor(((ColorBackground)background).getColor());
            color = ((ColorBackground)background).getColor();
        }
        RtfBorderGroup rtfBorderGroup = new RtfBorderGroup();
        if (style.getBorderTop() != 0) {
            rtfBorderGroup.addBorder(1, this.frBorder2RTFBorder(style.getBorderTop()), this.frBorderWidth2RTFBorderWidth(style.getBorderTop()), style.getBorderTopColor());
        } else {
            rtfBorderGroup.addBorder(1, 1, 0.5f, color);
        }
        if (style.getBorderLeft() != 0) {
            rtfBorderGroup.addBorder(4, this.frBorder2RTFBorder(style.getBorderLeft()), this.frBorderWidth2RTFBorderWidth(style.getBorderLeft()), style.getBorderLeftColor());
        } else {
            rtfBorderGroup.addBorder(4, 1, 0.5f, color);
        }
        if (style.getBorderBottom() != 0) {
            rtfBorderGroup.addBorder(2, this.frBorder2RTFBorder(style.getBorderBottom()), this.frBorderWidth2RTFBorderWidth(style.getBorderBottom()), style.getBorderBottomColor());
        } else {
            rtfBorderGroup.addBorder(2, 1, 0.5f, color);
        }
        if (style.getBorderRight() != 0) {
            rtfBorderGroup.addBorder(8, this.frBorder2RTFBorder(style.getBorderRight()), this.frBorderWidth2RTFBorderWidth(style.getBorderRight()), style.getBorderRightColor());
        } else {
            rtfBorderGroup.addBorder(8, 1, 0.5f, color);
        }
        rtfCell.setBorders(rtfBorderGroup);
        int n = style.getHorizontalAlignment();
        if (n == 2) {
            rtfCell.setHorizontalAlignment(0);
        } else if (n == 0) {
            rtfCell.setHorizontalAlignment(1);
        } else if (n == 4) {
            rtfCell.setHorizontalAlignment(2);
        }
        int n2 = style.getVerticalAlignment();
        if (n2 == 1) {
            rtfCell.setVerticalAlignment(4);
        } else if (n == 0) {
            rtfCell.setVerticalAlignment(5);
        } else if (n == 3) {
            rtfCell.setVerticalAlignment(6);
        }
    }

    private int frBorder2RTFBorder(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 3: 
            case 14: {
                return 5;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 9;
            }
            case 7: {
                return 4;
            }
            case 6: {
                return 7;
            }
            case 15: {
                return 7;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 1;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }

    private float frBorderWidth2RTFBorderWidth(int n) {
        return GraphHelper.getLineStyleSize(n);
    }

    private Font frFont2RTFFont(FRFont fRFont) {
        int n;
        switch (fRFont.getStyle()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (fRFont.isShadow()) {
            n += 32;
        }
        if (fRFont.isStrikethrough()) {
            n += 8;
        }
        if (fRFont.getUnderline() != 0) {
            n += 4;
        }
        String string = fRFont.getFamily();
        int n2 = 0;
        if ("\u4eff\u5b8b_GB2312".equals(string)) {
            try {
                string = new String("\u4eff\u5b8b_GB2312".getBytes("gb18030"), "iso-8859-1");
                n2 = 134;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        RtfFont rtfFont = new RtfFont(string, (float)fRFont.getSize() * 0.75f, n, fRFont.getForeground(), n2);
        return rtfFont;
    }
}

