/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io.core;

import com.fr.data.Dictionary;
import com.fr.data.TableData;
import com.fr.data.impl.CustomDictionary;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.report.CellElement;
import com.fr.report.Report;
import com.fr.report.TemplateWorkBook;
import com.fr.report.WorkBook;
import com.fr.report.cellElement.core.CellUtils;
import com.fr.report.core.ParameterHelper;
import com.fr.report.io.AbstractEmbExporter;
import com.fr.report.io.TemplateExporter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EmbeddedTableDataExporter
extends AbstractEmbExporter {
    public void export(OutputStream outputStream, TemplateWorkBook templateWorkBook) throws Exception {
        templateWorkBook = (WorkBook)templateWorkBook.clone();
        this.convertWorkBook(templateWorkBook);
        new TemplateExporter().export(outputStream, templateWorkBook);
    }

    private void convertWorkBook(TemplateWorkBook templateWorkBook) throws Exception {
        HashMap<String, TableData> hashMap = new HashMap<String, TableData>();
        Iterator iterator = templateWorkBook.getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TableData tableData = templateWorkBook.getTableData(string);
            hashMap.put(string, tableData);
        }
        int n = templateWorkBook.getReportCount();
        for (int i = 0; i < n; ++i) {
            this.convertCellElement(templateWorkBook.getReport(i), hashMap);
        }
        Iterator iterator2 = hashMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            templateWorkBook.putTableData(entry.getKey().toString(), EmbeddedTableData.embedify((TableData)entry.getValue()));
        }
    }

    private void convertCellElement(Report report, Map map) {
        Iterator iterator = report.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            ParameterHelper.collectValueTableData(cellElement.getValue(), map);
            Dictionary dictionary = CellUtils.getDictionary(cellElement);
            if (dictionary == null || dictionary instanceof CustomDictionary) continue;
            CellUtils.setDictionary(cellElement, CustomDictionary.customify(dictionary));
        }
    }
}

