/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io.core;

import com.fr.report.cellElement.Formula;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;
import com.fr.util.Utils;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;

public class ExcelUtils {
    public static final double AJUST_WIDTH = 34.742;
    public static final double AJUST_HEIGHT = 15.207675329298683;
    private static Hashtable colorHash = new Hashtable();
    private static Hashtable hssfColorIndexHash = HSSFColor.getIndexHash();
    public static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    public static final int UNIT_OFFSET_LENGTH = 7;
    public static final int[] UNIT_OFFSET_MAP = new int[]{0, 36, 73, 109, 146, 182, 219};

    public static short transColor(int n) {
        Object v = colorHash.get(String.valueOf(n));
        if (v == null) {
            Color color = new Color(n, true);
            int n2 = color.getRed();
            int n3 = color.getGreen();
            int n4 = color.getBlue();
            int n5 = 0;
            double d = Double.MAX_VALUE;
            Iterator iterator = hssfColorIndexHash.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n6 = (Integer)iterator.next();
                int n7 = n6;
                short[] sArray = ((HSSFColor)hssfColorIndexHash.get(n6)).getTriplet();
                double d2 = Math.pow(n2 - sArray[0], 2.0) + Math.pow(n3 - sArray[1], 2.0) + Math.pow(n4 - sArray[2], 2.0);
                if (d2 >= d) continue;
                d = d2;
                n5 = n7;
                if (d != 0.0) continue;
            }
            colorHash.put(String.valueOf(n), String.valueOf(n5));
            return (short)n5;
        }
        return Short.valueOf((String)v);
    }

    public static short pixel2WidthUnits(int n) {
        return (short)Math.ceil(34.742 * (double)n);
    }

    public static int widthUnits2Pixel(short s) {
        int n = s / 256 * 7;
        int n2 = s % 256;
        return n += Math.round((float)n2 / 36.57143f);
    }

    public static short printWidth2Design(short s) {
        if (s <= 0) {
            return 0;
        }
        s = (short)((double)s * 0.75);
        short s2 = (short)((s + 30) / 70 * 4);
        short s3 = (short)((s + 30) % 70);
        if (s3 < 0 || s3 >= 20) {
            if (s3 >= 20 && s3 < 40) {
                s2 = (short)(s2 + 1);
            } else if (s3 >= 40 && s3 <= 50) {
                s2 = (short)(s2 + 2);
            } else if (s3 > 50 && s3 < 70) {
                s2 = (short)(s2 + 3);
            }
        }
        return (short)(s - s2);
    }

    public static short printWidth2Desing_2(short s) {
        if (s <= 0) {
            return 0;
        }
        s = (short)(s - s / 30 * 2);
        return s;
    }

    public static short designWidth2Print(short s) {
        return s;
    }

    public static void main(String[] stringArray) {
        System.out.println("236---->" + ExcelUtils.printWidth2Design((short)72));
    }

    public static Object getHSSFCellValue(HSSFCell hSSFCell) {
        Object object = null;
        if (hSSFCell.getCellType() == 1) {
            object = hSSFCell.getStringCellValue();
        } else if (hSSFCell.getCellType() == 0) {
            if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell)) {
                return hSSFCell.getDateCellValue();
            }
            object = Utils.string2Number(Utils.doubleToString(hSSFCell.getNumericCellValue()));
        } else if (hSSFCell.getCellType() == 4) {
            object = hSSFCell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
        } else if (hSSFCell.getCellType() == 2) {
            String string = hSSFCell.getCellFormula();
            object = new Formula(string);
        } else if (hSSFCell.getCellType() == 5) {
            object = "" + hSSFCell.getErrorCellValue();
        } else if (hSSFCell.getCellType() == 3) {
            object = "";
        }
        return object;
    }
}

