/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io.core;

import com.fr.base.FRFont;
import com.fr.base.Inter;
import com.fr.base.Style;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.RWorkBook;
import com.fr.report.Report;
import com.fr.report.TemplateReport;
import com.fr.report.WorkBook;
import com.fr.report.WorkSheet;
import com.fr.report.core.PaintUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedFrozenColumnRow;
import com.fr.report.io.xml.SynchronizedNameWidget;
import com.fr.report.io.xml.SynchronizedReportSettings;
import com.fr.report.io.xml.SynchronizedStyleList;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.util.Utils;
import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.Format;
import java.util.Iterator;

public class IOHelper {
    private IOHelper() {
    }

    public static void innerExportReport(Report report, OutputStream outputStream, char c, String string) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            printWriter = new PrintWriter(outputStream);
        }
        StringBuffer stringBuffer = null;
        int n = 0;
        int n2 = 0;
        Iterator iterator = report.cellIterator();
        while (iterator.hasNext()) {
            int n3;
            CellElement cellElement = (CellElement)iterator.next();
            Object object = cellElement.getValue();
            if (object == null) {
                object = "";
            }
            Style style = cellElement.getStyle();
            Format format = style.getFormat();
            String string2 = PaintUtils.valueToText(object, format);
            int n4 = cellElement.getColumn();
            int n5 = cellElement.getRow();
            if (n5 > n) {
                if (stringBuffer != null) {
                    printWriter.println(stringBuffer.toString());
                }
                for (n3 = n; n3 < n5; ++n3) {
                    printWriter.println();
                }
                stringBuffer = new StringBuffer();
                n = n5;
                for (n3 = n2 = 0; n3 < n4; ++n3) {
                    stringBuffer.append(c);
                }
                stringBuffer.append(string2);
                n2 = n4;
                continue;
            }
            stringBuffer = new StringBuffer();
            for (n3 = n2; n3 < n4; ++n3) {
                stringBuffer.append(c);
            }
            stringBuffer.append(string2);
            n2 = n4;
        }
        if (stringBuffer != null) {
            printWriter.print(stringBuffer.toString());
        }
        printWriter.flush();
        printWriter.close();
    }

    public static String createCSSFont(Font font) {
        if (font == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("font-family:").append(font.getName()).append(";");
        stringBuffer.append("font-size:").append(font.getSize()).append(";");
        if (font.isBold()) {
            stringBuffer.append("font-weight:bold;");
        }
        if (font.isItalic()) {
            stringBuffer.append("font-style:italic;");
        }
        if (font instanceof FRFont) {
            FRFont fRFont = (FRFont)font;
            stringBuffer.append("color:").append(Utils.javaColorToCSSColor(fRFont.getForeground())).append(";");
            stringBuffer.append("text-decoration:");
            if (!fRFont.isStrikethrough() || fRFont.getUnderline() == 0) {
                stringBuffer.append(" none");
            } else {
                if (fRFont.isStrikethrough()) {
                    stringBuffer.append(" line-through ");
                }
                if (fRFont.getUnderline() != 0) {
                    stringBuffer.append(" underline");
                }
            }
            stringBuffer.append(";");
            if (fRFont.isSubscript() || fRFont.isSuperscript()) {
                stringBuffer.append("font-variant:small-caps;");
            }
        }
        return stringBuffer.toString();
    }

    public static String createCSSBorder(int n, int n2, Color color) {
        return IOHelper.createCSSBorder(n, n2, Utils.javaColorToCSSColor(color));
    }

    public static String createCSSBorder(int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "border";
        if (n == 1) {
            string2 = string2 + "-top";
        } else if (n == 4) {
            string2 = string2 + "-right";
        } else if (n == 3) {
            string2 = string2 + "-bottom";
        } else if (n == 2) {
            string2 = string2 + "-left";
        }
        stringBuffer.append(string2).append("-color:").append(string).append(";");
        if (n2 == 0) {
            stringBuffer.append(string2).append("-style:solid;");
            stringBuffer.append(string2).append("-width:0px;");
        } else if (n2 == 1) {
            stringBuffer.append(string2).append("-style:solid;");
            stringBuffer.append(string2).append("-width:1px;");
        } else if (n2 == 2) {
            stringBuffer.append(string2).append("-style:solid;");
            stringBuffer.append(string2).append("-width:2px;");
        } else if (n2 == 6) {
            stringBuffer.append(string2).append("-style:double;");
            stringBuffer.append(string2).append("-width:2px;");
        } else if (n2 == 3 || n2 == 4 || n2 == 14) {
            stringBuffer.append(string2).append("-style:dashed;");
            stringBuffer.append(string2).append("-width:1px;");
        } else if (n2 == 5) {
            stringBuffer.append(string2).append("-style:solid;");
            stringBuffer.append(string2).append("-width:3px;");
        } else if (n2 == 7) {
            stringBuffer.append(string2).append("-style:dotted;");
            stringBuffer.append(string2).append("-width:1px;");
        } else if (n2 == 8 || n2 == 10 || n2 == 12 || n2 == 13) {
            stringBuffer.append(string2).append("-style:dashed;");
            stringBuffer.append(string2).append("-width:2px;");
        } else if (n2 == 9 || n2 == 11) {
            stringBuffer.append(string2).append("-style:dotted;");
            stringBuffer.append(string2).append("-width:2px;");
        }
        return stringBuffer.toString();
    }

    public static int getBorderWidth(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 14: {
                return 1;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    public static WorkBook generateTemplate(InputStream inputStream, String string) throws Exception {
        if (inputStream == null) {
            throw new Exception(Inter.getLocText("Cannot_Found_Template_File") + ".");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        XMLableReader xMLableReader = XMLableReader.createXMLableReader(inputStreamReader);
        String string2 = xMLableReader.getTagName();
        if (string2 == null) {
            throw new Exception(Inter.getLocText("Error_Template_File") + ".");
        }
        WorkBook workBook = null;
        if (string2.equals("WorkBook")) {
            workBook = new WorkBook();
            xMLableReader.readXMLObject(workBook);
        } else if (string2.equals("Report")) {
            TemplateReport templateReport = null;
            String string3 = xMLableReader.getAttr("class");
            if (string3 != null) {
                Report report = ReportXMLUtils.readReportFromClassName(string3);
                if (report instanceof TemplateReport) {
                    templateReport = (TemplateReport)report;
                } else {
                    throw new Exception("Error Report Class (" + report.getClass().getName() + ") in Template File.");
                }
            }
            if (templateReport == null) {
                templateReport = new WorkSheet();
            }
            workBook = new WorkBook();
            workBook.addReport("Compatible0651WorkSheet", templateReport);
            xMLableReader.readXMLObject(templateReport);
            workBook.setReportName(0, "sheet1");
        }
        SynchronizedReportSettings.flushSynchronizedReportSettings();
        SynchronizedFrozenColumnRow.flushSynchronizedFrozenColumnRow(workBook);
        SynchronizedStyleList.flush_current_thread_styles();
        SynchronizedStyleList.removeSynchronizedCellStyleList(Thread.currentThread());
        SynchronizedNameWidget.removeCurrent();
        SynchronizedVersion.removeSynchronizedVersion(Thread.currentThread());
        xMLableReader.close();
        return workBook;
    }

    public static RWorkBook generateResult(InputStream inputStream, String string) throws Exception {
        if (inputStream == null) {
            throw new Exception(Inter.getLocText("Cannot_Found_Template_File") + ".");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        XMLableReader xMLableReader = XMLableReader.createXMLableReader(inputStreamReader);
        String string2 = xMLableReader.getTagName();
        if (string2 == null) {
            throw new Exception(Inter.getLocText("Error_Template_File") + ".");
        }
        RWorkBook rWorkBook = null;
        if (string2.equals("RWorkBook") || string2.equals("WorkBook")) {
            rWorkBook = new RWorkBook();
            xMLableReader.readXMLObject(rWorkBook);
        }
        SynchronizedStyleList.flush_current_thread_styles();
        SynchronizedStyleList.removeSynchronizedCellStyleList(Thread.currentThread());
        SynchronizedNameWidget.removeCurrent();
        SynchronizedVersion.removeSynchronizedVersion(Thread.currentThread());
        xMLableReader.close();
        return rWorkBook;
    }
}

