/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io.core;

import com.fr.base.FRContext;
import com.fr.base.core.FT;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.FineBook;
import com.fr.report.FloatElement;
import com.fr.report.PageSet;
import com.fr.report.Report;
import com.fr.report.ReportHF;
import com.fr.report.ReportPage;
import com.fr.report.ReportPageAttr;
import com.fr.report.ReportSettings;
import com.fr.report.ResultWorkBook;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.ExcelExporter;
import com.fr.report.io.core.ExcelReport;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;

public class LargeDataExcelExporterReport
extends ExcelReport {
    private static final int MAX_ROW_COUNT = 25000;
    private Report sourceReport;
    private PageSet pageSet;
    private FT pn_area;
    private List floatList = null;
    private ResultWorkBook workbook = null;
    private boolean isPage = true;

    public LargeDataExcelExporterReport(Report report, PageSet pageSet, FT fT, boolean bl) {
        this.sourceReport = report;
        this.pageSet = pageSet;
        this.pn_area = fT;
        this.isPage = bl;
        this.columnWidthList = new DynamicValueList(19, 25000);
        this.rowHeightList = new DynamicValueList(19, ExcelExporter.EXCELROWS);
    }

    public int getColumnWidth(int n) {
        return this.columnWidthList.get(n);
    }

    public int getRowHeight(int n) {
        return this.rowHeightList.get(n);
    }

    public Iterator cellIterator() {
        return new PageExcelCellIterator();
    }

    public Iterator floatIterator() {
        return this.floatList == null ? null : this.floatList.iterator();
    }

    public ReportHF getFooter(int n) {
        return this.sourceReport.getFooter(n);
    }

    public ReportHF getHeader(int n) {
        return this.sourceReport.getHeader(n);
    }

    public ReportPageAttr getReportPageAttr() {
        return this.sourceReport.getReportPageAttr();
    }

    public ReportSettings getReportSettings() {
        return ReportUtils.getReportSettings(this.sourceReport);
    }

    public ResultWorkBook getResultWorkBook() {
        return this.workbook;
    }

    public void setResultWorkBook(ResultWorkBook resultWorkBook) {
        this.workbook = resultWorkBook;
    }

    public FineBook getBook() {
        return this.workbook;
    }

    private class PageExcelCellIterator
    implements Iterator {
        private CellElement next;
        private Iterator current_it;
        private int current_page_y;
        private int current_page_x;
        private int current_row;
        private int first_y;
        private int maxX = Integer.MAX_VALUE;
        private int maxY = Integer.MAX_VALUE;
        private Point current_offset;
        private boolean[] x_checklast = new boolean[1];
        private List reportPageList = null;
        private int row_count;
        private int pn;

        private PageExcelCellIterator() {
            LargeDataExcelExporterReport.this.floatList = new ArrayList();
            this.current_offset = new Point(0, 0);
            this.pn = ((LargeDataExcelExporterReport)LargeDataExcelExporterReport.this).pn_area.from;
            this.findNext();
            if (this.next == null) {
                this.next = new DefaultCellElement(0, 0, "");
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            CellElement cellElement = this.next;
            this.findNext();
            return cellElement;
        }

        private void findNext() {
            while (this.reportPageList != null || this.maxY == Integer.MAX_VALUE) {
                if (this.reportPageList == null) {
                    this.reportPageList = new ArrayList();
                    ReportPage reportPage = null;
                    while ((reportPage = LargeDataExcelExporterReport.this.pageSet.getPage(this.pn)) != null) {
                        if (this.reportPageList.size() == 0) {
                            this.current_page_y = reportPage.getXY()[1];
                            if (((LargeDataExcelExporterReport)LargeDataExcelExporterReport.this).pn_area.from == this.pn) {
                                this.row_count += reportPage.getRowCount();
                                this.first_y = this.current_page_y;
                            }
                        } else if (reportPage.getXY()[1] != this.current_page_y) {
                            if (this.current_page_y == this.first_y) {
                                this.maxX = this.reportPageList.size();
                                this.x_checklast = new boolean[this.maxX];
                            }
                            this.row_count += reportPage.getRowCount();
                            if (this.row_count <= 25000) break;
                            this.maxY = this.current_page_y;
                            ((LargeDataExcelExporterReport)LargeDataExcelExporterReport.this).pn_area.to = this.pn;
                            break;
                        }
                        this.reportPageList.add(reportPage);
                        ++this.pn;
                    }
                    if (reportPage == null) {
                        this.maxY = this.reportPageList.size() == 0 ? 0 : this.current_page_y;
                        this.pn = -1;
                        ((LargeDataExcelExporterReport)LargeDataExcelExporterReport.this).pn_area.to = -1;
                    }
                }
                if (this.reportPageList.size() > 0) {
                    int n = ((ReportPage)this.reportPageList.get(0)).getRowCount();
                    while (this.current_row < n) {
                        while (this.current_page_x < this.reportPageList.size()) {
                            ReportPage reportPage = (ReportPage)this.reportPageList.get(this.current_page_x);
                            if (this.current_it == null) {
                                int n2;
                                this.current_it = reportPage.getRow(this.current_row);
                                if (this.current_page_y == this.first_y && this.current_row == 0) {
                                    for (n2 = 0; n2 < reportPage.getColumnCount(); ++n2) {
                                        LargeDataExcelExporterReport.this.columnWidthList.set(this.current_offset.x + n2, reportPage.getColumnWidth(n2));
                                    }
                                }
                                if (this.current_page_x == 0 && this.current_row == 0) {
                                    for (n2 = 0; n2 < reportPage.getRowCount(); ++n2) {
                                        LargeDataExcelExporterReport.this.rowHeightList.set(this.current_offset.y + n2, reportPage.getRowHeight(n2));
                                    }
                                }
                                if (this.current_row == 0) {
                                    Iterator iterator = reportPage.floatIterator();
                                    while (iterator.hasNext()) {
                                        FloatElement floatElement = (FloatElement)iterator.next();
                                        floatElement.setRow(floatElement.getRow() + this.current_offset.y);
                                        floatElement.setColumn(floatElement.getColumn() + this.current_offset.x);
                                        LargeDataExcelExporterReport.this.floatList.add(floatElement);
                                    }
                                }
                            }
                            if (this.current_it.hasNext()) {
                                CellElement cellElement = (CellElement)this.current_it.next();
                                if (cellElement.getRow() + cellElement.getRowSpan() == reportPage.getRowCount() && cellElement.getColumn() + cellElement.getColumnSpan() == reportPage.getColumnCount()) {
                                    if (cellElement.getCellPageAttr() != null) {
                                        try {
                                            cellElement.setCellPageAttr((CellPageAttr)cellElement.getCellPageAttr().clone());
                                        }
                                        catch (CloneNotSupportedException cloneNotSupportedException) {
                                            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                                        }
                                    } else {
                                        cellElement.setCellPageAttr(new CellPageAttr());
                                    }
                                    if (LargeDataExcelExporterReport.this.isPage && (this.current_page_x != this.maxX || this.current_page_y != this.maxY)) {
                                        if (this.current_page_x == this.maxX) {
                                            cellElement.getCellPageAttr().setPageAfterRow(true);
                                        } else if (this.current_page_y == this.maxY) {
                                            cellElement.getCellPageAttr().setPageAfterColumn(true);
                                        } else {
                                            cellElement.getCellPageAttr().setPageAfterRow(true);
                                            cellElement.getCellPageAttr().setPageAfterColumn(true);
                                        }
                                    }
                                    this.x_checklast[this.current_page_x] = true;
                                }
                                cellElement.setRow(cellElement.getRow() + this.current_offset.y);
                                cellElement.setColumn(cellElement.getColumn() + this.current_offset.x);
                                this.next = cellElement;
                                return;
                            }
                            if (this.current_row == n - 1 && !this.x_checklast[this.current_page_x]) {
                                DefaultCellElement defaultCellElement = new DefaultCellElement();
                                defaultCellElement.setRow(this.current_offset.y + reportPage.getRowCount() - 1);
                                defaultCellElement.setColumn(this.current_offset.x + reportPage.getColumnCount() - 1);
                                defaultCellElement.setCellPageAttr(new CellPageAttr());
                                if (LargeDataExcelExporterReport.this.isPage && (this.current_page_x != this.maxX || this.current_page_y != this.maxY)) {
                                    if (this.current_page_x == this.maxX) {
                                        defaultCellElement.getCellPageAttr().setPageAfterRow(true);
                                    } else if (this.current_page_y == this.maxY) {
                                        defaultCellElement.getCellPageAttr().setPageAfterColumn(true);
                                    } else {
                                        defaultCellElement.getCellPageAttr().setPageAfterRow(true);
                                        defaultCellElement.getCellPageAttr().setPageAfterColumn(true);
                                    }
                                }
                                this.x_checklast[this.current_page_x] = true;
                                this.next = defaultCellElement;
                                return;
                            }
                            this.current_it = null;
                            this.current_offset.x += reportPage.getColumnCount();
                            ++this.current_page_x;
                        }
                        this.current_page_x = 0;
                        this.current_offset.x = 0;
                        ++this.current_row;
                    }
                }
                for (int i = 0; i < this.x_checklast.length; ++i) {
                    this.x_checklast[i] = false;
                }
                this.current_offset.y += this.current_row;
                this.current_row = 0;
                this.reportPageList = null;
            }
            this.next = null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

