/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io.core;

import com.fr.base.FRContext;
import com.fr.base.core.FT;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.FineBook;
import com.fr.report.FloatElement;
import com.fr.report.PageSet;
import com.fr.report.Report;
import com.fr.report.ReportHF;
import com.fr.report.ReportPage;
import com.fr.report.ReportPageAttr;
import com.fr.report.ReportSettings;
import com.fr.report.ResultWorkBook;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.core.ExcelReport;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;

public class PageExcelExporterReport
extends ExcelReport {
    private Report sourceReport;
    private PageSet pageSet;
    private FT xArea;
    private FT yArea;
    private int[] maxXY;
    private FT pageInfo;
    private int pageOrder;
    private List floatList = null;
    private ReportPage[][] page_array;

    public PageExcelExporterReport(Report report, PageSet pageSet, FT fT, FT fT2, FT fT3, int[] nArray, int n) {
        this.sourceReport = report;
        this.pageSet = pageSet;
        this.xArea = fT;
        this.yArea = fT2;
        this.maxXY = nArray;
        this.pageOrder = n;
        this.pageInfo = fT3;
        this.init();
    }

    private void init() {
        int n;
        int n2;
        int n3;
        this.page_array = new ReportPage[this.yArea.to - this.yArea.from][this.xArea.to - this.xArea.from];
        if (this.pageOrder == 0) {
            for (n3 = this.xArea.from; n3 < this.xArea.to; ++n3) {
                for (n2 = this.yArea.from; n2 < this.yArea.to; ++n2) {
                    this.page_array[n2 - this.yArea.from][n3 - this.xArea.from] = this.pageSet.getPage(n2 - 1 + (n3 - 1) * this.maxXY[1]);
                    this.page_array[n2 - this.yArea.from][n3 - this.xArea.from].getPageInfo().setTotalPages(this.pageInfo.to);
                    this.page_array[n2 - this.yArea.from][n3 - this.xArea.from].setCurrentPageNumber(this.page_array[n2 - this.yArea.from][n3 - this.xArea.from].getCurrentPageNumber() + this.pageInfo.from);
                }
            }
        } else {
            for (n3 = this.yArea.from; n3 < this.yArea.to; ++n3) {
                for (n2 = this.xArea.from; n2 < this.xArea.to; ++n2) {
                    this.page_array[n3 - this.yArea.from][n2 - this.xArea.from] = this.pageSet.getPage(n2 - 1 + (n3 - 1) * this.maxXY[0]);
                    this.page_array[n3 - this.yArea.from][n2 - this.xArea.from].getPageInfo().setTotalPages(this.pageInfo.to);
                    this.page_array[n3 - this.yArea.from][n2 - this.xArea.from].setCurrentPageNumber(this.page_array[n3 - this.yArea.from][n2 - this.xArea.from].getCurrentPageNumber() + this.pageInfo.from);
                }
            }
        }
        n3 = 0;
        n2 = 0;
        for (n = 0; n < this.page_array.length; ++n) {
            n3 += this.page_array[n][0].getRowCount();
        }
        for (n = 0; n < this.page_array[0].length; ++n) {
            n2 += this.page_array[0][n].getColumnCount();
        }
        this.columnWidthList = new DynamicValueList(19, n3);
        this.rowHeightList = new DynamicValueList(19, n2);
    }

    public int getColumnWidth(int n) {
        return this.columnWidthList.get(n);
    }

    public int getRowHeight(int n) {
        return this.rowHeightList.get(n);
    }

    public Iterator cellIterator() {
        return new PageExcelCellIterator();
    }

    public Iterator floatIterator() {
        return this.floatList == null ? null : this.floatList.iterator();
    }

    public ReportHF getFooter(int n) {
        return this.sourceReport.getFooter(n);
    }

    public ReportHF getHeader(int n) {
        return this.sourceReport.getHeader(n);
    }

    public ReportPageAttr getReportPageAttr() {
        return this.sourceReport.getReportPageAttr();
    }

    public ReportSettings getReportSettings() {
        return ReportUtils.getReportSettings(this.sourceReport);
    }

    public ResultWorkBook getResultWorkBook() {
        return null;
    }

    public void setResultWorkBook(ResultWorkBook resultWorkBook) {
        throw new UnsupportedOperationException();
    }

    public FineBook getBook() {
        return null;
    }

    private class PageExcelCellIterator
    implements Iterator {
        private CellElement next;
        private Iterator current_it;
        private int current_page_y;
        private int current_page_x;
        private int current_row;
        private Point current_offset;
        private boolean[] x_checklast;

        private PageExcelCellIterator() {
            PageExcelExporterReport.this.floatList = new ArrayList();
            this.current_offset = new Point(0, 0);
            this.x_checklast = new boolean[PageExcelExporterReport.this.page_array[0].length];
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            CellElement cellElement = this.next;
            this.findNext();
            return cellElement;
        }

        private void findNext() {
            while (this.current_page_y < PageExcelExporterReport.this.page_array.length) {
                while (this.current_row < PageExcelExporterReport.this.page_array[this.current_page_y][0].getRowCount()) {
                    while (this.current_page_x < PageExcelExporterReport.this.page_array[0].length) {
                        if (this.current_it == null) {
                            int n;
                            this.current_it = PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getRow(this.current_row);
                            if (this.current_page_y == 0 && this.current_row == 0) {
                                for (n = 0; n < PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getColumnCount(); ++n) {
                                    PageExcelExporterReport.this.columnWidthList.set(this.current_offset.x + n, PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getColumnWidth(n));
                                }
                            }
                            if (this.current_page_x == 0 && this.current_row == 0) {
                                for (n = 0; n < PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getRowCount(); ++n) {
                                    PageExcelExporterReport.this.rowHeightList.set(this.current_offset.y + n, PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getRowHeight(n));
                                }
                            }
                            if (this.current_row == 0) {
                                Iterator iterator = PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].floatIterator();
                                while (iterator.hasNext()) {
                                    FloatElement floatElement = (FloatElement)iterator.next();
                                    floatElement.setRow(floatElement.getRow() + this.current_offset.y);
                                    floatElement.setColumn(floatElement.getColumn() + this.current_offset.x);
                                    PageExcelExporterReport.this.floatList.add(floatElement);
                                }
                            }
                        }
                        if (this.current_it.hasNext()) {
                            CellElement cellElement = (CellElement)this.current_it.next();
                            if (cellElement.getRow() + cellElement.getRowSpan() == PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getRowCount() && cellElement.getColumn() + cellElement.getColumnSpan() == PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getColumnCount()) {
                                if (cellElement.getCellPageAttr() != null) {
                                    try {
                                        cellElement.setCellPageAttr((CellPageAttr)cellElement.getCellPageAttr().clone());
                                    }
                                    catch (CloneNotSupportedException cloneNotSupportedException) {
                                        FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                                    }
                                } else {
                                    cellElement.setCellPageAttr(new CellPageAttr());
                                }
                                if (this.current_page_x != PageExcelExporterReport.this.page_array[0].length - 1 || this.current_page_y != PageExcelExporterReport.this.page_array.length - 1) {
                                    if (this.current_page_x == PageExcelExporterReport.this.page_array[0].length - 1) {
                                        cellElement.getCellPageAttr().setPageAfterRow(true);
                                    } else if (this.current_page_y == PageExcelExporterReport.this.page_array.length - 1) {
                                        cellElement.getCellPageAttr().setPageAfterColumn(true);
                                    } else {
                                        cellElement.getCellPageAttr().setPageAfterRow(true);
                                        cellElement.getCellPageAttr().setPageAfterColumn(true);
                                    }
                                }
                                this.x_checklast[this.current_page_x] = true;
                            }
                            cellElement.setRow(cellElement.getRow() + this.current_offset.y);
                            cellElement.setColumn(cellElement.getColumn() + this.current_offset.x);
                            this.next = cellElement;
                            return;
                        }
                        if (this.current_row == PageExcelExporterReport.this.page_array[this.current_page_y][0].getRowCount() - 1 && !this.x_checklast[this.current_page_x]) {
                            DefaultCellElement defaultCellElement = new DefaultCellElement();
                            defaultCellElement.setRow(this.current_offset.y + PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getRowCount() - 1);
                            defaultCellElement.setColumn(this.current_offset.x + PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getColumnCount() - 1);
                            defaultCellElement.setCellPageAttr(new CellPageAttr());
                            if (this.current_page_x != PageExcelExporterReport.this.page_array[0].length - 1 || this.current_page_y != PageExcelExporterReport.this.page_array.length - 1) {
                                if (this.current_page_x == PageExcelExporterReport.this.page_array[0].length - 1) {
                                    defaultCellElement.getCellPageAttr().setPageAfterRow(true);
                                } else if (this.current_page_y == PageExcelExporterReport.this.page_array.length - 1) {
                                    defaultCellElement.getCellPageAttr().setPageAfterColumn(true);
                                } else {
                                    defaultCellElement.getCellPageAttr().setPageAfterRow(true);
                                    defaultCellElement.getCellPageAttr().setPageAfterColumn(true);
                                }
                            }
                            this.x_checklast[this.current_page_x] = true;
                            this.next = defaultCellElement;
                            return;
                        }
                        this.current_it = null;
                        this.current_offset.x += PageExcelExporterReport.this.page_array[this.current_page_y][this.current_page_x].getColumnCount();
                        ++this.current_page_x;
                    }
                    this.current_page_x = 0;
                    this.current_offset.x = 0;
                    ++this.current_row;
                }
                for (int i = 0; i < this.x_checklast.length; ++i) {
                    this.x_checklast[i] = false;
                }
                this.current_offset.y += this.current_row;
                this.current_row = 0;
                ++this.current_page_y;
            }
            this.next = null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

