/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.io.pdf;

import com.fr.base.FRContext;
import com.fr.third.com.lowagie.text.ExceptionConverter;
import com.fr.third.com.lowagie.text.pdf.BaseFont;
import com.fr.third.com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;

public class MyFontMapper
implements FontMapper {
    public static final String ChineseSimplifiedFont = "STSong-Light";
    public static final String ChineseSimplifiedEncoding_H = "UniGB-UCS2-H";
    public static final String ChineseSimplifiedEncoding_V = "UniGB-UCS2-V";
    public static final String ChineseTraditionalFont_MHei = "MHei-Medium";
    public static final String ChineseTraditionalFont_MSung = "MSung-Light";
    public static final String ChineseTraditionalEncoding_H = "UniCNS-UCS2-H";
    public static final String ChineseTraditionalEncoding_V = "UniCNS-UCS2-V";
    public static final String JapaneseFont_Go = "HeiseiKakuGo-W5";
    public static final String JapaneseFont_Min = "HeiseiMin-W3";
    public static final String JapaneseEncoding_H = "UniJIS-UCS2-H";
    public static final String JapaneseEncoding_V = "UniJIS-UCS2-V";
    public static final String JapaneseEncoding_HW_H = "UniJIS-UCS2-HW-H";
    public static final String JapaneseEncoding_HW_V = "UniJIS-UCS2-HW-V";
    public static final String KoreanFont_GoThic = "HYGoThic-Medium";
    public static final String KoreanFont_SMyeongJo = "HYSMyeongJo-Medium";
    public static final String KoreanEncoding_H = "UniKS-UCS2-H";
    public static final String KoreanEncoding_V = "UniKS-UCS2-V";
    public static BaseFont defaultFont;
    private HashMap mapper = new HashMap();

    public BaseFont awtToPdf(Font font) {
        try {
            BaseFontParameters baseFontParameters = this.getBaseFontParameters(font.getFontName());
            if (baseFontParameters == null) {
                baseFontParameters = this.getBaseFontParameters(font.getName());
            }
            if (baseFontParameters != null) {
                return BaseFont.createFont((String)baseFontParameters.fontName, (String)baseFontParameters.encoding, (boolean)baseFontParameters.embedded, (boolean)baseFontParameters.cached, (byte[])baseFontParameters.ttfAfm, (byte[])baseFontParameters.pfb);
            }
            if (defaultFont != null) {
                return defaultFont;
            }
            String string = "Courier";
            if (font.isBold() && font.isItalic()) {
                string = "Courier-BoldOblique";
            } else if (font.isBold()) {
                string = "Courier-Bold";
            } else if (font.isItalic()) {
                string = "Courier-Oblique";
            }
            return BaseFont.createFont((String)string, (String)"Cp1252", (boolean)false);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            throw new ExceptionConverter(exception);
        }
    }

    public Font pdfToAwt(BaseFont baseFont, int n) {
        String string;
        String[][] stringArray = baseFont.getFullFontName();
        if (stringArray.length == 1) {
            return new Font(stringArray[0][3], 0, n);
        }
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (stringArray2[0].equals("1") && stringArray2[1].equals("0")) {
                string2 = stringArray2[3];
                continue;
            }
            if (!stringArray2[2].equals("1033")) continue;
            string3 = stringArray2[3];
            break;
        }
        if ((string = string3) == null) {
            string = string2;
        }
        if (string == null) {
            string = stringArray[0][3];
        }
        return new Font(string, 0, n);
    }

    private BaseFontParameters getBaseFontParameters(String string) {
        return (BaseFontParameters)this.mapper.get(string);
    }

    protected void insertNames(String[][] stringArray, String string) {
        Object object;
        int n;
        String string2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            if (!object[2].equals("1033")) continue;
            string2 = object[3];
            break;
        }
        if (string2 == null) {
            string2 = stringArray[0][3];
        }
        object = new BaseFontParameters(string);
        this.mapper.put(string2, object);
        for (n = 0; n < stringArray.length; ++n) {
            this.mapper.put(stringArray[n][3], object);
        }
    }

    public int insertDirectory(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            file = fileArray[i];
            String string2 = file.getPath().toLowerCase();
            try {
                String[][] stringArray;
                if (string2.endsWith(".ttf") || string2.endsWith(".otf") || string2.endsWith(".afm")) {
                    stringArray = BaseFont.getFullFontName((String)file.getPath(), (String)"Cp1252", null);
                    this.insertNames(stringArray, file.getPath());
                    ++n;
                    continue;
                }
                if (!string2.endsWith(".ttc")) continue;
                stringArray = BaseFont.enumerateTTCNames((String)file.getPath());
                for (int j = 0; j < stringArray.length; ++j) {
                    String string3 = String.valueOf(new StringBuffer(file.getPath()).append(",").append(j));
                    String[][] stringArray2 = BaseFont.getFullFontName((String)string3, (String)"Cp1252", null);
                    this.insertNames(stringArray2, string3);
                }
                ++n;
                continue;
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return n;
    }

    public static class BaseFontParameters {
        public String fontName;
        public String encoding;
        public boolean embedded;
        public boolean cached;
        public byte[] ttfAfm;
        public byte[] pfb;

        public BaseFontParameters(String string) {
            this.fontName = string;
            this.encoding = "Identity-H";
            this.embedded = true;
            this.cached = true;
        }

        public String toString() {
            return "{fontName:" + this.fontName + ",encoding:" + this.encoding + ",embedded:" + this.embedded + ",cached:" + this.cached;
        }
    }
}

